/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.EncryptedStreamUtil;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPskFileStore
implements AdvancedPskStore,
Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiPskFileStore.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<PskPublicInformation> identities = new ArrayList<PskPublicInformation>();
    private final Map<PskPublicInformation, SecretKey> keys = new HashMap<PskPublicInformation, SecretKey>();
    private final EncryptedStreamUtil encryptionUtility = new EncryptedStreamUtil();
    private volatile boolean destroyed;

    public void setCipher(String cipherAlgorithm, int keySizeBits) {
        this.encryptionUtility.setCipher(cipherAlgorithm, keySizeBits);
    }

    public MultiPskFileStore loadPskCredentials(String file) {
        try (FileInputStream in = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
            this.loadPskCredentials(reader);
        }
        catch (IOException e) {
            LOGGER.warn("read psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore loadPskCredentials(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            this.loadPskCredentials(reader);
        }
        catch (IOException e) {
            LOGGER.warn("read psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore loadPskCredentials(String file, SecretKey password) {
        try (FileInputStream in = new FileInputStream(file);){
            this.loadPskCredentials(in, password);
        }
        catch (IOException e) {
            LOGGER.warn("read psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore loadPskCredentials(InputStream in, SecretKey password) {
        try (InputStream inEncrypted = this.encryptionUtility.prepare(in, password);){
            this.loadPskCredentials(inEncrypted);
        }
        catch (IOException e) {
            LOGGER.warn("read psk-store:", (Throwable)e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiPskFileStore loadPskCredentials(Reader reader) throws IOException {
        block19: {
            BufferedReader lineReader = new BufferedReader(reader);
            try {
                String line;
                int lineNumber = 0;
                while ((line = lineReader.readLine()) != null) {
                    ++lineNumber;
                    try {
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        String[] entry = line.split("=", 2);
                        if (entry.length == 2) {
                            byte[] secretBytes = StringUtil.base64ToByteArray((String)entry[1]);
                            SecretKey key = SecretUtil.create(secretBytes, "PSK");
                            Bytes.clear((byte[])secretBytes);
                            PskPublicInformation id = new PskPublicInformation(entry[0]);
                            this.lock.writeLock().lock();
                            try {
                                if (this.keys.put(id, SecretUtil.create(key)) != null) continue;
                                this.identities.add(id);
                                continue;
                            }
                            finally {
                                this.lock.writeLock().unlock();
                                continue;
                            }
                        }
                        LOGGER.warn("{}: '{}' invalid psk-line!", (Object)lineNumber, (Object)line);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn("{}: '{}' invalid psk-line!", (Object)lineNumber, (Object)line);
                    }
                }
            }
            catch (IOException e) {
                if (e.getCause() instanceof GeneralSecurityException) {
                    LOGGER.warn("read psk-store, wrong password?:", (Throwable)e);
                    SecretUtil.destroy(this);
                    break block19;
                }
                throw e;
            }
            finally {
                try {
                    lineReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        LOGGER.info("read {} PSK credentials.", (Object)this.identities.size());
        return this;
    }

    public MultiPskFileStore savePskCredentials(String file) {
        try (FileOutputStream out = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            this.savePskCredentials(writer);
        }
        catch (IOException e) {
            LOGGER.warn("write psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore savePskCredentials(OutputStream out) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            this.savePskCredentials(writer);
        }
        catch (IOException e) {
            LOGGER.warn("write psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore savePskCredentials(String file, SecretKey password) {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.savePskCredentials(out, password);
        }
        catch (IOException e) {
            LOGGER.warn("write psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore savePskCredentials(OutputStream out, SecretKey password) {
        try (OutputStream outEncrypted = this.encryptionUtility.prepare(out, password);){
            this.savePskCredentials(outEncrypted);
        }
        catch (IOException e) {
            LOGGER.warn("write psk-store:", (Throwable)e);
        }
        return this;
    }

    public MultiPskFileStore savePskCredentials(Writer writer) throws IOException {
        for (PskPublicInformation identity : this.identities) {
            SecretKey secretKey = this.keys.get((Object)identity);
            if (secretKey == null) continue;
            byte[] key = secretKey.getEncoded();
            char[] base64 = StringUtil.byteArrayToBase64CharArray((byte[])key);
            Bytes.clear((byte[])key);
            writer.write(identity.getPublicInfoAsString());
            writer.write(61);
            writer.write(base64);
            writer.write(StringUtil.lineSeparator());
            Arrays.fill(base64, '.');
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiPskFileStore addKey(PskPublicInformation identity, SecretKey secret) {
        if (identity.getPublicInfoAsString().indexOf(61) >= 0) {
            throw new IllegalArgumentException("Identity must not contain '='!");
        }
        this.lock.writeLock().lock();
        try {
            if (this.keys.put(identity, SecretUtil.create(secret)) == null) {
                this.identities.add(identity);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this;
    }

    public MultiPskFileStore addKey(String identity, SecretKey secret) {
        return this.addKey(new PskPublicInformation(identity), secret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiPskFileStore removeKey(PskPublicInformation identity) {
        this.lock.writeLock().lock();
        try {
            if (this.keys.remove((Object)identity) != null) {
                this.identities.add(identity);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiPskFileStore removeKey(int index) {
        this.lock.writeLock().lock();
        try {
            PskPublicInformation id = this.identities.remove(index);
            if (id != null) {
                this.keys.remove((Object)id);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this;
    }

    public MultiPskFileStore removeKey(String identity) {
        return this.removeKey(new PskPublicInformation(identity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdentity(int index) {
        this.lock.readLock().lock();
        try {
            PskPublicInformation info = this.identities.get(index);
            String string = info != null ? info.getPublicInfoAsString() : null;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretKey getSecret(int index) {
        this.lock.readLock().lock();
        try {
            PskPublicInformation info = this.identities.get(index);
            if (info != null) {
                SecretKey secretKey = SecretUtil.create(this.keys.get((Object)info));
                return secretKey;
            }
            SecretKey secretKey = null;
            return secretKey;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public SecretKey getSecret(String identity) {
        return this.getSecret(new PskPublicInformation(identity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretKey getSecret(PskPublicInformation identity) {
        this.lock.readLock().lock();
        try {
            SecretKey secretKey = SecretUtil.create(this.keys.get((Object)identity));
            return secretKey;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int size() {
        return this.identities.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws DestroyFailedException {
        this.lock.writeLock().lock();
        try {
            this.identities.clear();
            for (SecretKey credentials : this.keys.values()) {
                SecretUtil.destroy(credentials);
            }
            this.keys.clear();
            this.destroyed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean hasEcdhePskSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverName, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        this.lock.readLock().lock();
        try {
            PskSecretResult pskSecretResult = new PskSecretResult(cid, identity, SecretUtil.create(this.keys.get((Object)identity)));
            return pskSecretResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        return null;
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }
}

