/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.base.RuleBase;
import org.drools.base.RuleBuildContext;
import org.drools.base.base.DroolsQuery;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueResolver;
import org.drools.base.common.DroolsObjectInputStream;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.rule.ContextEntry;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.MutableTypeConstraint;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.accessor.AcceptsReadAccessor;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.accessor.TupleValueExtractor;
import org.drools.base.rule.constraint.Constraint;
import org.drools.base.util.Drools;
import org.drools.base.util.FieldIndex;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.drools.compiler.rule.builder.EvaluatorWrapper;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.util.MessageUtils;
import org.drools.core.util.bitmask.BitMask;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.mvel.ASMConditionEvaluatorJitter;
import org.drools.mvel.ConditionAnalyzer;
import org.drools.mvel.ConditionEvaluator;
import org.drools.mvel.ConstraintEvaluationException;
import org.drools.mvel.MVELConditionEvaluator;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.accessors.ClassFieldReader;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.extractors.MVELObjectClassFieldReader;
import org.drools.util.ClassUtils;
import org.drools.util.StringUtils;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.concurrent.ExecutorProviderFactory;
import org.kie.internal.conf.ConstraintJittingThresholdOption;
import org.mvel2.ParserConfiguration;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELConstraint
extends MutableTypeConstraint
implements IndexableConstraint,
AcceptsReadAccessor {
    protected static final boolean TEST_JITTING = false;
    private static final Logger logger = LoggerFactory.getLogger(MVELConstraint.class);
    protected final transient AtomicInteger invocationCounter = new AtomicInteger(1);
    protected volatile transient boolean jitted = false;
    private Set<String> packageNames;
    protected String expression;
    private ConstraintTypeOperator constraintType = ConstraintTypeOperator.UNKNOWN;
    private Declaration[] declarations;
    private EvaluatorWrapper[] operators;
    private TupleValueExtractor indexingDeclaration;
    private ReadAccessor extractor;
    private boolean isUnification;
    protected boolean isDynamic;
    private FieldValue fieldValue;
    protected MVELCompilationUnit compilationUnit;
    private EvaluationContext evaluationContext = new EvaluationContext();
    protected volatile transient ConditionEvaluator conditionEvaluator;
    private volatile transient ConditionAnalyzer.Condition analyzedCondition;
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];
    private static final EvaluatorWrapper[] EMPTY_OPERATORS = new EvaluatorWrapper[0];

    public MVELConstraint() {
    }

    public MVELConstraint(String packageName, String expression, MVELCompilationUnit compilationUnit, ConstraintTypeOperator constraintType, FieldValue fieldValue, ReadAccessor extractor, EvaluatorWrapper[] operators) {
        this.packageNames = new LinkedHashSet<String>();
        this.packageNames.add(packageName);
        this.expression = expression;
        this.compilationUnit = compilationUnit;
        this.constraintType = constraintType;
        this.declarations = EMPTY_DECLARATIONS;
        this.operators = operators == null ? EMPTY_OPERATORS : operators;
        this.fieldValue = fieldValue;
        this.extractor = extractor;
    }

    public MVELConstraint(String packageName, String expression, Declaration[] declarations, EvaluatorWrapper[] operators, MVELCompilationUnit compilationUnit, boolean isDynamic) {
        this.packageNames = new LinkedHashSet<String>();
        this.packageNames.add(packageName);
        this.expression = expression;
        this.declarations = declarations == null ? EMPTY_DECLARATIONS : declarations;
        this.operators = operators == null ? EMPTY_OPERATORS : operators;
        this.compilationUnit = compilationUnit;
        this.isDynamic = isDynamic;
    }

    public MVELConstraint(Collection<String> packageNames, String expression, Declaration[] declarations, EvaluatorWrapper[] operators, MVELCompilationUnit compilationUnit, ConstraintTypeOperator constraintType, TupleValueExtractor indexingDeclaration, ReadAccessor extractor, boolean isUnification) {
        this.packageNames = new LinkedHashSet<String>(packageNames);
        this.expression = expression;
        this.compilationUnit = compilationUnit;
        this.constraintType = indexingDeclaration != null ? constraintType : ConstraintTypeOperator.UNKNOWN;
        this.declarations = declarations == null ? EMPTY_DECLARATIONS : declarations;
        this.operators = operators == null ? EMPTY_OPERATORS : operators;
        this.indexingDeclaration = indexingDeclaration;
        this.extractor = extractor;
        this.isUnification = isUnification;
    }

    protected String getAccessedClass() {
        return this.extractor instanceof ClassFieldReader ? ((ClassFieldReader)this.extractor).getClassName() : (this.extractor instanceof MVELObjectClassFieldReader ? ((MVELObjectClassFieldReader)this.extractor).getClassName() : null);
    }

    public void setReadAccessor(ReadAccessor readAccessor) {
        this.extractor = readAccessor;
    }

    public Collection<String> getPackageNames() {
        return this.packageNames;
    }

    public void addPackageNames(Collection<String> otherPkgs) {
        this.packageNames.addAll(otherPkgs);
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean isUnification() {
        return this.isUnification;
    }

    public void unsetUnification() {
        this.isUnification = false;
    }

    public boolean isIndexable(short nodeType, KieBaseConfiguration config) {
        return this.getConstraintType().isIndexableForNode(nodeType, (IndexableConstraint)this, config);
    }

    public ConstraintTypeOperator getConstraintType() {
        return this.constraintType;
    }

    public FieldValue getField() {
        return this.fieldValue;
    }

    public boolean isAllowed(FactHandle handle, ValueResolver valueResolver) {
        if (this.isUnification) {
            throw new UnsupportedOperationException("Should not be called");
        }
        return this.evaluate(handle, valueResolver, null);
    }

    public boolean isAllowedCachedLeft(ContextEntry context, FactHandle handle) {
        if (this.isUnification) {
            if (((UnificationContextEntry)context).getVariable() != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.evaluate(handle, mvelContextEntry.valueResolver, mvelContextEntry.tuple);
    }

    public boolean isAllowedCachedRight(BaseTuple tuple, ContextEntry context) {
        if (this.isUnification) {
            DroolsQuery query = (DroolsQuery)tuple.get(0).getObject();
            Variable v = query.getVariables()[((UnificationContextEntry)context).getReader().getIndex()];
            if (v != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.evaluate(mvelContextEntry.rightHandle, mvelContextEntry.valueResolver, tuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean evaluate(FactHandle handle, ValueResolver valueResolver, BaseTuple tuple) {
        if (!this.jitted) {
            int jittingThreshold = ((ConstraintJittingThresholdOption)valueResolver.getRuleBase().getConfiguration().getOption(ConstraintJittingThresholdOption.KEY)).getThreshold();
            if (this.conditionEvaluator == null) {
                if (jittingThreshold == 0 && !this.isDynamic) {
                    MVELConstraint mVELConstraint = this;
                    synchronized (mVELConstraint) {
                        if (this.conditionEvaluator == null) {
                            this.conditionEvaluator = this.forceJitEvaluator(handle, valueResolver, tuple);
                        }
                    }
                } else {
                    this.conditionEvaluator = this.createMvelConditionEvaluator(valueResolver);
                }
            }
            if (jittingThreshold != 0 && !this.isDynamic && this.invocationCounter.getAndIncrement() == jittingThreshold) {
                this.jitEvaluator(handle, valueResolver, tuple);
            }
        }
        try {
            return this.conditionEvaluator.evaluate(handle, valueResolver, tuple);
        }
        catch (Exception e) {
            throw new ConstraintEvaluationException(this.expression, this.evaluationContext, e);
        }
    }

    protected ConditionEvaluator createMvelConditionEvaluator(ValueResolver valueResolver) {
        if (this.compilationUnit != null) {
            MVELDialectRuntimeData data = this.getMVELDialectRuntimeData(valueResolver);
            ExecutableStatement statement = (ExecutableStatement)this.compilationUnit.getCompiledExpression(data, (Object)this.evaluationContext);
            ParserConfiguration configuration = statement instanceof CompiledExpression ? ((CompiledExpression)statement).getParserConfiguration() : data.getParserConfiguration();
            return new MVELConditionEvaluator(this.compilationUnit, configuration, statement, this.declarations, this.operators, this.getAccessedClass());
        }
        return new MVELConditionEvaluator(this.getParserConfiguration(valueResolver), this.expression, this.declarations, this.operators, this.getAccessedClass());
    }

    protected ConditionEvaluator forceJitEvaluator(FactHandle handle, ValueResolver valueResolver, BaseTuple tuple) {
        ConditionEvaluator mvelEvaluator = this.createMvelConditionEvaluator(valueResolver);
        try {
            mvelEvaluator.evaluate(handle, valueResolver, tuple);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception e) {
            return this.createMvelConditionEvaluator(valueResolver);
        }
        return this.executeJitting(handle, valueResolver, tuple, mvelEvaluator);
    }

    protected void jitEvaluator(FactHandle handle, ValueResolver valueResolver, BaseTuple tuple) {
        this.jitted = true;
        ExecutorHolder.executor.execute(new ConditionJitter(this, handle, valueResolver, tuple));
    }

    private ConditionEvaluator executeJitting(FactHandle handle, ValueResolver valueResolver, BaseTuple tuple, ConditionEvaluator mvelEvaluator) {
        RuleBase kBase = valueResolver.getRuleBase();
        if (!Drools.isJmxAvailable()) {
            return mvelEvaluator;
        }
        try {
            if (this.analyzedCondition == null) {
                this.analyzedCondition = ((MVELConditionEvaluator)mvelEvaluator).getAnalyzedCondition(handle, valueResolver, tuple);
            }
            ClassLoader jitClassLoader = kBase.getRootClassLoader() instanceof ProjectClassLoader ? ((ProjectClassLoader)kBase.getRootClassLoader()).getTypesClassLoader() : kBase.getRootClassLoader();
            return ASMConditionEvaluatorJitter.jitEvaluator(this.expression, this.analyzedCondition, this.declarations, this.operators, jitClassLoader, tuple);
        }
        catch (Throwable t) {
            logger.warn("Exception jitting: {}. This is NOT an error and NOT prevent the correct execution since the constraint will be evaluated in intrepreted mode", (Object)this.expression);
            return mvelEvaluator;
        }
    }

    public ContextEntry createContextEntry() {
        if (this.declarations.length == 0) {
            return null;
        }
        Object contextEntry = new MvelContextEntry(this.declarations);
        if (this.isUnification) {
            contextEntry = new UnificationContextEntry((ContextEntry)contextEntry, this.declarations[0]);
        }
        return contextEntry;
    }

    public FieldIndex getFieldIndex() {
        return new FieldIndex(this.extractor, this.indexingDeclaration);
    }

    public ReadAccessor getFieldExtractor() {
        return this.extractor;
    }

    public TupleValueExtractor getIndexExtractor() {
        return this.indexingDeclaration;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public EvaluatorWrapper[] getOperators() {
        return this.operators;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.declarations[i].equals((Object)oldDecl)) continue;
            if (this.compilationUnit != null) {
                this.compilationUnit.replaceDeclaration(this.declarations[i], newDecl);
            }
            this.declarations[i] = newDecl;
            if (this.indexingDeclaration == null || i != 0) break;
            if (!this.indexingDeclaration.equals(oldDecl)) {
                this.indexingDeclaration = this.indexingDeclaration.clone();
                ((Declaration)this.indexingDeclaration).setPattern(newDecl.getPattern());
                break;
            }
            this.indexingDeclaration = newDecl;
            break;
        }
    }

    public BitMask getListenedPropertyMask(Optional<Pattern> pattern, ObjectType modifiedType, List<String> settableProperties) {
        return this.analyzedCondition != null ? this.calculateMask(modifiedType, settableProperties) : this.calculateMaskFromExpression(pattern, settableProperties);
    }

    private BitMask calculateMaskFromExpression(Optional<Pattern> pattern, List<String> settableProperties) {
        String[] simpleExpressions;
        BitMask mask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size());
        for (String simpleExpression : simpleExpressions = this.expression.split("\\Q&&\\E|\\Q||\\E")) {
            List<String> properties = this.getPropertyNamesFromSimpleExpression(simpleExpression);
            if (properties.isEmpty()) {
                return PropertySpecificUtil.allSetBitMask();
            }
            boolean firstProp = true;
            Iterator<String> iterator = properties.iterator();
            while (iterator.hasNext()) {
                String string;
                String originalPropertyName = string = iterator.next();
                if (string == null || string.equals("this") || string.length() == 0) {
                    return PropertySpecificUtil.allSetButTraitBitMask();
                }
                int pos = settableProperties.indexOf(string);
                if (pos < 0) {
                    if (Character.isUpperCase(string.charAt(0))) {
                        String string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
                        pos = settableProperties.indexOf(string2);
                    } else {
                        String string3 = this.findBoundVariable(string, pattern);
                        if (string3 != null) {
                            pos = settableProperties.indexOf(string3);
                        }
                    }
                }
                if (pos >= 0) {
                    mask = mask.set(pos + 1);
                } else if (firstProp) {
                    if (this.isBoundVariableFromDifferentPattern(originalPropertyName, pattern)) {
                        logger.warn("{} is not relevant to this pattern, so it causes class reactivity. Consider placing this constraint in the original pattern if possible : {}", (Object)originalPropertyName, (Object)simpleExpression);
                    }
                    return PropertySpecificUtil.allSetBitMask();
                }
                firstProp = false;
            }
        }
        return mask;
    }

    private String findBoundVariable(String variable, Optional<Pattern> pattern) {
        for (Declaration declaration : this.declarations) {
            ReadAccessor accessor;
            if (!declaration.getIdentifier().equals(variable) || pattern.isPresent() && !declaration.getPattern().equals((Object)pattern.get()) || !((accessor = declaration.getExtractor()) instanceof ClassFieldReader)) continue;
            return ((ClassFieldReader)accessor).getFieldName();
        }
        return null;
    }

    private boolean isBoundVariableFromDifferentPattern(String variable, Optional<Pattern> pattern) {
        if (!pattern.isPresent()) {
            return false;
        }
        for (Declaration declaration : this.declarations) {
            if (!declaration.getIdentifier().equals(variable) || declaration.getPattern().equals((Object)pattern.get())) continue;
            return true;
        }
        return false;
    }

    private List<String> getPropertyNamesFromSimpleExpression(String expression) {
        ArrayList<String> names = new ArrayList<String>();
        int cursor = 0;
        while (cursor < expression.length()) {
            cursor = this.nextPropertyName(expression, names, cursor);
        }
        return names;
    }

    private int nextPropertyName(String expression, List<String> names, int cursor) {
        StringBuilder propertyNameBuilder = new StringBuilder();
        cursor = StringUtils.extractFirstIdentifier((String)expression, (StringBuilder)propertyNameBuilder, (int)cursor);
        if (propertyNameBuilder.length() == 0) {
            return cursor;
        }
        boolean isAccessor = false;
        String propertyName = propertyNameBuilder.toString();
        if (propertyName.equals("this")) {
            if ((cursor = StringUtils.skipBlanks((String)expression, (int)cursor)) >= expression.length() || expression.charAt(cursor) != '.') {
                names.add("this");
                return cursor;
            }
            propertyNameBuilder = new StringBuilder();
            StringUtils.extractFirstIdentifier((String)expression, (StringBuilder)propertyNameBuilder, (int)cursor);
            propertyName = propertyNameBuilder.toString();
        } else if (propertyName.equals("null") || propertyName.equals("true") || propertyName.equals("false")) {
            propertyNameBuilder = new StringBuilder();
            StringUtils.extractFirstIdentifier((String)expression, (StringBuilder)propertyNameBuilder, (int)cursor);
            propertyName = propertyNameBuilder.toString();
        }
        if (propertyName.startsWith("is") || propertyName.startsWith("get")) {
            int argsEnd;
            int exprPos = expression.indexOf(propertyName);
            int propNameEnd = exprPos + propertyName.length();
            if (expression.length() > propNameEnd + 1 && expression.charAt(propNameEnd) == '(' && expression.substring(propNameEnd + 1, argsEnd = expression.indexOf(41, propNameEnd)).trim().isEmpty()) {
                propertyName = ClassUtils.getter2property((String)propertyName);
                isAccessor = true;
            }
        }
        if (!isAccessor) {
            boolean isMethodInvocation;
            Character lookAhead = StringUtils.lookAheadIgnoringSpaces((String)expression, (int)cursor);
            boolean bl = isMethodInvocation = lookAhead != null && lookAhead.equals(Character.valueOf('('));
            if (isMethodInvocation) {
                return this.nextPropertyName(expression, names, cursor);
            }
        }
        if (propertyName != null && propertyName.length() > 0) {
            names.add(propertyName);
        }
        return this.skipOperator(expression, cursor);
    }

    private int skipOperator(String expression, int cursor) {
        int i;
        if (cursor < expression.length() && expression.charAt(cursor) == '.') {
            while (cursor < expression.length() && Character.isWhitespace(expression.charAt(++cursor))) {
            }
        }
        boolean namedOperator = false;
        for (i = cursor; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (Character.isJavaIdentifierStart(ch)) {
                namedOperator = true;
                continue;
            }
            if (!(Character.isWhitespace(ch) ? namedOperator : !Character.isJavaIdentifierPart(ch))) continue;
            return i + 1;
        }
        return i;
    }

    private BitMask calculateMask(ObjectType modifiedType, List<String> settableProperties) {
        BitMask mask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size());
        if (this.analyzedCondition instanceof ConditionAnalyzer.SingleCondition) {
            mask = this.setPropertyOnReactiveMask(modifiedType, settableProperties, mask, (ConditionAnalyzer.SingleCondition)this.analyzedCondition);
        } else {
            for (ConditionAnalyzer.Condition c : ((ConditionAnalyzer.CombinedCondition)this.analyzedCondition).getConditions()) {
                mask = this.setPropertyOnReactiveMask(modifiedType, settableProperties, mask, (ConditionAnalyzer.SingleCondition)c);
            }
        }
        return mask;
    }

    private BitMask setPropertyOnReactiveMask(ObjectType modifiedType, List<String> settableProperties, BitMask mask, ConditionAnalyzer.SingleCondition c) {
        String propertyName = this.getFirstInvokedPropertyName(modifiedType, c.getLeft());
        return propertyName != null ? PropertySpecificUtil.setPropertyOnMask((String)modifiedType.getClassName(), (BitMask)mask, settableProperties, (String)propertyName) : PropertySpecificUtil.allSetBitMask();
    }

    private String getFirstInvokedPropertyName(ObjectType modifiedType, ConditionAnalyzer.Expression expression) {
        if (!(expression instanceof ConditionAnalyzer.EvaluatedExpression)) {
            return null;
        }
        List<ConditionAnalyzer.Invocation> invocations = ((ConditionAnalyzer.EvaluatedExpression)expression).invocations;
        ConditionAnalyzer.Invocation invocation = invocations.get(0);
        if (invocation instanceof ConditionAnalyzer.MethodInvocation) {
            Method method = ((ConditionAnalyzer.MethodInvocation)invocation).getMethod();
            if (method == null) {
                if (invocations.size() > 1) {
                    invocation = invocations.get(1);
                    if (invocation instanceof ConditionAnalyzer.MethodInvocation) {
                        method = ((ConditionAnalyzer.MethodInvocation)invocation).getMethod();
                    } else if (invocation instanceof ConditionAnalyzer.FieldAccessInvocation) {
                        return ((ConditionAnalyzer.FieldAccessInvocation)invocation).getField().getName();
                    }
                } else {
                    return null;
                }
            }
            return method != null && !Modifier.isStatic(method.getModifiers()) && modifiedType.isAssignableTo(method.getDeclaringClass()) ? ClassUtils.getter2property((String)method.getName()) : null;
        }
        if (invocation instanceof ConditionAnalyzer.FieldAccessInvocation) {
            return ((ConditionAnalyzer.FieldAccessInvocation)invocation).getField().getName();
        }
        return null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.packageNames);
        out.writeObject(this.expression);
        if (this.extractor instanceof ClassFieldReader) {
            out.writeObject(((ClassFieldReader)this.extractor).getAccessorKey());
        } else {
            out.writeObject(this.extractor);
        }
        out.writeObject(this.indexingDeclaration);
        out.writeObject(this.declarations);
        out.writeObject(this.constraintType);
        out.writeBoolean(this.isUnification);
        out.writeBoolean(this.isDynamic);
        out.writeObject(this.fieldValue);
        out.writeObject(this.compilationUnit);
        out.writeObject(this.evaluationContext);
        out.writeObject(this.operators);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.packageNames = (Set)in.readObject();
        this.expression = (String)in.readObject();
        if (in instanceof DroolsObjectInputStream) {
            ((DroolsObjectInputStream)in).readExtractor(this::setReadAccessor);
        } else {
            this.extractor = (ReadAccessor)in.readObject();
        }
        this.indexingDeclaration = (Declaration)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.constraintType = (ConstraintTypeOperator)in.readObject();
        this.isUnification = in.readBoolean();
        this.isDynamic = in.readBoolean();
        this.fieldValue = (FieldValue)in.readObject();
        this.compilationUnit = (MVELCompilationUnit)in.readObject();
        this.evaluationContext = (EvaluationContext)in.readObject();
        this.operators = (EvaluatorWrapper[])in.readObject();
    }

    public boolean isTemporal() {
        return false;
    }

    public MVELConstraint cloneIfInUse() {
        MVELConstraint clone = (MVELConstraint)super.cloneIfInUse();
        if (clone != this) {
            clone.conditionEvaluator = null;
        }
        return clone;
    }

    public MVELConstraint clone() {
        Declaration[] clonedDeclarations = new Declaration[this.declarations.length];
        System.arraycopy(this.declarations, 0, clonedDeclarations, 0, this.declarations.length);
        MVELConstraint clone = new MVELConstraint();
        clone.setType(this.getType());
        clone.packageNames = this.packageNames;
        clone.expression = this.expression;
        clone.fieldValue = this.fieldValue;
        clone.constraintType = this.constraintType;
        clone.declarations = clonedDeclarations;
        clone.operators = this.operators;
        if (this.indexingDeclaration != null) {
            clone.indexingDeclaration = this.indexingDeclaration.clone();
        }
        clone.extractor = this.extractor;
        clone.isUnification = this.isUnification;
        clone.isDynamic = this.isDynamic;
        clone.conditionEvaluator = this.conditionEvaluator;
        clone.compilationUnit = this.compilationUnit != null ? this.compilationUnit.clone() : null;
        return clone;
    }

    public int hashCode() {
        if (this.isAlphaHashable()) {
            return 29 * this.getLeftInExpression(ConstraintTypeOperator.EQUAL).hashCode() + 31 * this.fieldValue.hashCode();
        }
        return this.expression.hashCode();
    }

    private String getLeftInExpression(ConstraintTypeOperator constraint) {
        return this.expression.substring(0, StringUtils.codeAwareIndexOf((String)this.expression, (String)constraint.getOperator())).trim();
    }

    private boolean isAlphaHashable() {
        return this.fieldValue != null && this.constraintType == ConstraintTypeOperator.EQUAL && this.getType() == Constraint.ConstraintType.ALPHA;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != MVELConstraint.class) {
            return false;
        }
        MVELConstraint other = (MVELConstraint)((Object)object);
        if (this.isAlphaHashable() ? !other.isAlphaHashable() || !this.getLeftInExpression(ConstraintTypeOperator.EQUAL).equals(other.getLeftInExpression(ConstraintTypeOperator.EQUAL)) || !this.fieldValue.equals(other.fieldValue) : !StringUtils.equalsIgnoreSpaces((String)this.expression, (String)other.expression)) {
            return false;
        }
        if (this.declarations.length != other.declarations.length) {
            return false;
        }
        for (int i = 0; i < this.declarations.length; ++i) {
            if (this.declarations[i].getExtractor().equals(other.declarations[i].getExtractor())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object, RuleBase kbase) {
        String otherPkg;
        if (!this.equals(object)) {
            return false;
        }
        String thisPkg = this.packageNames.iterator().next();
        if (thisPkg.equals(otherPkg = ((MVELConstraint)((Object)object)).packageNames.iterator().next())) {
            return true;
        }
        Map<String, Object> thisImports = ((MVELDialectRuntimeData)((KnowledgeBaseImpl)kbase).getPackage(thisPkg).getDialectRuntimeRegistry().getDialectData("mvel")).getImports();
        Map<String, Object> otherImports = ((MVELDialectRuntimeData)((KnowledgeBaseImpl)kbase).getPackage(otherPkg).getDialectRuntimeRegistry().getDialectData("mvel")).getImports();
        if (this.fieldValue != null && this.constraintType.getOperator() != null) {
            return this.equalsExpressionTokensInBothImports(this.getLeftInExpression(this.constraintType), thisImports, otherImports);
        }
        return this.equalsExpressionTokensInBothImports(this.expression, thisImports, otherImports);
    }

    private boolean equalsExpressionTokensInBothImports(String expression, Map<String, Object> thisImports, Map<String, Object> otherImports) {
        for (String token : MVELConstraint.splitExpression(expression)) {
            if (Objects.equals(thisImports.get(token), otherImports.get(token))) continue;
            return false;
        }
        return true;
    }

    private static List<String> splitExpression(String expression) {
        ArrayList<String> tokens = new ArrayList<String>();
        int lastStart = -1;
        boolean isQuoted = false;
        for (int i = 0; i < expression.length(); ++i) {
            if (lastStart == -1) {
                if (!isQuoted && Character.isJavaIdentifierStart(expression.charAt(i))) {
                    lastStart = i;
                }
            } else if (!Character.isJavaIdentifierPart(expression.charAt(i))) {
                tokens.add(expression.subSequence(lastStart, i).toString());
                lastStart = -1;
            }
            if (expression.charAt(i) != '\"' && expression.charAt(i) != '\'') continue;
            if (i == 0 || expression.charAt(i - 1) != '\\') {
                boolean bl = isQuoted = !isQuoted;
            }
            if (!isQuoted) continue;
            lastStart = -1;
        }
        if (lastStart != -1) {
            tokens.add(expression.subSequence(lastStart, expression.length()).toString());
        }
        return tokens;
    }

    public String toString() {
        return this.expression;
    }

    protected ParserConfiguration getParserConfiguration(ValueResolver valueResolver) {
        return this.getMVELDialectRuntimeData(valueResolver).getParserConfiguration();
    }

    protected MVELDialectRuntimeData getMVELDialectRuntimeData(ValueResolver valueResolver) {
        return this.getMVELDialectRuntimeData(valueResolver.getRuleBase());
    }

    protected MVELDialectRuntimeData getMVELDialectRuntimeData(RuleBase kbase) {
        for (String packageName : this.packageNames) {
            InternalKnowledgePackage pkg = ((InternalKnowledgeBase)kbase).getPackage(packageName);
            if (pkg == null) continue;
            return (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("mvel");
        }
        return null;
    }

    public void registerEvaluationContext(RuleBuildContext buildContext) {
        this.evaluationContext.addContext(buildContext);
    }

    public void mergeEvaluationContext(Constraint other) {
        if (other instanceof MVELConstraint) {
            this.evaluationContext.mergeRuleNameMap(((MVELConstraint)other).getEvaluationContext().getRuleNameMap());
        }
    }

    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    public static class EvaluationContext
    implements Externalizable {
        private Map<String, Set<String>> ruleNameMap = new HashMap<String, Set<String>>();
        public static final int MAX_RULE_DEFS = Integer.getInteger("drools.evaluationContext.maxRuleDefs", 10);
        private boolean moreThanMaxRuleDefs = false;

        public void addContext(RuleBuildContext buildContext) {
            if (this.moreThanMaxRuleDefs || this.ruleNameMap.values().stream().mapToLong(Collection::size).sum() >= (long)MAX_RULE_DEFS) {
                this.moreThanMaxRuleDefs = true;
                return;
            }
            RuleImpl rule = buildContext.getRule();
            String ruleName = MessageUtils.defaultToEmptyString((String)rule.getName());
            String ruleFileName = MessageUtils.defaultToEmptyString(rule.getResource() != null ? rule.getResource().getSourcePath() : null);
            this.ruleNameMap.computeIfAbsent(ruleFileName, k -> new HashSet()).add(ruleName);
        }

        public void mergeRuleNameMap(Map<String, Set<String>> otherMap) {
            if (this.moreThanMaxRuleDefs || this.ruleNameMap.values().stream().mapToLong(Collection::size).sum() >= (long)MAX_RULE_DEFS) {
                this.moreThanMaxRuleDefs = true;
                return;
            }
            otherMap.forEach((otherRuleFileName, otherRuleNameSet) -> this.ruleNameMap.merge((String)otherRuleFileName, (Set<String>)otherRuleNameSet, (thisSet, otherSet) -> {
                thisSet.addAll(otherSet);
                return thisSet;
            }));
        }

        public Map<String, Set<String>> getRuleNameMap() {
            return this.ruleNameMap;
        }

        public boolean isMoreThanMaxRuleDefs() {
            return this.moreThanMaxRuleDefs;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.ruleNameMap);
            out.writeBoolean(this.moreThanMaxRuleDefs);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ruleNameMap = (Map)in.readObject();
            this.moreThanMaxRuleDefs = in.readBoolean();
        }

        public String toString() {
            return "EvaluationContext [ruleNameMap=" + this.ruleNameMap + ", moreThanMaxRuleDefs=" + this.moreThanMaxRuleDefs + "]";
        }
    }

    public static class UnificationContextEntry
    implements ContextEntry {
        private ContextEntry contextEntry;
        private Declaration declaration;
        private Variable variable;
        private ReadAccessor reader;

        public UnificationContextEntry() {
        }

        public UnificationContextEntry(ContextEntry contextEntry, Declaration declaration) {
            this.contextEntry = contextEntry;
            this.declaration = declaration;
            this.reader = this.declaration.getExtractor();
        }

        public ContextEntry getContextEntry() {
            return this.contextEntry;
        }

        public ReadAccessor getReader() {
            return this.reader;
        }

        public ContextEntry getNext() {
            return this.contextEntry.getNext();
        }

        public void resetFactHandle() {
            this.contextEntry.resetFactHandle();
        }

        public void resetTuple() {
            this.contextEntry.resetTuple();
            this.variable = null;
        }

        public void setNext(ContextEntry entry) {
            this.contextEntry.setNext(entry);
        }

        public void updateFromFactHandle(ValueResolver valueResolver, FactHandle handle) {
            this.contextEntry.updateFromFactHandle(valueResolver, handle);
        }

        public void updateFromTuple(ValueResolver valueResolver, BaseTuple tuple) {
            DroolsQuery query = (DroolsQuery)tuple.getObject(0);
            this.variable = query.getVariables()[this.reader.getIndex()];
            if (this.variable == null) {
                this.contextEntry.updateFromTuple(valueResolver, tuple);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.contextEntry = (ContextEntry)in.readObject();
            this.declaration = (Declaration)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.contextEntry);
            out.writeObject(this.declaration);
        }

        public Variable getVariable() {
            return this.variable;
        }
    }

    public static class MvelContextEntry
    implements ContextEntry {
        protected ContextEntry next;
        protected BaseTuple tuple;
        protected FactHandle rightHandle;
        protected Declaration[] declarations;
        protected transient ValueResolver valueResolver;

        public MvelContextEntry() {
        }

        public MvelContextEntry(Declaration[] declarations) {
            this.declarations = declarations;
        }

        public ContextEntry getNext() {
            return this.next;
        }

        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        public void updateFromTuple(ValueResolver valueResolver, BaseTuple tuple) {
            this.tuple = tuple;
            this.valueResolver = valueResolver;
        }

        public void updateFromFactHandle(ValueResolver valueResolver, FactHandle handle) {
            this.valueResolver = valueResolver;
            this.rightHandle = handle;
        }

        public void resetTuple() {
            this.tuple = null;
        }

        public void resetFactHandle() {
            this.valueResolver = null;
            this.rightHandle = null;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.tuple);
            out.writeObject(this.rightHandle);
            out.writeObject(this.declarations);
            out.writeObject(this.next);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.tuple = (BaseTuple)in.readObject();
            this.rightHandle = (FactHandle)in.readObject();
            this.declarations = (Declaration[])in.readObject();
            this.next = (ContextEntry)in.readObject();
        }

        public FactHandle getRight() {
            return this.rightHandle;
        }

        public Declaration[] getDeclarations() {
            return this.declarations;
        }
    }

    private static class ExecutorHolder {
        private static final Executor executor = ExecutorProviderFactory.getExecutorProvider().getExecutor();

        private ExecutorHolder() {
        }
    }

    private static class ConditionJitter
    implements Runnable {
        private MVELConstraint mvelConstraint;
        private FactHandle rightHandle;
        private ValueResolver valueResolver;
        private BaseTuple tuple;

        private ConditionJitter(MVELConstraint mvelConstraint, FactHandle rightHandle, ValueResolver valueResolver, BaseTuple tuple) {
            this.mvelConstraint = mvelConstraint;
            this.rightHandle = rightHandle;
            this.valueResolver = valueResolver;
            this.tuple = tuple;
        }

        @Override
        public void run() {
            this.mvelConstraint.conditionEvaluator = this.mvelConstraint.executeJitting(this.rightHandle, this.valueResolver, this.tuple, this.mvelConstraint.conditionEvaluator);
            this.mvelConstraint = null;
            this.rightHandle = null;
            this.valueResolver = null;
            this.tuple = null;
        }
    }
}

