/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.spring.server.config;

import org.dromara.mica.mqtt.core.deserialize.MqttDeserializer;
import org.dromara.mica.mqtt.core.deserialize.MqttJsonDeserializer;
import org.dromara.mica.mqtt.core.server.MqttServer;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.MqttServerCustomizer;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerAuthHandler;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerPublishPermission;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerSubscribeValidator;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerUniqueIdService;
import org.dromara.mica.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import org.dromara.mica.mqtt.core.server.event.IMqttConnectStatusListener;
import org.dromara.mica.mqtt.core.server.event.IMqttMessageListener;
import org.dromara.mica.mqtt.core.server.event.IMqttSessionListener;
import org.dromara.mica.mqtt.core.server.func.MqttFunctionManager;
import org.dromara.mica.mqtt.core.server.func.MqttFunctionMessageListener;
import org.dromara.mica.mqtt.core.server.interceptor.IMqttMessageInterceptor;
import org.dromara.mica.mqtt.core.server.session.IMqttSessionManager;
import org.dromara.mica.mqtt.core.server.store.IMqttMessageStore;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttServerAuthHandler;
import org.dromara.mica.mqtt.spring.server.MqttServerFunctionDetector;
import org.dromara.mica.mqtt.spring.server.MqttServerTemplate;
import org.dromara.mica.mqtt.spring.server.config.MqttServerLauncher;
import org.dromara.mica.mqtt.spring.server.config.MqttServerProperties;
import org.dromara.mica.mqtt.spring.server.event.SpringEventMqttConnectStatusListener;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tio.core.Node;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="mqtt.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={MqttServerProperties.class})
public class MqttServerConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MqttDeserializer mqttDeserializer() {
        return new MqttJsonDeserializer();
    }

    @Bean
    @ConditionalOnMissingBean
    public IMqttConnectStatusListener springEventMqttConnectStatusListener(ApplicationEventPublisher eventPublisher) {
        return new SpringEventMqttConnectStatusListener(eventPublisher);
    }

    @Bean
    public MqttServerCreator mqttServerCreator(MqttServerProperties properties, ObjectProvider<IMqttServerAuthHandler> authHandlerObjectProvider, ObjectProvider<IMqttServerUniqueIdService> uniqueIdServiceObjectProvider, ObjectProvider<IMqttServerSubscribeValidator> subscribeValidatorObjectProvider, ObjectProvider<IMqttServerPublishPermission> publishPermissionObjectProvider, ObjectProvider<IMqttMessageDispatcher> messageDispatcherObjectProvider, ObjectProvider<IMqttMessageStore> messageStoreObjectProvider, ObjectProvider<IMqttSessionManager> sessionManagerObjectProvider, ObjectProvider<IMqttSessionListener> sessionListenerObjectProvider, ObjectProvider<IMqttMessageListener> messageListenerObjectProvider, ObjectProvider<IMqttConnectStatusListener> connectStatusListenerObjectProvider, ObjectProvider<IMqttMessageInterceptor> messageInterceptorObjectProvider, ObjectProvider<MqttServerCustomizer> customizers) {
        MqttServerProperties.HttpListener httpListener;
        MqttServerProperties.Listener wsListener;
        MqttServerProperties.SslListener mqttSslListener;
        MqttServerProperties.Listener mqttListener;
        MqttServerCreator serverCreator = MqttServer.create().name(properties.getName()).heartbeatTimeout(properties.getHeartbeatTimeout()).keepaliveBackoff(properties.getKeepaliveBackoff()).readBufferSize((int)properties.getReadBufferSize().toBytes()).maxBytesInMessage((int)properties.getMaxBytesInMessage().toBytes()).maxClientIdLength(properties.getMaxClientIdLength()).nodeName(properties.getNodeName()).statEnable(properties.isStatEnable()).proxyProtocolEnable(properties.isProxyProtocolOn());
        if (properties.isDebug()) {
            serverCreator.debug();
        }
        if ((mqttListener = properties.getMqttListener()).isEnable()) {
            serverCreator.enableMqtt(builder -> builder.serverNode(mqttListener.getServerNode()).build());
        }
        if ((mqttSslListener = properties.getMqttSslListener()).isEnable()) {
            MqttServerProperties.Ssl ssl = mqttSslListener.getSsl();
            serverCreator.enableMqttSsl(sslBuilder -> sslBuilder.serverNode(mqttSslListener.getServerNode()).useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass(), ssl.getClientAuth()).build());
        }
        if ((wsListener = properties.getWsListener()).isEnable()) {
            serverCreator.enableMqttWs(builder -> builder.serverNode(wsListener.getServerNode()).build());
        }
        MqttServerProperties.SslListener wssListener = properties.getWssListener();
        if (mqttSslListener.isEnable()) {
            MqttServerProperties.Ssl ssl = wssListener.getSsl();
            serverCreator.enableMqttWss(sslBuilder -> sslBuilder.serverNode(wssListener.getServerNode()).useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass(), ssl.getClientAuth()).build());
        }
        if ((httpListener = properties.getHttpListener()).isEnable()) {
            Node serverNode = httpListener.getServerNode();
            MqttServerProperties.HttpBasicAuth basicAuth = httpListener.getBasicAuth();
            MqttServerProperties.McpServer mcpServer = httpListener.getMcpServer();
            MqttServerProperties.HttpSsl ssl = httpListener.getSsl();
            serverCreator.enableMqttHttpApi(builder -> {
                builder.serverNode(serverNode);
                if (basicAuth.isEnable()) {
                    builder.basicAuth(basicAuth.getUsername(), basicAuth.getPassword());
                }
                if (mcpServer.isEnable()) {
                    builder.mcpServer(mcpServer.getSseEndpoint(), mcpServer.getMessageEndpoint());
                }
                if (ssl.isEnable()) {
                    builder.useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass(), ssl.getClientAuth());
                }
                return builder.build();
            });
        }
        messageListenerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).messageListener(arg_0));
        IMqttServerAuthHandler authHandler = (IMqttServerAuthHandler)authHandlerObjectProvider.getIfAvailable(() -> {
            MqttServerProperties.MqttAuth mqttAuth = properties.getAuth();
            return mqttAuth.isEnable() ? new DefaultMqttServerAuthHandler(mqttAuth.getUsername(), mqttAuth.getPassword()) : null;
        });
        serverCreator.authHandler(authHandler);
        uniqueIdServiceObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).uniqueIdService(arg_0));
        subscribeValidatorObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).subscribeValidator(arg_0));
        publishPermissionObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).publishPermission(arg_0));
        messageDispatcherObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).messageDispatcher(arg_0));
        messageStoreObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).messageStore(arg_0));
        sessionManagerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).sessionManager(arg_0));
        sessionListenerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).sessionListener(arg_0));
        connectStatusListenerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).connectStatusListener(arg_0));
        messageInterceptorObjectProvider.orderedStream().forEach(arg_0 -> ((MqttServerCreator)serverCreator).addInterceptor(arg_0));
        customizers.ifAvailable(customizer -> customizer.customize(serverCreator));
        return serverCreator;
    }

    @Bean
    public MqttServer mqttServer(MqttServerCreator mqttServerCreator) {
        return mqttServerCreator.build();
    }

    @Bean
    public MqttServerLauncher mqttServerLauncher(MqttServer mqttServer) {
        return new MqttServerLauncher(mqttServer);
    }

    @Bean
    public MqttServerTemplate mqttServerTemplate(MqttServer mqttServer) {
        return new MqttServerTemplate(mqttServer);
    }

    @Bean
    @ConditionalOnMissingBean(value={MqttFunctionManager.class})
    public static MqttFunctionManager mqttFunctionManager() {
        return new MqttFunctionManager();
    }

    @Bean
    @ConditionalOnMissingBean(value={IMqttMessageListener.class})
    public IMqttMessageListener mqttFunctionMessageListener(MqttFunctionManager mqttFunctionManager) {
        return new MqttFunctionMessageListener(mqttFunctionManager);
    }

    @Bean
    public static MqttServerFunctionDetector mqttServerFunctionDetector(ApplicationContext applicationContext) {
        return new MqttServerFunctionDetector(applicationContext);
    }
}

