/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.properties;

import org.dromara.mica.mqtt.codec.properties.IntegerProperty;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;
import org.dromara.mica.mqtt.codec.properties.MqttPropertyType;
import org.dromara.mica.mqtt.codec.properties.StringProperty;
import org.dromara.mica.mqtt.codec.properties.UserProperty;

public class MqttDisconnectProperties {
    private final MqttProperties properties;

    public MqttDisconnectProperties() {
        this(new MqttProperties());
    }

    public MqttDisconnectProperties(MqttProperties properties) {
        this.properties = properties;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public MqttDisconnectProperties setSessionExpiryInterval(int interval) {
        this.properties.add(new IntegerProperty(MqttPropertyType.SESSION_EXPIRY_INTERVAL, (Integer)interval));
        return this;
    }

    public MqttDisconnectProperties setServerReference(String serverReference) {
        this.properties.add(new StringProperty(MqttPropertyType.SERVER_REFERENCE, serverReference));
        return this;
    }

    public MqttDisconnectProperties setReasonString(String reasonString) {
        this.properties.add(new StringProperty(MqttPropertyType.REASON_STRING, reasonString));
        return this;
    }

    public MqttDisconnectProperties addUserProperty(UserProperty userProperty) {
        this.properties.add(userProperty);
        return this;
    }

    public MqttDisconnectProperties addUserProperty(String key, String value) {
        this.addUserProperty(new UserProperty(key, value));
        return this;
    }
}

