/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.properties;

import org.dromara.mica.mqtt.codec.properties.BinaryProperty;
import org.dromara.mica.mqtt.codec.properties.BooleanProperty;
import org.dromara.mica.mqtt.codec.properties.IntegerProperty;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;
import org.dromara.mica.mqtt.codec.properties.MqttPropertyType;
import org.dromara.mica.mqtt.codec.properties.StringProperty;
import org.dromara.mica.mqtt.codec.properties.UserProperty;

public class MqttConnAckProperties {
    private final MqttProperties properties;

    public MqttConnAckProperties() {
        this(new MqttProperties());
    }

    public MqttConnAckProperties(MqttProperties properties) {
        this.properties = properties;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public MqttConnAckProperties setSessionExpiryInterval(int sessionExpiryInterval) {
        this.properties.add(new IntegerProperty(MqttPropertyType.SESSION_EXPIRY_INTERVAL, (Integer)sessionExpiryInterval));
        return this;
    }

    public MqttConnAckProperties setAssignedClientIdentifier(String assignedClientIdentifier) {
        this.properties.add(new StringProperty(MqttPropertyType.ASSIGNED_CLIENT_IDENTIFIER, assignedClientIdentifier));
        return this;
    }

    public MqttConnAckProperties setServerKeepAlive(int serverKeepAlive) {
        this.properties.add(new IntegerProperty(MqttPropertyType.SERVER_KEEP_ALIVE, (Integer)serverKeepAlive));
        return this;
    }

    public MqttConnAckProperties setAuthenticationMethod(String authenticationMethod) {
        this.properties.add(new StringProperty(MqttPropertyType.AUTHENTICATION_METHOD, authenticationMethod));
        return this;
    }

    public MqttConnAckProperties setAuthenticationData(byte[] authenticationData) {
        this.properties.add(new BinaryProperty(MqttPropertyType.AUTHENTICATION_DATA, authenticationData));
        return this;
    }

    public MqttConnAckProperties setResponseInformation(String responseInformation) {
        this.properties.add(new StringProperty(MqttPropertyType.RESPONSE_INFORMATION, responseInformation));
        return this;
    }

    public MqttConnAckProperties setServerReference(String serverReference) {
        this.properties.add(new StringProperty(MqttPropertyType.SERVER_REFERENCE, serverReference));
        return this;
    }

    public MqttConnAckProperties setReceiveMaximum(int receiveMaximum) {
        this.properties.add(new IntegerProperty(MqttPropertyType.RECEIVE_MAXIMUM, (Integer)receiveMaximum));
        return this;
    }

    public MqttConnAckProperties setTopicAliasMaximum(int topicAliasMaximum) {
        this.properties.add(new IntegerProperty(MqttPropertyType.TOPIC_ALIAS_MAXIMUM, (Integer)topicAliasMaximum));
        return this;
    }

    public MqttConnAckProperties setMaximumQos(int maximumQos) {
        this.properties.add(new IntegerProperty(MqttPropertyType.MAXIMUM_QOS, (Integer)maximumQos));
        return this;
    }

    public MqttConnAckProperties setRetainAvailable(boolean retainAvailable) {
        this.properties.add(new BooleanProperty(MqttPropertyType.RETAIN_AVAILABLE, retainAvailable));
        return this;
    }

    public MqttConnAckProperties setMaximumPacketSize(int maximumPacketSize) {
        this.properties.add(new IntegerProperty(MqttPropertyType.MAXIMUM_PACKET_SIZE, (Integer)maximumPacketSize));
        return this;
    }

    public MqttConnAckProperties setWildcardSubscriptionAvailable(boolean wildcardSubscriptionAvailable) {
        this.properties.add(new BooleanProperty(MqttPropertyType.WILDCARD_SUBSCRIPTION_AVAILABLE, wildcardSubscriptionAvailable));
        return this;
    }

    public MqttConnAckProperties setSubscriptionIdentifiersAvailable(boolean subscriptionIdentifiersAvailable) {
        this.properties.add(new BooleanProperty(MqttPropertyType.SUBSCRIPTION_IDENTIFIER_AVAILABLE, subscriptionIdentifiersAvailable));
        return this;
    }

    public MqttConnAckProperties setSharedSubscriptionAvailable(boolean sharedSubscriptionAvailable) {
        this.properties.add(new BooleanProperty(MqttPropertyType.SHARED_SUBSCRIPTION_AVAILABLE, sharedSubscriptionAvailable));
        return this;
    }

    public MqttConnAckProperties setReasonString(String reasonString) {
        this.properties.add(new StringProperty(MqttPropertyType.REASON_STRING, reasonString));
        return this;
    }

    public MqttConnAckProperties addUserProperty(UserProperty userProperty) {
        this.properties.add(userProperty);
        return this;
    }

    public MqttConnAckProperties addUserProperty(String key, String value) {
        this.addUserProperty(new UserProperty(key, value));
        return this;
    }
}

