/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.properties;

import org.dromara.mica.mqtt.codec.properties.BinaryProperty;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;
import org.dromara.mica.mqtt.codec.properties.MqttPropertyType;
import org.dromara.mica.mqtt.codec.properties.StringProperty;
import org.dromara.mica.mqtt.codec.properties.UserProperty;

public class MqttAuthProperties {
    private final MqttProperties properties;

    public MqttAuthProperties() {
        this(new MqttProperties());
    }

    public MqttAuthProperties(MqttProperties properties) {
        this.properties = properties;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public MqttAuthProperties setAuthenticationMethod(String authenticationMethod) {
        this.properties.add(new StringProperty(MqttPropertyType.AUTHENTICATION_METHOD, authenticationMethod));
        return this;
    }

    public MqttAuthProperties setAuthenticationData(byte[] authenticationData) {
        this.properties.add(new BinaryProperty(MqttPropertyType.AUTHENTICATION_DATA, authenticationData));
        return this;
    }

    public MqttAuthProperties setReasonString(String reasonString) {
        this.properties.add(new StringProperty(MqttPropertyType.REASON_STRING, reasonString));
        return this;
    }

    public MqttAuthProperties addUserProperty(UserProperty userProperty) {
        this.properties.add(userProperty);
        return this;
    }

    public MqttAuthProperties addUserProperty(String key, String value) {
        this.addUserProperty(new UserProperty(key, value));
        return this;
    }
}

