/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.builder;

import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.message.builder.MqttSubscriptionOption;

public final class MqttTopicSubscription {
    private final MqttSubscriptionOption option;
    private String topicFilter;

    public MqttTopicSubscription(String topicFilter) {
        this(topicFilter, MqttQoS.QOS0);
    }

    public MqttTopicSubscription(String topicFilter, MqttQoS qualityOfService) {
        this(topicFilter, MqttSubscriptionOption.onlyFromQos(qualityOfService));
    }

    public MqttTopicSubscription(String topicFilter, MqttSubscriptionOption option) {
        this.topicFilter = topicFilter;
        this.option = option;
    }

    public String topicFilter() {
        return this.topicFilter;
    }

    public void setTopicFilter(String topicFilter) {
        this.topicFilter = topicFilter;
    }

    public MqttQoS qualityOfService() {
        return this.option.qos();
    }

    public MqttSubscriptionOption option() {
        return this.option;
    }

    public String toString() {
        return "MqttTopicSubscription[topicFilter=" + this.topicFilter + ", option=" + this.option + ']';
    }
}

