/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.builder;

import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.message.MqttPublishMessage;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttPublishVariableHeader;
import org.dromara.mica.mqtt.codec.message.properties.MqttPublishProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttPublishBuilder {
    private String topic;
    private boolean isDup = false;
    private boolean retained;
    private MqttQoS qos;
    private byte[] payload;
    private int messageId;
    private MqttProperties properties = MqttProperties.NO_PROPERTIES;

    public MqttPublishBuilder topicName(String topic) {
        this.topic = topic;
        return this;
    }

    public MqttPublishBuilder isDup(boolean isDup) {
        this.isDup = isDup;
        return this;
    }

    public MqttPublishBuilder retained(boolean retained) {
        this.retained = retained;
        return this;
    }

    public MqttPublishBuilder qos(MqttQoS qos) {
        this.qos = qos;
        return this;
    }

    public MqttPublishBuilder payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public MqttPublishBuilder messageId(int messageId) {
        this.messageId = messageId;
        return this;
    }

    public MqttPublishBuilder properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttPublishBuilder properties(Consumer<MqttPublishProperties> consumer) {
        MqttPublishProperties publishProperties = new MqttPublishProperties();
        consumer.accept(publishProperties);
        return this.properties(publishProperties.getProperties());
    }

    public String getTopicName() {
        return this.topic;
    }

    public boolean isRetained() {
        return this.retained;
    }

    public MqttQoS getQos() {
        return this.qos;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public MqttPublishMessage build() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, this.isDup, this.qos, this.retained, 0);
        MqttPublishVariableHeader mqttVariableHeader = new MqttPublishVariableHeader(this.topic, this.messageId, this.properties);
        return new MqttPublishMessage(mqttFixedHeader, mqttVariableHeader, this.payload);
    }
}

