/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.codes;

import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.MqttVersion;
import org.dromara.mica.mqtt.codec.codes.MqttReasonCode;

public enum MqttSubAckReasonCode implements MqttReasonCode
{
    GRANTED_QOS0(0),
    GRANTED_QOS1(1),
    GRANTED_QOS2(2),
    UNSPECIFIED_ERROR(-128),
    IMPLEMENTATION_SPECIFIC_ERROR(-125),
    NOT_AUTHORIZED(-121),
    TOPIC_FILTER_INVALID(-113),
    PACKET_IDENTIFIER_IN_USE(-111),
    QUOTA_EXCEEDED(-105),
    SHARED_SUBSCRIPTIONS_NOT_SUPPORTED(-98),
    SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED(-95),
    WILDCARD_SUBSCRIPTIONS_NOT_SUPPORTED(-94);

    private final byte byteValue;

    private MqttSubAckReasonCode(byte byteValue) {
        this.byteValue = byteValue;
    }

    public static MqttSubAckReasonCode qosGranted(MqttQoS qos) {
        switch (qos) {
            case QOS0: {
                return GRANTED_QOS0;
            }
            case QOS1: {
                return GRANTED_QOS1;
            }
            case QOS2: {
                return GRANTED_QOS2;
            }
            case FAILURE: {
                return UNSPECIFIED_ERROR;
            }
        }
        return UNSPECIFIED_ERROR;
    }

    @Override
    public byte value() {
        return this.byteValue;
    }

    public MqttSubAckReasonCode limitForMqttVersion(MqttVersion version) {
        if (version != MqttVersion.MQTT_5 && this.byteValue > MqttSubAckReasonCode.UNSPECIFIED_ERROR.byteValue) {
            return UNSPECIFIED_ERROR;
        }
        return this;
    }
}

