/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.dromara.mica.mqtt.codec.exception.MqttUnacceptableProtocolVersionException;

public enum MqttVersion {
    MQTT_3_1("MQIsdp", 3, "MQTT 3.1"),
    MQTT_3_1_1("MQTT", 4, "MQTT 3.1.1"),
    MQTT_5("MQTT", 5, "MQTT 5.0");

    private final String name;
    private final byte level;
    private final String fullName;

    private MqttVersion(String protocolName, byte protocolLevel, String fullName) {
        this.name = Objects.requireNonNull(protocolName, "protocolName is null.");
        this.level = protocolLevel;
        this.fullName = fullName;
    }

    public static MqttVersion fromProtocolNameAndLevel(String protocolName, byte protocolLevel) {
        MqttVersion mv;
        switch (protocolLevel) {
            case 3: {
                mv = MQTT_3_1;
                break;
            }
            case 4: {
                mv = MQTT_3_1_1;
                break;
            }
            case 5: {
                mv = MQTT_5;
                break;
            }
            default: {
                throw new MqttUnacceptableProtocolVersionException(protocolName + " is an unknown protocol name");
            }
        }
        if (mv.name.equals(protocolName)) {
            return mv;
        }
        throw new MqttUnacceptableProtocolVersionException(protocolName + " and " + protocolLevel + " don't match");
    }

    public String protocolName() {
        return this.name;
    }

    public byte[] protocolNameBytes() {
        return this.name.getBytes(StandardCharsets.UTF_8);
    }

    public byte protocolLevel() {
        return this.level;
    }

    public String fullName() {
        return this.fullName;
    }
}

