/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.dromara.mica.mqtt.codec.MqttCodecUtil;
import org.dromara.mica.mqtt.codec.MqttVersion;
import org.dromara.mica.mqtt.codec.exception.EncoderException;
import org.dromara.mica.mqtt.codec.exception.MqttIdentifierRejectedException;
import org.dromara.mica.mqtt.codec.message.MqttConnAckMessage;
import org.dromara.mica.mqtt.codec.message.MqttConnectMessage;
import org.dromara.mica.mqtt.codec.message.MqttMessage;
import org.dromara.mica.mqtt.codec.message.MqttPublishMessage;
import org.dromara.mica.mqtt.codec.message.MqttSubAckMessage;
import org.dromara.mica.mqtt.codec.message.MqttSubscribeMessage;
import org.dromara.mica.mqtt.codec.message.MqttUnSubAckMessage;
import org.dromara.mica.mqtt.codec.message.MqttUnSubscribeMessage;
import org.dromara.mica.mqtt.codec.message.builder.MqttSubscriptionOption;
import org.dromara.mica.mqtt.codec.message.builder.MqttTopicSubscription;
import org.dromara.mica.mqtt.codec.message.header.MqttConnectVariableHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttMessageIdAndPropertiesVariableHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttMessageIdVariableHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttPubReplyMessageVariableHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttPublishVariableHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttReasonCodeAndPropertiesVariableHeader;
import org.dromara.mica.mqtt.codec.message.payload.MqttConnectPayload;
import org.dromara.mica.mqtt.codec.message.payload.MqttSubscribePayload;
import org.dromara.mica.mqtt.codec.message.payload.MqttUnsubAckPayload;
import org.dromara.mica.mqtt.codec.message.payload.MqttUnsubscribePayload;
import org.dromara.mica.mqtt.codec.properties.BinaryProperty;
import org.dromara.mica.mqtt.codec.properties.IntegerProperty;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperty;
import org.dromara.mica.mqtt.codec.properties.MqttPropertyType;
import org.dromara.mica.mqtt.codec.properties.StringPair;
import org.dromara.mica.mqtt.codec.properties.StringProperty;
import org.dromara.mica.mqtt.codec.properties.UserProperties;
import org.tio.core.ChannelContext;
import org.tio.utils.buffer.ByteBufferUtil;
import org.tio.utils.hutool.FastByteBuffer;

public final class MqttEncoder {
    public static final MqttEncoder INSTANCE = new MqttEncoder();

    private MqttEncoder() {
    }

    private static ByteBuffer encodeConnectMessage(ChannelContext ctx, MqttConnectMessage message) {
        byte[] willPropertiesBytes;
        byte[] password;
        byte[] passwordBytes;
        String userName;
        byte[] userNameBytes;
        byte[] willMessageBytes;
        int payloadBufferSize = 0;
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttConnectVariableHeader variableHeader = message.variableHeader();
        MqttConnectPayload payload = message.payload();
        MqttVersion mqttVersion = MqttVersion.fromProtocolNameAndLevel(variableHeader.name(), (byte)variableHeader.version());
        MqttCodecUtil.setMqttVersion(ctx, mqttVersion);
        if (!variableHeader.hasUsername() && variableHeader.hasPassword()) {
            throw new EncoderException("Without a username, the password MUST be not set");
        }
        String clientIdentifier = payload.clientIdentifier();
        if (!MqttCodecUtil.isValidClientId(mqttVersion, 64, clientIdentifier)) {
            throw new MqttIdentifierRejectedException("invalid clientIdentifier: " + clientIdentifier);
        }
        byte[] clientIdentifierBytes = MqttEncoder.encodeStringUtf8(clientIdentifier);
        payloadBufferSize += 2 + clientIdentifierBytes.length;
        String willTopic = payload.willTopic();
        byte[] willTopicBytes = willTopic != null ? MqttEncoder.encodeStringUtf8(willTopic) : ByteBufferUtil.EMPTY_BYTES;
        byte[] willMessage = payload.willMessageInBytes();
        byte[] byArray = willMessageBytes = willMessage != null ? willMessage : ByteBufferUtil.EMPTY_BYTES;
        if (variableHeader.isWillFlag()) {
            payloadBufferSize += 2 + willTopicBytes.length;
            payloadBufferSize += 2 + willMessageBytes.length;
        }
        byte[] byArray2 = userNameBytes = (userName = payload.username()) != null ? MqttEncoder.encodeStringUtf8(userName) : ByteBufferUtil.EMPTY_BYTES;
        if (variableHeader.hasUsername()) {
            payloadBufferSize += 2 + userNameBytes.length;
        }
        byte[] byArray3 = passwordBytes = (password = payload.passwordInBytes()) != null ? password : ByteBufferUtil.EMPTY_BYTES;
        if (variableHeader.hasPassword()) {
            payloadBufferSize += 2 + passwordBytes.length;
        }
        byte[] protocolNameBytes = mqttVersion.protocolNameBytes();
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.variableHeader().properties());
        if (variableHeader.isWillFlag()) {
            willPropertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, payload.willProperties());
            payloadBufferSize += willPropertiesBytes.length;
        } else {
            willPropertiesBytes = ByteBufferUtil.EMPTY_BYTES;
        }
        int variableHeaderBufferSize = 2 + protocolNameBytes.length + 4 + propertiesBytes.length;
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        ByteBuffer buf = ByteBuffer.allocate(fixedHeaderBufferSize + variablePartSize);
        buf.put(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
        buf.putShort((short)protocolNameBytes.length);
        buf.put(protocolNameBytes);
        buf.put((byte)variableHeader.version());
        buf.put((byte)MqttEncoder.getConnVariableHeaderFlag(variableHeader));
        buf.putShort((short)variableHeader.keepAliveTimeSeconds());
        buf.put(propertiesBytes);
        buf.putShort((short)clientIdentifierBytes.length);
        buf.put(clientIdentifierBytes, 0, clientIdentifierBytes.length);
        if (variableHeader.isWillFlag()) {
            buf.put(willPropertiesBytes, 0, willPropertiesBytes.length);
            buf.putShort((short)willTopicBytes.length);
            buf.put(willTopicBytes, 0, willTopicBytes.length);
            buf.putShort((short)willMessageBytes.length);
            buf.put(willMessageBytes, 0, willMessageBytes.length);
        }
        if (variableHeader.hasUsername()) {
            buf.putShort((short)userNameBytes.length);
            buf.put(userNameBytes, 0, userNameBytes.length);
        }
        if (variableHeader.hasPassword()) {
            buf.putShort((short)passwordBytes.length);
            buf.put(passwordBytes, 0, passwordBytes.length);
        }
        return buf;
    }

    private static int getConnVariableHeaderFlag(MqttConnectVariableHeader variableHeader) {
        int flagByte = 0;
        if (variableHeader.hasUsername()) {
            flagByte |= 0x80;
        }
        if (variableHeader.hasPassword()) {
            flagByte |= 0x40;
        }
        if (variableHeader.isWillRetain()) {
            flagByte |= 0x20;
        }
        flagByte |= (variableHeader.willQos() & 3) << 3;
        if (variableHeader.isWillFlag()) {
            flagByte |= 4;
        }
        if (variableHeader.isCleanStart()) {
            flagByte |= 2;
        }
        return flagByte;
    }

    private static ByteBuffer encodeConnAckMessage(ChannelContext ctx, MqttConnAckMessage message) {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.variableHeader().properties());
        ByteBuffer buf = ByteBuffer.allocate(4 + propertiesBytes.length);
        buf.put(MqttEncoder.getFixedHeaderByte1(message.fixedHeader()));
        MqttEncoder.writeVariableLengthInt(buf, 2 + propertiesBytes.length);
        buf.put((byte)(message.variableHeader().isSessionPresent() ? 1 : 0));
        buf.put(message.variableHeader().connectReturnCode().value());
        buf.put(propertiesBytes);
        return buf;
    }

    private static ByteBuffer encodeSubscribeMessage(ChannelContext ctx, MqttSubscribeMessage message) {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.idAndPropertiesVariableHeader().properties());
        int variableHeaderBufferSize = 2 + propertiesBytes.length;
        int payloadBufferSize = 0;
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttMessageIdVariableHeader variableHeader = message.variableHeader();
        MqttSubscribePayload payload = message.payload();
        for (MqttTopicSubscription topic : payload.topicSubscriptions()) {
            String topicFilter = topic.topicFilter();
            byte[] topicFilterBytes = MqttEncoder.encodeStringUtf8(topicFilter);
            payloadBufferSize += 2 + topicFilterBytes.length;
            ++payloadBufferSize;
        }
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        ByteBuffer buf = ByteBuffer.allocate(fixedHeaderBufferSize + variablePartSize);
        buf.put(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
        int messageId = variableHeader.messageId();
        buf.putShort((short)messageId);
        buf.put(propertiesBytes);
        for (MqttTopicSubscription topic : payload.topicSubscriptions()) {
            String topicName = topic.topicFilter();
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            buf.putShort((short)topicNameBytes.length);
            buf.put(topicNameBytes, 0, topicNameBytes.length);
            if (mqttVersion == MqttVersion.MQTT_3_1_1 || mqttVersion == MqttVersion.MQTT_3_1) {
                buf.put((byte)topic.qualityOfService().value());
                continue;
            }
            MqttSubscriptionOption option = topic.option();
            int optionEncoded = option.retainHandling().value() << 4;
            if (option.isRetainAsPublished()) {
                optionEncoded |= 8;
            }
            if (option.isNoLocal()) {
                optionEncoded |= 4;
            }
            buf.put((byte)(optionEncoded |= option.qos().value()));
        }
        return buf;
    }

    private static ByteBuffer encodeUnsubscribeMessage(ChannelContext ctx, MqttUnSubscribeMessage message) {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.idAndPropertiesVariableHeader().properties());
        int variableHeaderBufferSize = 2 + propertiesBytes.length;
        int payloadBufferSize = 0;
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttMessageIdVariableHeader variableHeader = message.variableHeader();
        MqttUnsubscribePayload payload = message.payload();
        for (String topicName : payload.topics()) {
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            payloadBufferSize += 2 + topicNameBytes.length;
        }
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        ByteBuffer buf = ByteBuffer.allocate(fixedHeaderBufferSize + variablePartSize);
        buf.put(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
        int messageId = variableHeader.messageId();
        buf.putShort((short)messageId);
        buf.put(propertiesBytes);
        for (String topicName : payload.topics()) {
            byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
            buf.putShort((short)topicNameBytes.length);
            buf.put(topicNameBytes, 0, topicNameBytes.length);
        }
        return buf;
    }

    private static ByteBuffer encodeSubAckMessage(ChannelContext ctx, MqttSubAckMessage message) {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.idAndPropertiesVariableHeader().properties());
        int variableHeaderBufferSize = 2 + propertiesBytes.length;
        int payloadBufferSize = message.payload().grantedQoSLevels().size();
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        ByteBuffer buf = ByteBuffer.allocate(fixedHeaderBufferSize + variablePartSize);
        buf.put(MqttEncoder.getFixedHeaderByte1(message.fixedHeader()));
        MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
        buf.putShort((short)message.variableHeader().messageId());
        buf.put(propertiesBytes);
        for (Short code : message.payload().reasonCodes()) {
            buf.put(code.byteValue());
        }
        return buf;
    }

    private static ByteBuffer encodeUnsubAckMessage(ChannelContext ctx, MqttUnSubAckMessage message) {
        if (message.variableHeader() instanceof MqttMessageIdAndPropertiesVariableHeader) {
            MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
            byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.idAndPropertiesVariableHeader().properties());
            int variableHeaderBufferSize = 2 + propertiesBytes.length;
            MqttUnsubAckPayload payload = message.payload();
            int payloadBufferSize = payload == null ? 0 : payload.unsubscribeReasonCodes().size();
            int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
            int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
            ByteBuffer buf = ByteBuffer.allocate(fixedHeaderBufferSize + variablePartSize);
            buf.put(MqttEncoder.getFixedHeaderByte1(message.fixedHeader()));
            MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
            buf.putShort((short)message.variableHeader().messageId());
            buf.put(propertiesBytes);
            if (payload != null) {
                for (Short reasonCode : payload.unsubscribeReasonCodes()) {
                    buf.putShort(reasonCode);
                }
            }
            return buf;
        }
        return MqttEncoder.encodeMessageWithOnlySingleByteFixedHeaderAndMessageId(message);
    }

    private static ByteBuffer encodePublishMessage(ChannelContext ctx, MqttPublishMessage message) {
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttPublishVariableHeader variableHeader = message.variableHeader();
        byte[] payload = message.payload() == null ? ByteBufferUtil.EMPTY_BYTES : message.payload();
        String topicName = variableHeader.topicName();
        byte[] topicNameBytes = MqttEncoder.encodeStringUtf8(topicName);
        byte[] propertiesBytes = MqttEncoder.encodePropertiesIfNeeded(mqttVersion, message.variableHeader().properties());
        int variableHeaderBufferSize = 2 + topicNameBytes.length + (mqttFixedHeader.qosLevel().value() > 0 ? 2 : 0) + propertiesBytes.length;
        int payloadBufferSize = payload.length;
        int variablePartSize = variableHeaderBufferSize + payloadBufferSize;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variablePartSize);
        ByteBuffer buf = ByteBuffer.allocate(fixedHeaderBufferSize + variablePartSize);
        buf.put(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        MqttEncoder.writeVariableLengthInt(buf, variablePartSize);
        buf.putShort((short)topicNameBytes.length);
        buf.put(topicNameBytes);
        if (mqttFixedHeader.qosLevel().value() > 0) {
            buf.putShort((short)variableHeader.packetId());
        }
        buf.put(propertiesBytes);
        buf.put(payload);
        return buf;
    }

    private static ByteBuffer encodePubReplyMessage(ChannelContext ctx, MqttMessage message) {
        if (message.variableHeader() instanceof MqttPubReplyMessageVariableHeader) {
            int variableHeaderBufferSize;
            boolean includeReasonCode;
            byte[] propertiesBytes;
            MqttFixedHeader mqttFixedHeader = message.fixedHeader();
            MqttPubReplyMessageVariableHeader variableHeader = (MqttPubReplyMessageVariableHeader)message.variableHeader();
            MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
            if (!(mqttVersion != MqttVersion.MQTT_5 || variableHeader.reasonCode() == 0 && variableHeader.properties().isEmpty())) {
                propertiesBytes = MqttEncoder.encodeProperties(variableHeader.properties());
                includeReasonCode = true;
                variableHeaderBufferSize = 3 + propertiesBytes.length;
            } else {
                propertiesBytes = ByteBufferUtil.EMPTY_BYTES;
                includeReasonCode = false;
                variableHeaderBufferSize = 2;
            }
            int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variableHeaderBufferSize);
            ByteBuffer buf = ByteBuffer.allocate(fixedHeaderBufferSize + variableHeaderBufferSize);
            buf.put(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
            MqttEncoder.writeVariableLengthInt(buf, variableHeaderBufferSize);
            buf.putShort((short)variableHeader.messageId());
            if (includeReasonCode) {
                buf.put(variableHeader.reasonCode());
            }
            buf.put(propertiesBytes);
            return buf;
        }
        return MqttEncoder.encodeMessageWithOnlySingleByteFixedHeaderAndMessageId(message);
    }

    private static ByteBuffer encodeMessageWithOnlySingleByteFixedHeaderAndMessageId(MqttMessage message) {
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)message.variableHeader();
        int variableHeaderBufferSize = 2;
        int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variableHeaderBufferSize);
        ByteBuffer buf = ByteBuffer.allocate(fixedHeaderBufferSize + variableHeaderBufferSize);
        buf.put(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        MqttEncoder.writeVariableLengthInt(buf, variableHeaderBufferSize);
        buf.putShort((short)variableHeader.messageId());
        return buf;
    }

    private static ByteBuffer encodeReasonCodePlusPropertiesMessage(ChannelContext ctx, MqttMessage message) {
        if (message.variableHeader() instanceof MqttReasonCodeAndPropertiesVariableHeader) {
            int variableHeaderBufferSize;
            boolean includeReasonCode;
            byte[] propertiesBytes;
            MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
            MqttFixedHeader mqttFixedHeader = message.fixedHeader();
            MqttReasonCodeAndPropertiesVariableHeader variableHeader = (MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader();
            if (!(mqttVersion != MqttVersion.MQTT_5 || variableHeader.reasonCode() == 0 && variableHeader.properties().isEmpty())) {
                propertiesBytes = MqttEncoder.encodeProperties(variableHeader.properties());
                includeReasonCode = true;
                variableHeaderBufferSize = 1 + propertiesBytes.length;
            } else {
                propertiesBytes = ByteBufferUtil.EMPTY_BYTES;
                includeReasonCode = false;
                variableHeaderBufferSize = 0;
            }
            int fixedHeaderBufferSize = 1 + MqttEncoder.getVariableLengthInt(variableHeaderBufferSize);
            ByteBuffer buf = ByteBuffer.allocate(fixedHeaderBufferSize + variableHeaderBufferSize);
            buf.put(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
            MqttEncoder.writeVariableLengthInt(buf, variableHeaderBufferSize);
            if (includeReasonCode) {
                buf.put(variableHeader.reasonCode());
            }
            buf.put(propertiesBytes);
            return buf;
        }
        return MqttEncoder.encodeMessageWithOnlySingleByteFixedHeader(message);
    }

    private static ByteBuffer encodeMessageWithOnlySingleByteFixedHeader(MqttMessage message) {
        MqttFixedHeader mqttFixedHeader = message.fixedHeader();
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.put(MqttEncoder.getFixedHeaderByte1(mqttFixedHeader));
        buf.put((byte)0);
        return buf;
    }

    private static byte[] encodePropertiesIfNeeded(MqttVersion mqttVersion, MqttProperties mqttProperties) {
        if (mqttVersion == MqttVersion.MQTT_5) {
            return MqttEncoder.encodeProperties(mqttProperties);
        }
        return ByteBufferUtil.EMPTY_BYTES;
    }

    private static byte[] encodeProperties(MqttProperties mqttProperties) {
        FastByteBuffer writeBuffer = new FastByteBuffer(256);
        block9: for (MqttProperty mqttProperty : mqttProperties.listAll()) {
            int propertyId = mqttProperty.propertyId();
            MqttPropertyType propertyType = MqttPropertyType.valueOf(propertyId);
            switch (propertyType) {
                case PAYLOAD_FORMAT_INDICATOR: 
                case REQUEST_PROBLEM_INFORMATION: 
                case REQUEST_RESPONSE_INFORMATION: 
                case MAXIMUM_QOS: 
                case RETAIN_AVAILABLE: 
                case WILDCARD_SUBSCRIPTION_AVAILABLE: 
                case SUBSCRIPTION_IDENTIFIER_AVAILABLE: 
                case SHARED_SUBSCRIPTION_AVAILABLE: {
                    writeBuffer.writeVarLengthInt(propertyId);
                    byte bytePropValue = ((Integer)((IntegerProperty)mqttProperty).value()).byteValue();
                    writeBuffer.writeByte((int)bytePropValue);
                    break;
                }
                case SERVER_KEEP_ALIVE: 
                case RECEIVE_MAXIMUM: 
                case TOPIC_ALIAS_MAXIMUM: 
                case TOPIC_ALIAS: {
                    writeBuffer.writeVarLengthInt(propertyId);
                    short twoBytesInPropValue = ((Integer)((IntegerProperty)mqttProperty).value()).shortValue();
                    writeBuffer.writeShortBE((int)twoBytesInPropValue);
                    break;
                }
                case MESSAGE_EXPIRY_INTERVAL: 
                case SESSION_EXPIRY_INTERVAL: 
                case WILL_DELAY_INTERVAL: 
                case MAXIMUM_PACKET_SIZE: {
                    writeBuffer.writeVarLengthInt(propertyId);
                    int fourBytesIntPropValue = (Integer)((IntegerProperty)mqttProperty).value();
                    writeBuffer.writeIntBE((long)fourBytesIntPropValue);
                    break;
                }
                case SUBSCRIPTION_IDENTIFIER: {
                    writeBuffer.writeVarLengthInt(propertyId);
                    int vbi = (Integer)((IntegerProperty)mqttProperty).value();
                    writeBuffer.writeVarLengthInt(vbi);
                    break;
                }
                case CONTENT_TYPE: 
                case RESPONSE_TOPIC: 
                case ASSIGNED_CLIENT_IDENTIFIER: 
                case AUTHENTICATION_METHOD: 
                case RESPONSE_INFORMATION: 
                case SERVER_REFERENCE: 
                case REASON_STRING: {
                    writeBuffer.writeVarLengthInt(propertyId);
                    MqttEncoder.writeEagerUTF8String(writeBuffer, (String)((StringProperty)mqttProperty).value());
                    break;
                }
                case USER_PROPERTY: {
                    List pairs = (List)((UserProperties)mqttProperty).value();
                    for (StringPair pair : pairs) {
                        writeBuffer.writeVarLengthInt(propertyId);
                        MqttEncoder.writeEagerUTF8String(writeBuffer, pair.key);
                        MqttEncoder.writeEagerUTF8String(writeBuffer, pair.value);
                    }
                    continue block9;
                }
                case CORRELATION_DATA: 
                case AUTHENTICATION_DATA: {
                    writeBuffer.writeVarLengthInt(propertyId);
                    byte[] binaryPropValue = (byte[])((BinaryProperty)mqttProperty).value();
                    writeBuffer.writeShortBE((int)((short)binaryPropValue.length));
                    writeBuffer.writeBytes(binaryPropValue, 0, binaryPropValue.length);
                    break;
                }
                default: {
                    throw new EncoderException("Unknown property type: " + (Object)((Object)propertyType));
                }
            }
        }
        byte[] propertiesBytes = writeBuffer.toArray();
        writeBuffer.reset();
        writeBuffer.writeVarLengthInt(propertiesBytes.length);
        writeBuffer.writeBytes(propertiesBytes);
        return writeBuffer.toArray();
    }

    private static byte getFixedHeaderByte1(MqttFixedHeader header) {
        int ret = 0;
        ret |= header.messageType().value() << 4;
        if (header.isDup()) {
            ret |= 8;
        }
        ret |= header.qosLevel().value() << 1;
        if (header.isRetain()) {
            ret |= 1;
        }
        return (byte)ret;
    }

    private static void writeVariableLengthInt(ByteBuffer buf, int num) {
        do {
            int digit = num & 0x7F;
            if ((num >>>= 7) > 0) {
                digit |= 0x80;
            }
            buf.put((byte)digit);
        } while (num > 0);
    }

    private static int getVariableLengthInt(int num) {
        int count = 0;
        do {
            ++count;
        } while ((num >>>= 7) > 0);
        return count;
    }

    private static void writeEagerUTF8String(FastByteBuffer buf, String s) {
        if (s == null) {
            buf.writeShortBE(0);
        } else {
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            buf.writeShortBE((int)((short)bytes.length));
            buf.writeBytes(bytes);
        }
    }

    private static byte[] encodeStringUtf8(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public ByteBuffer doEncode(ChannelContext ctx, MqttMessage message) {
        switch (message.fixedHeader().messageType()) {
            case CONNECT: {
                return MqttEncoder.encodeConnectMessage(ctx, (MqttConnectMessage)message);
            }
            case CONNACK: {
                return MqttEncoder.encodeConnAckMessage(ctx, (MqttConnAckMessage)message);
            }
            case PUBLISH: {
                return MqttEncoder.encodePublishMessage(ctx, (MqttPublishMessage)message);
            }
            case SUBSCRIBE: {
                return MqttEncoder.encodeSubscribeMessage(ctx, (MqttSubscribeMessage)message);
            }
            case UNSUBSCRIBE: {
                return MqttEncoder.encodeUnsubscribeMessage(ctx, (MqttUnSubscribeMessage)message);
            }
            case SUBACK: {
                return MqttEncoder.encodeSubAckMessage(ctx, (MqttSubAckMessage)message);
            }
            case UNSUBACK: {
                if (message instanceof MqttUnSubAckMessage) {
                    return MqttEncoder.encodeUnsubAckMessage(ctx, (MqttUnSubAckMessage)message);
                }
                return MqttEncoder.encodeMessageWithOnlySingleByteFixedHeaderAndMessageId(message);
            }
            case PUBACK: 
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                return MqttEncoder.encodePubReplyMessage(ctx, message);
            }
            case DISCONNECT: 
            case AUTH: {
                return MqttEncoder.encodeReasonCodePlusPropertiesMessage(ctx, message);
            }
            case PINGREQ: 
            case PINGRESP: {
                return MqttEncoder.encodeMessageWithOnlySingleByteFixedHeader(message);
            }
        }
        throw new IllegalArgumentException("Unknown message type: " + message.fixedHeader().messageType().value());
    }
}

