/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.log;

import org.dromara.hutool.core.lang.caller.CallerUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.log.Log;
import org.dromara.hutool.log.LogFactory;
import org.dromara.hutool.log.level.Level;

public class LogUtil {
    private static final String FQCN = LogUtil.class.getName();

    public static void trace(String format, Object ... arguments) {
        LogUtil.trace(LogFactory.getLog(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void trace(Log log, String format, Object ... arguments) {
        log.trace(FQCN, null, format, arguments);
    }

    public static void debug(String format, Object ... arguments) {
        LogUtil.debug(LogFactory.getLog(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void debug(Log log, String format, Object ... arguments) {
        log.debug(FQCN, null, format, arguments);
    }

    public static void info(String format, Object ... arguments) {
        LogUtil.info(LogFactory.getLog(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void info(Log log, String format, Object ... arguments) {
        log.info(FQCN, null, format, arguments);
    }

    public static void warn(String format, Object ... arguments) {
        LogUtil.warn(LogFactory.getLog(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void warn(Throwable e, String format, Object ... arguments) {
        LogUtil.warn(LogFactory.getLog(CallerUtil.getCallerCaller()), e, StrUtil.format((CharSequence)format, (Object[])arguments), new Object[0]);
    }

    public static void warn(Log log, String format, Object ... arguments) {
        LogUtil.warn(log, null, format, arguments);
    }

    public static void warn(Log log, Throwable e, String format, Object ... arguments) {
        log.warn(FQCN, e, format, arguments);
    }

    public static void error(Throwable e) {
        LogUtil.error(LogFactory.getLog(CallerUtil.getCallerCaller()), e);
    }

    public static void error(String format, Object ... arguments) {
        LogUtil.error(LogFactory.getLog(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void error(Throwable e, String format, Object ... arguments) {
        LogUtil.error(LogFactory.getLog(CallerUtil.getCallerCaller()), e, format, arguments);
    }

    public static void error(Log log, Throwable e) {
        LogUtil.error(log, e, e.getMessage(), new Object[0]);
    }

    public static void error(Log log, String format, Object ... arguments) {
        LogUtil.error(log, null, format, arguments);
    }

    public static void error(Log log, Throwable e, String format, Object ... arguments) {
        log.error(FQCN, e, format, arguments);
    }

    public static void log(Level level, Throwable t, String format, Object ... arguments) {
        LogFactory.getLog(CallerUtil.getCallerCaller()).log(FQCN, level, t, format, arguments);
    }
}

