/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.xhtmlrenderer.docx;

import java.awt.Rectangle;
import org.docx4j.org.xhtmlrenderer.context.StyleReference;
import org.docx4j.org.xhtmlrenderer.docx.Docx4jDocxOutputDevice;
import org.docx4j.org.xhtmlrenderer.docx.Docx4jReplacedElementFactory;
import org.docx4j.org.xhtmlrenderer.docx.Docx4jTextRenderer;
import org.docx4j.org.xhtmlrenderer.docx.Docx4jUserAgent;
import org.docx4j.org.xhtmlrenderer.extend.NamespaceHandler;
import org.docx4j.org.xhtmlrenderer.extend.UserInterface;
import org.docx4j.org.xhtmlrenderer.layout.BoxBuilder;
import org.docx4j.org.xhtmlrenderer.layout.Layer;
import org.docx4j.org.xhtmlrenderer.layout.LayoutContext;
import org.docx4j.org.xhtmlrenderer.layout.SharedContext;
import org.docx4j.org.xhtmlrenderer.pdf.ITextFontContext;
import org.docx4j.org.xhtmlrenderer.pdf.ITextFontResolver;
import org.docx4j.org.xhtmlrenderer.render.BlockBox;
import org.docx4j.org.xhtmlrenderer.render.PageBox;
import org.docx4j.org.xhtmlrenderer.render.ViewportBox;
import org.docx4j.org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.docx4j.org.xhtmlrenderer.util.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocxRenderer {
    private static final float DEFAULT_DOTS_PER_POINT = 20.0f;
    private static final int DEFAULT_DOTS_PER_PIXEL = 20;
    private final SharedContext _sharedContext;
    private final Docx4jDocxOutputDevice _outputDevice;
    private Docx4jUserAgent userAgent;
    private Document _doc;
    private BlockBox _root;
    private final float _dotsPerPoint;

    public Docx4jUserAgent getDocx4jUserAgent() {
        return this.userAgent;
    }

    public BlockBox getRootBox() {
        return this._root;
    }

    public DocxRenderer() {
        this(20.0f, 20);
    }

    public DocxRenderer(float dotsPerPoint, int dotsPerPixel) {
        this._dotsPerPoint = dotsPerPoint;
        this._outputDevice = new Docx4jDocxOutputDevice();
        this.userAgent = new Docx4jUserAgent();
        this._sharedContext = new SharedContext();
        this._sharedContext.setUserAgentCallback(this.userAgent);
        this._sharedContext.setCss(new StyleReference(this.userAgent));
        ITextFontResolver fontResolver = new ITextFontResolver(this._sharedContext);
        this._sharedContext.setFontResolver(fontResolver);
        Docx4jReplacedElementFactory replacedElementFactory = new Docx4jReplacedElementFactory(this._outputDevice);
        this._sharedContext.setReplacedElementFactory(replacedElementFactory);
        this._sharedContext.setTextRenderer(new Docx4jTextRenderer());
        this._sharedContext.setDPI(72.0f * this._dotsPerPoint);
        this._sharedContext.setDotsPerPixel(dotsPerPixel);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public Document loadDocument(String uri) {
        return this._sharedContext.getUac().getXMLResource(uri).getDocument();
    }

    public void setDocument(Document doc, String url) {
        this.setDocument(doc, url, new XhtmlNamespaceHandler());
    }

    private void setDocument(Document doc, String url, NamespaceHandler nsh) {
        this._doc = doc;
        this._sharedContext.reset();
        if (Configuration.isTrue("xr.cache.stylesheets", true)) {
            this._sharedContext.getCss().flushStyleSheets();
        } else {
            this._sharedContext.getCss().flushAllStyleSheets();
        }
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, new NullUserInterface());
    }

    public void layout() {
        LayoutContext c = this.newLayoutContext();
        BlockBox root = BoxBuilder.createRootBox(c, this._doc);
        root.setContainingBlock(new ViewportBox(this.getInitialExtents(c)));
        root.layout(c);
        this._root = root;
    }

    private Rectangle getInitialExtents(LayoutContext c) {
        PageBox first = Layer.createPageBox(c, "first");
        return new Rectangle(0, 0, first.getContentWidth(c), first.getContentHeight(c));
    }

    private LayoutContext newLayoutContext() {
        LayoutContext result = this._sharedContext.newLayoutContextInstance();
        result.setFontContext(new ITextFontContext());
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        return result;
    }

    private static final class NullUserInterface
    implements UserInterface {
        private NullUserInterface() {
        }

        public boolean isHover(Element e) {
            return false;
        }

        public boolean isActive(Element e) {
            return false;
        }

        public boolean isFocus(Element e) {
            return false;
        }
    }
}

