/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.DerivedValue;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.css.style.derived.ColorValue;
import com.openhtmltopdf.css.style.derived.CountersValue;
import com.openhtmltopdf.css.style.derived.FunctionValue;
import com.openhtmltopdf.css.style.derived.LengthValue;
import com.openhtmltopdf.css.style.derived.ListValue;
import com.openhtmltopdf.css.style.derived.NumberValue;
import com.openhtmltopdf.css.style.derived.StringValue;
import com.openhtmltopdf.layout.Styleable;
import com.openhtmltopdf.newtable.TableBox;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.newtable.TableRowBox;
import com.openhtmltopdf.newtable.TableSectionBox;
import com.openhtmltopdf.render.AnonymousBlockBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.InlineBox;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.util.XRRuntimeException;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Bidi;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.docx4j.Docx4jProperties;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.BookmarkHelper;
import org.docx4j.convert.in.xhtml.DivHandler;
import org.docx4j.convert.in.xhtml.DomCssValueAdaptor;
import org.docx4j.convert.in.xhtml.FontHandler;
import org.docx4j.convert.in.xhtml.FormattingOption;
import org.docx4j.convert.in.xhtml.HeadingHandler;
import org.docx4j.convert.in.xhtml.ImportXHTMLProperties;
import org.docx4j.convert.in.xhtml.ListHelper;
import org.docx4j.convert.in.xhtml.MHTContentHandler;
import org.docx4j.convert.in.xhtml.MHTFilterInputStream;
import org.docx4j.convert.in.xhtml.PPrCleanser;
import org.docx4j.convert.in.xhtml.ParagraphBorderHelper;
import org.docx4j.convert.in.xhtml.RPrCleanser;
import org.docx4j.convert.in.xhtml.TableHelper;
import org.docx4j.convert.in.xhtml.XHTMLImageHandler;
import org.docx4j.convert.in.xhtml.XHTMLImageHandlerDefault;
import org.docx4j.convert.in.xhtml.XHTMLImporter;
import org.docx4j.convert.in.xhtml.renderer.DocxRenderer;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.jaxb.Context;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.AbstractParagraphProperty;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.model.properties.run.FontSize;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.ObjectFactory;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Body;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.DocDefaults;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XHTMLImporterImpl
implements XHTMLImporter {
    public static Logger log = LoggerFactory.getLogger(XHTMLImporterImpl.class);
    protected WordprocessingMLPackage wordMLPackage;
    private RelationshipsPart rp;
    private NumberingDefinitionsPart ndp;
    private String hyperlinkStyleId = null;
    private XHTMLImageHandler xHTMLImageHandler = new XHTMLImageHandlerDefault(this);
    private DivHandler divHandler;
    private Body imports = null;
    private ListHelper listHelper;
    private TableHelper tableHelper;
    private DocxRenderer renderer;
    private FormattingOption runFormatting = FormattingOption.CLASS_PLUS_OTHER;
    private FormattingOption paragraphFormatting = FormattingOption.CLASS_PLUS_OTHER;
    private FormattingOption tableFormatting = FormattingOption.CLASS_PLUS_OTHER;
    private static Set<String> cssWhiteList = null;
    private HeadingHandler headingHandler = null;
    private BookmarkHelper bookmarkHelper;
    private CTMarkupRange markuprange;
    Map<String, Style> stylesByID = new HashMap<String, Style>();
    private LinkedList<ContentAccessor> contentContextStack = new LinkedList();
    P attachmentPointP = null;
    P.Hyperlink attachmentPointH = null;
    private static final String FIGCAPTION_SEQUENCE_ATTRIBUTE_NAME = "sequence";
    private static final String FIGCAPTION_SEQUENCE_ATTRIBUTE_VALUE_DEFAULT = "Figure";
    private Map<String, Integer> sequenceCounters = null;
    private String bookmarkNamePrefix = "";
    private static String HR_XML = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:pict><v:rect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" id=\"_x0000_i1025\" style=\"width:0;height:1.5pt\" o:hralign=\"center\" o:hrstd=\"t\" o:hr=\"t\" fillcolor=\"#a0a0a0\" stroked=\"f\"/></w:pict></w:r></w:p>";
    private static P HR_P = null;

    private XHTMLImporterImpl() {
    }

    public XHTMLImporterImpl(WordprocessingMLPackage wordMLPackage) {
        this.displayFormattingOptionSettings();
        this.wordMLPackage = wordMLPackage;
        this.rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        this.ndp = wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart();
        if (this.ndp == null) {
            log.debug("No NumberingDefinitions part - so adding");
            try {
                this.ndp = new NumberingDefinitionsPart();
                wordMLPackage.getMainDocumentPart().addTargetPart((Part)this.ndp);
                this.ndp.setJaxbElement((Object)Context.getWmlObjectFactory().createNumbering());
            }
            catch (InvalidFormatException e1) {
                e1.printStackTrace();
            }
        }
        this.listHelper = new ListHelper(this, this.ndp);
        this.tableHelper = new TableHelper(this);
        if (this.hyperlinkStyleId != null && wordMLPackage instanceof WordprocessingMLPackage) {
            wordMLPackage.getMainDocumentPart().getPropertyResolver().activateStyle(this.hyperlinkStyleId);
        }
        this.initStyleMap(wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart());
        if (ImportXHTMLProperties.getProperty("docx4j-ImportXHTML.Element.Heading.MapToStyle", false)) {
            this.headingHandler = new HeadingHandler((Styles)wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart().getJaxbElement());
        }
        this.imports = Context.getWmlObjectFactory().createBody();
        this.contentContextStack.push((ContentAccessor)this.imports);
        this.bookmarkHelper = new BookmarkHelper(wordMLPackage);
    }

    @Override
    public void setHyperlinkStyle(String hyperlinkStyleID) {
        this.hyperlinkStyleId = hyperlinkStyleID;
    }

    public void setXHTMLImageHandler(XHTMLImageHandler xHTMLImageHandler) {
        this.xHTMLImageHandler = xHTMLImageHandler;
    }

    @Override
    public void setMaxWidth(int maxWidth, String tableStyle) {
        this.xHTMLImageHandler.setMaxWidth(maxWidth, tableStyle);
    }

    public void setDivHandler(DivHandler divHandler) {
        this.divHandler = divHandler;
    }

    protected ListHelper getListHelper() {
        return this.listHelper;
    }

    protected TableHelper getTableHelper() {
        return this.tableHelper;
    }

    public DocxRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = this.paragraphFormatting == FormattingOption.CLASS_PLUS_OTHER || this.paragraphFormatting == FormattingOption.CLASS_TO_STYLE_ONLY ? new DocxRenderer(this.stylesToCSS()) : new DocxRenderer();
        }
        return this.renderer;
    }

    public void setRenderer(DocxRenderer renderer) {
        this.renderer = renderer;
    }

    public static void addFontMapping(String cssFontFamily, RFonts rFonts) {
        FontHandler.addFontMapping(cssFontFamily, rFonts);
    }

    public static void addFontMapping(String cssFontFamily, String font) {
        FontHandler.addFontMapping(cssFontFamily, font);
    }

    @Override
    public void setRunFormatting(FormattingOption runFormatting) {
        this.runFormatting = runFormatting;
    }

    @Override
    public void setParagraphFormatting(FormattingOption paragraphFormatting) {
        this.paragraphFormatting = paragraphFormatting;
    }

    @Override
    public void setTableFormatting(FormattingOption tableFormatting) {
        this.tableFormatting = tableFormatting;
    }

    protected FormattingOption getTableFormatting() {
        return this.tableFormatting;
    }

    private void displayFormattingOptionSettings() {
        log.info("tableFormatting: " + (Object)((Object)this.tableFormatting));
        log.info("paragraphFormatting: " + (Object)((Object)this.paragraphFormatting));
        log.info("runFormatting: " + (Object)((Object)this.runFormatting));
    }

    @Deprecated
    public static void setCssWhiteList(Set<String> cssWhiteList) {
        XHTMLImporterImpl.cssWhiteList = cssWhiteList;
    }

    @Override
    public AtomicInteger getBookmarkIdLast() {
        return this.bookmarkHelper.getBookmarkId();
    }

    public void setBookmarkIdNext(AtomicInteger val) {
        this.bookmarkHelper.setBookmarkId(val);
    }

    private void setDefaultFontSize() {
        DocDefaults.RPrDefault rPrDefault;
        StyleDefinitionsPart sdp = this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart();
        if (sdp != null && ((Styles)sdp.getJaxbElement()).getDocDefaults() != null && (rPrDefault = ((Styles)sdp.getJaxbElement()).getDocDefaults().getRPrDefault()) != null && rPrDefault.getRPr() != null && rPrDefault.getRPr().getSz() != null) {
            HpsMeasure sz = rPrDefault.getRPr().getSz();
            FontSize.mediumHalfPts.set(sz.getVal());
        }
    }

    private void unsetDefaultFontSize() {
        FontSize.mediumHalfPts.remove();
    }

    private void initStyleMap(StyleDefinitionsPart sdp) {
        if (sdp == null) {
            return;
        }
        Styles styles = (Styles)sdp.getJaxbElement();
        for (Style s : styles.getStyle()) {
            this.stylesByID.put(s.getStyleId(), s);
        }
    }

    private String stylesToCSS() {
        String css = this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart().getCss();
        if (css == null) {
            StringBuilder result = new StringBuilder();
            HtmlCssHelper.createCssForStyles((OpcPackage)this.wordMLPackage, (StyleTree)this.wordMLPackage.getMainDocumentPart().getStyleTree(), (StringBuilder)result);
            css = result.toString();
            this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart().setCss(css);
        }
        log.info(css);
        return css;
    }

    @Override
    public List<Object> convert(File file, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        File parent = file.getAbsoluteFile().getParentFile();
        try {
            this.renderer.setDocument(this.renderer.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new Docx4JException("Malformed URL", (Exception)e);
        }
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    @Override
    public List<Object> convert(InputSource is, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        Document dom = XMLResource.load((InputSource)is).getDocument();
        this.renderer.setDocument(dom, baseUrl);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    public List<Object> convertMHT(InputStream is, String baseUrl) throws Docx4JException {
        MHTContentHandler handler = new MHTContentHandler();
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)handler);
        try {
            parser.parse(is);
            if (handler.getBody() == null) {
                log.error("Couldn't get body from mht");
                throw new Docx4JException("Couldn't get body from mht");
            }
            log.info(handler.getCharset());
            if ("text/html".equals(handler.getMimeType())) {
                log.info("Filtering html altChunk");
                return this.convert(new MHTFilterInputStream(handler.getBody()), baseUrl);
            }
            throw new Docx4JException("Unexpected Mime type: " + handler.getMimeType());
        }
        catch (Exception e) {
            throw new Docx4JException(e.getMessage(), e);
        }
    }

    @Override
    public List<Object> convert(InputStream is, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        Document dom = XMLResource.load((InputStream)is).getDocument();
        this.renderer.setDocument(dom, baseUrl);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    @Override
    public List<Object> convert(Node node, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        if (node instanceof Document) {
            this.renderer.setDocument((Document)node, baseUrl);
        } else {
            Document doc = XmlUtils.neww3cDomDocument();
            doc.importNode(node, true);
            this.renderer.setDocument(doc, baseUrl);
        }
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    @Override
    public List<Object> convert(Reader reader, String baseUrl) throws Docx4JException {
        this.renderer = this.getRenderer();
        Document dom = XMLResource.load((Reader)reader).getDocument();
        this.renderer.setDocument(dom, baseUrl);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    @Override
    public List<Object> convert(URL url) throws Docx4JException {
        this.renderer = this.getRenderer();
        String urlString = url.toString();
        Document dom = this.renderer.loadDocument(urlString);
        this.renderer.setDocument(dom, urlString);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    @Override
    public List<Object> convert(String content, String baseUrl) throws Docx4JException {
        Document dom;
        int firstChar = content.codePointAt(0);
        if (firstChar == 65279) {
            log.info("Removing BOM..");
            content = content.substring(1);
        }
        this.renderer = this.getRenderer();
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        try {
            dom = XMLResource.load((InputSource)is).getDocument();
        }
        catch (XRRuntimeException xre) {
            Throwable t = xre.getCause();
            log.error(t.getMessage(), t);
            if (t instanceof TransformerException) {
                Throwable t2 = ((TransformerException)t).getCause();
                if (t2 instanceof SAXParseException) {
                    throw new Docx4JException("issues at Line " + ((SAXParseException)t2).getLineNumber() + ", Col " + ((SAXParseException)t2).getColumnNumber(), t);
                }
                throw new Docx4JException(((TransformerException)t).getLocationAsString(), t);
            }
            throw xre;
        }
        this.renderer.setDocument(dom, baseUrl);
        this.renderer.layout();
        this.traverse((Box)this.renderer.getRootBox(), null);
        return this.imports.getContent();
    }

    public Map<String, PropertyValue> getCascadedProperties(CalculatedStyle cs) {
        HashMap<String, PropertyValue> cssMap = new HashMap<String, PropertyValue>();
        FSDerivedValue[] derivedValues = cs.getderivedValuesById();
        for (int i = 0; i < derivedValues.length; ++i) {
            CSSName name = CSSName.getByID((int)i);
            if (name.toString().startsWith("-fs") || cssWhiteList != null && !cssWhiteList.contains(name.toString())) continue;
            FSDerivedValue val = cs.valueByName(name);
            if (val == null) {
                log.warn("Skipping " + name.toString() + " .. (null value)");
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug(val.getClass().getName() + ": " + name + " = " + val.asString());
            }
            if (val instanceof IdentValue) {
                if (name.toString().equals("text-align") && (val.asString().equals("start") || val.asString().equals("end"))) {
                    PropertyValue val2 = val.asString().equals("start") ? new PropertyValue(21, "left", "left") : new PropertyValue(21, "right", "right");
                    cssMap.put(name.toString(), val2);
                    continue;
                }
                PropertyValue val2 = new PropertyValue((IdentValue)val);
                cssMap.put(name.toString(), val2);
                continue;
            }
            if (val instanceof ColorValue) {
                PropertyValue val2 = new PropertyValue(((ColorValue)val).asColor());
                cssMap.put(name.toString(), val2);
                continue;
            }
            if (val instanceof LengthValue) {
                PropertyValue val2 = new PropertyValue(XHTMLImporterImpl.getLengthPrimitiveType(val), val.asFloat(), val.asString());
                cssMap.put(name.toString(), val2);
                continue;
            }
            if (val instanceof NumberValue) {
                PropertyValue val2 = new PropertyValue(((NumberValue)val).getCssSacUnitType(), val.asFloat(), val.asString());
                cssMap.put(name.toString(), val2);
                continue;
            }
            if (val instanceof StringValue) {
                PropertyValue val2 = new PropertyValue(((StringValue)val).getCssSacUnitType(), val.asString(), val.asString());
                cssMap.put(name.toString(), val2);
                continue;
            }
            if (val instanceof ListValue) {
                PropertyValue val2 = new PropertyValue(((ListValue)val).getValues());
                cssMap.put(name.toString(), val2);
                continue;
            }
            if (val instanceof CountersValue) {
                boolean unused = false;
                PropertyValue val2 = new PropertyValue(((CountersValue)val).getValues(), unused);
                cssMap.put(name.toString(), val2);
                continue;
            }
            if (val instanceof FunctionValue) {
                PropertyValue val2 = new PropertyValue(((FunctionValue)val).getFunction());
                cssMap.put(name.toString(), val2);
                continue;
            }
            if (val instanceof DerivedValue) {
                log.warn("TODO handle DerivedValue type " + val.getClass().getName() + " with name  " + name + " = " + val.asString());
                PropertyValue val2 = new PropertyValue(((DerivedValue)val).getCssSacUnitType(), val.asString(), val.asString());
                cssMap.put(name.toString(), val2);
                continue;
            }
            log.warn("TODO Skipping " + name.toString() + " .. " + val.getClass().getName());
        }
        return cssMap;
    }

    public static short getLengthPrimitiveType(FSDerivedValue val) {
        if (val instanceof LengthValue) {
            return ((LengthValue)val).getLengthPrimitiveType();
        }
        throw new RuntimeException("Unexpected type " + val.getClass().getName());
    }

    protected LinkedList<ContentAccessor> getContentContextStack() {
        return this.contentContextStack;
    }

    private void pushBlockStack(ContentAccessor ca) {
        this.contentContextStack.push(ca);
        this.attachmentPointP = null;
    }

    private ContentAccessor popBlockStack() {
        this.attachmentPointP = null;
        return this.contentContextStack.pop();
    }

    private P getCurrentParagraph(boolean create) {
        if (this.attachmentPointP != null) {
            return this.attachmentPointP;
        }
        if (create) {
            P newP;
            this.attachmentPointP = newP = Context.getWmlObjectFactory().createP();
            this.contentContextStack.peek().getContent().add(newP);
            return newP;
        }
        return null;
    }

    private ContentAccessor getListForRun() {
        if (this.attachmentPointH != null) {
            return this.attachmentPointH;
        }
        return this.getCurrentParagraph(true);
    }

    private void traverse(Box box, TableProperties tableProperties) throws Docx4JException {
        this.setDefaultFontSize();
        this.traverse(box, null, tableProperties);
        this.unsetDefaultFontSize();
    }

    private void traverse(Box box, Box parent, TableProperties tableProperties) throws Docx4JException {
        log.debug(box.getClass().getName());
        if (box instanceof BlockBox) {
            this.traverseBlockBox(box, parent, tableProperties);
        } else if (box instanceof AnonymousBlockBox) {
            log.debug("AnonymousBlockBox");
        } else {
            log.warn(box.getClass().getName());
        }
    }

    private void traverseBlockBox(Box box, Box parent, TableProperties tableProperties) throws Docx4JException {
        Tc tc;
        boolean mustPop = false;
        BlockBox blockBox = (BlockBox)box;
        Element e = box.getElement();
        if (e == null) {
            log.debug("<NULL>");
        } else {
            log.debug(box.getStyle().getStringProperty(CSSName.DISPLAY));
        }
        CTMarkupRange markupRangeForID = null;
        if (!(box instanceof TableSectionBox)) {
            markupRangeForID = box instanceof TableBox ? this.bookmarkHelper.anchorToBookmark(e, this.bookmarkNamePrefix, null, this.contentContextStack.peek()) : this.bookmarkHelper.anchorToBookmark(e, this.bookmarkNamePrefix, this.getCurrentParagraph(false), this.contentContextStack.peek());
        }
        if (markupRangeForID != null) {
            log.debug("Added bookmark for " + box.getClass().getName() + "<" + e.getNodeName());
        }
        if (e != null) {
            Iterator cssMap = this.getCascadedProperties(box.getStyle());
            if (e.getNodeName().equals("div")) {
                ContentAccessor ca;
                if (this.divHandler != null && (ca = this.divHandler.enter(blockBox, this.contentContextStack.peek())) != null) {
                    this.pushBlockStack(ca);
                    mustPop = true;
                }
                if (box.getStyle().getStringProperty(CSSName.DISPLAY).equals("block") && this.getCurrentParagraph(false) != null && this.getCurrentParagraph(false).getPPr() != null && this.getCurrentParagraph(false).getPPr().getNumPr() != null) {
                    PPrBase.NumPr numPr = this.getCurrentParagraph(false).getPPr().getNumPr();
                    this.getCurrentParagraph(true).setPPr(this.getPPr(blockBox, (Map<String, PropertyValue>)((Object)cssMap)));
                    this.getCurrentParagraph(false).getPPr().setNumPr(numPr);
                } else {
                    this.getCurrentParagraph(true).setPPr(this.getPPr(blockBox, (Map<String, PropertyValue>)((Object)cssMap)));
                }
            } else if (!box.getStyle().getStringProperty(CSSName.DISPLAY).equals("inline")) {
                P currentP;
                ContentAccessor contentContext;
                if (e.getNodeName().equals("ol") || e.getNodeName().equals("ul")) {
                    log.info("entering list");
                    this.listHelper.pushListStack(blockBox);
                } else if (box instanceof TableSectionBox) {
                    log.debug(".. processing <tbody");
                } else if (box instanceof TableBox) {
                    log.debug(".. processing table");
                    contentContext = this.contentContextStack.peek();
                    this.tableHelper.nestedTableHierarchyFix(contentContext, parent);
                    currentP = this.getCurrentParagraph(false);
                    if (currentP != null && currentP.getContent().size() == 0) {
                        contentContext.getContent().remove(currentP);
                    }
                    Tbl tbl = Context.getWmlObjectFactory().createTbl();
                    contentContext.getContent().add(tbl);
                    this.pushBlockStack((ContentAccessor)tbl);
                    mustPop = true;
                    TableBox tableBox = (TableBox)box;
                    tableProperties = new TableProperties();
                    tableProperties.setTableBox(tableBox);
                    this.tableHelper.setupTblPr(tableBox, tbl, tableProperties);
                    this.tableHelper.setupTblGrid(tableBox, tbl, tableProperties);
                } else if (e.getNodeName().equals("table")) {
                    log.warn("Encountered non-TableBox table: " + box.getClass().getName());
                    contentContext = this.contentContextStack.peek();
                    this.tableHelper.nestedTableHierarchyFix(contentContext, parent);
                    currentP = this.getCurrentParagraph(false);
                    if (currentP != null && currentP.getContent().size() == 0) {
                        contentContext.getContent().remove(currentP);
                    }
                    Tbl tbl = Context.getWmlObjectFactory().createTbl();
                    contentContext.getContent().add(tbl);
                    this.pushBlockStack((ContentAccessor)tbl);
                    mustPop = true;
                } else if (box instanceof TableRowBox) {
                    log.debug(".. processing <tr");
                    Tr tr = Context.getWmlObjectFactory().createTr();
                    this.contentContextStack.peek().getContent().add(tr);
                    this.pushBlockStack((ContentAccessor)tr);
                    mustPop = true;
                    this.tableHelper.setupTrPr((TableRowBox)box, tr);
                } else if (box instanceof TableCellBox) {
                    log.debug(".. processing <td");
                    ContentAccessor trContext = this.contentContextStack.peek();
                    TableCellBox tcb = (TableCellBox)box;
                    if (tcb.getParent().getChild(0) == tcb && tcb.getCol() > 0) {
                        this.tableHelper.insertDummyVMergedCells(this.contentContextStack.peek(), tcb, true);
                    }
                    Tc tc2 = Context.getWmlObjectFactory().createTc();
                    this.contentContextStack.peek().getContent().add(tc2);
                    this.pushBlockStack((ContentAccessor)tc2);
                    mustPop = true;
                    this.tableHelper.setupTcPr(tcb, tc2, tableProperties);
                    this.tableHelper.insertDummyVMergedCells(trContext, tcb, false);
                } else if (this.isListItem(blockBox.getElement()) && !(blockBox instanceof AnonymousBlockBox)) {
                    this.listHelper.peekListItemStateStack().init();
                    PPr pPr = Context.getWmlObjectFactory().createPPr();
                    this.getCurrentParagraph(true).setPPr(pPr);
                    if (this.paragraphFormatting.equals((Object)FormattingOption.IGNORE_CLASS)) {
                        this.listHelper.addNumbering(this.getCurrentParagraph(true), blockBox.getElement(), (Map<String, PropertyValue>)((Object)cssMap));
                        this.addParagraphProperties(pPr, (Styleable)blockBox, (Map<String, PropertyValue>)((Object)cssMap));
                    } else if (this.listHelper.peekListStack().getElement() != null && this.listHelper.peekListStack().getElement().getAttribute("class") != null) {
                        String cssClass = this.listHelper.peekListStack().getElement().getAttribute("class").trim();
                        log.debug(cssClass);
                        if (cssClass.equals("")) {
                            if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                                this.listHelper.addNumbering(this.getCurrentParagraph(true), blockBox.getElement(), (Map<String, PropertyValue>)((Object)cssMap));
                                this.addParagraphProperties(pPr, (Styleable)blockBox, (Map<String, PropertyValue>)((Object)cssMap));
                            }
                        } else {
                            BigInteger numId;
                            Style s;
                            int pos = cssClass.indexOf(" ");
                            if (pos > -1) {
                                cssClass = cssClass.substring(0, pos);
                            }
                            if ((s = this.stylesByID.get(cssClass)) == null) {
                                log.debug("No docx style for @class='" + cssClass + "'");
                                if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                                    this.listHelper.addNumbering(this.getCurrentParagraph(true), blockBox.getElement(), (Map<String, PropertyValue>)((Object)cssMap));
                                    this.addParagraphProperties(pPr, (Styleable)blockBox, (Map<String, PropertyValue>)((Object)cssMap));
                                }
                            } else if (s.getType() != null && s.getType().equals("numbering")) {
                                log.debug("Using list style from @class='" + cssClass + "'");
                                numId = s.getPPr().getNumPr().getNumId().getVal();
                                this.listHelper.setNumbering(pPr, numId);
                                if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                                    this.addParagraphProperties(pPr, (Styleable)blockBox, (Map<String, PropertyValue>)((Object)cssMap));
                                }
                            } else {
                                log.debug("For docx style for @class='" + cssClass + "', but its not a numbering style ");
                                if (s.getPPr() != null && s.getPPr().getNumPr() != null && s.getPPr().getNumPr().getNumId() != null && s.getPPr().getNumPr().getNumId().getVal() != null) {
                                    numId = s.getPPr().getNumPr().getNumId().getVal();
                                    this.listHelper.setNumbering(pPr, numId);
                                } else {
                                    log.debug(".. and doesn't contain numPr  ");
                                    this.listHelper.addNumbering(this.getCurrentParagraph(true), blockBox.getElement(), (Map<String, PropertyValue>)((Object)cssMap));
                                }
                                if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                                    if (Docx4jProperties.getProperty((String)"docx4j.model.datastorage.BindingTraverser.XHTML.Block.rStyle.Adopt", (boolean)false) && s.getType() != null && s.getType().equals("paragraph")) {
                                        log.debug(".. using " + s.getStyleId());
                                        PPrBase.PStyle pStyle = Context.getWmlObjectFactory().createPPrBasePStyle();
                                        pStyle.setVal(s.getStyleId());
                                        this.getCurrentParagraph(false).getPPr().setPStyle(pStyle);
                                    }
                                    this.addParagraphProperties(pPr, (Styleable)blockBox, (Map<String, PropertyValue>)((Object)cssMap));
                                }
                            }
                        }
                    } else if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                        this.addParagraphProperties(pPr, (Styleable)blockBox, (Map<String, PropertyValue>)((Object)cssMap));
                    }
                } else if (e.getNodeName().equals("img")) {
                    this.addImage(blockBox);
                } else if (e.getNodeName().equals("hr")) {
                    this.contentContextStack.peek().getContent().add(this.getPforHR());
                } else {
                    log.debug("default handling for " + e.getNodeName());
                    if (this.listHelper.getDepth() > 0 && !this.listHelper.peekListItemStateStack().haveMergedFirstP) {
                        log.debug("use existing attachmentPoint");
                        this.listHelper.peekListItemStateStack().haveMergedFirstP = true;
                    } else {
                        log.debug("create new attachmentPoint");
                        P currentP2 = this.getCurrentParagraph(true);
                        currentP2.setPPr(this.getPPr(blockBox, (Map<String, PropertyValue>)((Object)cssMap)));
                        log.debug(XmlUtils.marshaltoString((Object)currentP2));
                        if (e.getNodeName().equals("figcaption")) {
                            this.prepareCaption(e, currentP2);
                        }
                    }
                }
            }
        }
        log.debug("Processing children of " + box.getElement().getNodeName());
        switch (blockBox.getChildrenContentType()) {
            case BLOCK: {
                log.debug(".. which are BlockBox.CONTENT_BLOCK");
                for (Object o : ((BlockBox)box).getChildren()) {
                    log.debug("   processing child " + o.getClass().getName());
                    this.traverse((Box)o, box, tableProperties);
                    log.debug(".. processed child " + o.getClass().getName());
                }
                break;
            }
            case INLINE: {
                log.debug(".. which are BlockBox.CONTENT_INLINE");
                if (((BlockBox)box).getInlineContent() == null) break;
                for (Object o : ((BlockBox)box).getInlineContent()) {
                    if (o instanceof InlineBox) {
                        this.processInlineBox((InlineBox)o);
                    } else if (o instanceof BlockBox) {
                        this.traverse((Box)o, box, tableProperties);
                    } else {
                        log.debug("What to do with " + box.getClass().getName());
                    }
                    log.debug(".. processed child " + o.getClass().getName());
                }
                if (this.markuprange != null) {
                    this.getCurrentParagraph(true).getContent().add(this.markuprange);
                    this.markuprange = null;
                }
                if (this.listHelper.getDepth() <= 0) break;
                this.listHelper.peekListItemStateStack().haveMergedFirstP = true;
                break;
            }
            case EMPTY: {
                break;
            }
            case UNKNOWN: {
                log.warn(".. which are UNKNOWN ");
                break;
            }
            default: {
                log.warn(".. which are ??? " + blockBox.getChildrenContentType());
            }
        }
        log.debug("Done processing children of " + box.getClass().getName());
        if (e.getNodeName().equals("ol") || e.getNodeName().equals("ul")) {
            log.info(".. exiting list");
            this.listHelper.popListStack();
        }
        if (this.contentContextStack.peek() instanceof Tc && ((tc = (Tc)this.contentContextStack.peek()).getContent().size() == 0 || tc.getContent().get(tc.getContent().size() - 1) instanceof Tbl)) {
            tc.getContent().add(Context.getWmlObjectFactory().createP());
        }
        if (!e.getNodeName().equals("img")) {
            this.attachmentPointP = null;
            if (mustPop) {
                this.popBlockStack();
            }
        }
        if (e.getNodeName().equals("div") && this.divHandler != null) {
            this.divHandler.leave();
        }
        if (markupRangeForID != null) {
            this.bookmarkHelper.attachBookmarkEnd(markupRangeForID, this.getCurrentParagraph(false), this.contentContextStack.peek());
            markupRangeForID = null;
        }
    }

    @Override
    public Map<String, Integer> getSequenceCounters() {
        if (this.sequenceCounters == null) {
            this.sequenceCounters = new HashMap<String, Integer>();
        }
        return this.sequenceCounters;
    }

    @Override
    public void setSequenceCounters(Map<String, Integer> sequenceCounters) {
        this.sequenceCounters = sequenceCounters;
    }

    private void prepareCaption(Element figcaption, P currentP) {
        Integer i;
        PPrBase.PStyle pStyle;
        PPr pPr = currentP.getPPr();
        if (pPr == null) {
            pPr = Context.getWmlObjectFactory().createPPr();
            currentP.setPPr(pPr);
        }
        if ((pStyle = pPr.getPStyle()) == null) {
            pStyle = Context.getWmlObjectFactory().createPPrBasePStyle();
            pPr.setPStyle(pStyle);
        }
        pStyle.setVal("Caption");
        String sequenceName = FIGCAPTION_SEQUENCE_ATTRIBUTE_VALUE_DEFAULT;
        if (figcaption.getAttribute(FIGCAPTION_SEQUENCE_ATTRIBUTE_NAME) != null && figcaption.getAttribute(FIGCAPTION_SEQUENCE_ATTRIBUTE_NAME).trim().length() > 0) {
            sequenceName = figcaption.getAttribute(FIGCAPTION_SEQUENCE_ATTRIBUTE_NAME);
        }
        int count = (i = this.getSequenceCounters().get(sequenceName)) == null ? 0 : i;
        this.getSequenceCounters().put(sequenceName, ++count);
        if (!sequenceName.endsWith(" ")) {
            sequenceName = sequenceName + " ";
        }
        R figureRun = new R();
        Text text = Context.getWmlObjectFactory().createText();
        figureRun.getContent().add(text);
        text.setValue(sequenceName);
        text.setSpace("preserve");
        currentP.getContent().add(figureRun);
        CTSimpleField simpleField = new CTSimpleField();
        simpleField.setInstr(" SEQ " + sequenceName + " \\* ARABIC ");
        JAXBElement wrapper = Context.getWmlObjectFactory().createPFldSimple(simpleField);
        currentP.getContent().add(wrapper);
        R resultRun = new R();
        Text result = Context.getWmlObjectFactory().createText();
        result.setValue("" + count);
        resultRun.getContent().add(result);
        simpleField.getContent().add(resultRun);
    }

    protected PPr getPPr(BlockBox blockBox, Map<String, PropertyValue> cssMap) {
        PPr pPr = Context.getWmlObjectFactory().createPPr();
        this.populatePPr(pPr, (Styleable)blockBox, cssMap);
        return pPr;
    }

    protected boolean isBidi(String pText) {
        if (pText == null || pText.trim().length() == 0) {
            return false;
        }
        if (!ImportXHTMLProperties.getProperty("docx4j-ImportXHTML.Bidi.Heuristic", false)) {
            return false;
        }
        int ltr = 0;
        int rtl = 0;
        Bidi bidi = new Bidi(pText, -2);
        for (int i = 0; i < bidi.getRunCount(); ++i) {
            int start = bidi.getRunStart(i);
            int end = bidi.getRunLimit(i);
            if (this.isEven(bidi.getRunLevel(i))) {
                ltr += end - start;
                continue;
            }
            rtl += end - start;
        }
        if (ltr == 0) {
            return rtl > 0;
        }
        return (double)(rtl / ltr) > 0.5;
    }

    protected void populatePPr(PPr pPr, Styleable blockBox, Map<String, PropertyValue> cssMap) {
        if (this.paragraphFormatting.equals((Object)FormattingOption.IGNORE_CLASS)) {
            this.addParagraphProperties(pPr, blockBox, cssMap);
            this.handleHeadingElement(pPr, blockBox);
        } else {
            if (blockBox.getElement() == null) {
                log.debug("null blockBox element");
            } else if (blockBox.getElement().getAttribute("class") == null) {
                log.debug("no @class");
            } else {
                String cssClass = blockBox.getElement().getAttribute("class").trim();
                if (cssClass.equals("")) {
                    this.handleHeadingElement(pPr, blockBox);
                } else {
                    Style s;
                    int pos = cssClass.indexOf(" ");
                    if (pos > -1) {
                        cssClass = cssClass.substring(0, pos);
                    }
                    if ((s = this.stylesByID.get(cssClass)) == null) {
                        log.debug("No docx style for @class='" + cssClass + "'");
                        this.handleHeadingElement(pPr, blockBox);
                    } else if (s.getType() != null && s.getType().equals("paragraph")) {
                        PPrBase.PStyle pStyle = Context.getWmlObjectFactory().createPPrBasePStyle();
                        pPr.setPStyle(pStyle);
                        pStyle.setVal(cssClass);
                    } else {
                        log.debug("For docx style for @class='" + cssClass + "', but its not a paragraph style ");
                        this.handleHeadingElement(pPr, blockBox);
                    }
                }
            }
            if (this.paragraphFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                this.addParagraphProperties(pPr, blockBox, cssMap);
            }
        }
        if (blockBox.getElement() == null) {
            log.debug("BB getElement is null");
        } else if (this.isBidi(blockBox.getElement().getTextContent())) {
            log.debug(".. setting bidi property");
            pPr.setBidi(new BooleanDefaultTrue());
        }
    }

    protected Style getStyleByIdOrName(String ... parameters) {
        String id = parameters[0];
        String name = parameters.length > 1 ? parameters[1] : id;
        Style s = null;
        int pos = id.indexOf(" ");
        if (pos > -1) {
            id = id.substring(0, pos);
        }
        if ((s = this.stylesByID.get(id)) == null) {
            for (Style style : this.stylesByID.values()) {
                if (style.getName() == null || !style.getName().getVal().equals(name)) continue;
                s = style;
                break;
            }
        }
        return s;
    }

    private void handleHeadingElement(PPr pPr, Styleable blockBox) {
        if (this.headingHandler == null || !this.isHeading(blockBox)) {
            return;
        }
        String styleId = this.headingHandler.getStyle(blockBox.getElement().getLocalName());
        if (styleId != null) {
            PPrBase.PStyle pStyle = Context.getWmlObjectFactory().createPPrBasePStyle();
            pPr.setPStyle(pStyle);
            pStyle.setVal(styleId);
        }
    }

    private boolean isHeading(Styleable blockBox) {
        if (blockBox.getElement() == null) {
            return false;
        }
        String elName = blockBox.getElement().getLocalName();
        return "h1".equals(elName) || "h2".equals(elName) || "h3".equals(elName) || "h4".equals(elName) || "h5".equals(elName) || "h6".equals(elName);
    }

    private void addImage(BlockBox box) {
        Rectangle contentBounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), (CssContext)this.getRenderer().getLayoutContext());
        int oldMaxWidth = -1;
        if (this.xHTMLImageHandler instanceof XHTMLImageHandlerDefault) {
            int maxWidth;
            oldMaxWidth = ((XHTMLImageHandlerDefault)this.xHTMLImageHandler).getMaxWidth();
            if (!box.getStyle().isMaxWidthNone() && (maxWidth = box.getStyle().getMaxWidth((CssContext)this.getRenderer().getLayoutContext(), 0)) > 0) {
                ((XHTMLImageHandlerDefault)this.xHTMLImageHandler).setMaxWidth((int)this.dotsToTwip(maxWidth));
            }
        }
        Long cy = contentBounds.height == 0 ? null : Long.valueOf(UnitsOfMeasurement.twipToEMU((double)this.dotsToTwip(contentBounds.height)));
        Long cx = contentBounds.width == 0 ? null : Long.valueOf(UnitsOfMeasurement.twipToEMU((double)this.dotsToTwip(contentBounds.width)));
        this.xHTMLImageHandler.addImage(this.renderer.getDocx4jUserAgent(), this.wordMLPackage, this.getCurrentParagraph(true), box.getElement(), cx, cy);
        if (this.xHTMLImageHandler instanceof XHTMLImageHandlerDefault && !box.getStyle().isMaxWidthNone()) {
            ((XHTMLImageHandlerDefault)this.xHTMLImageHandler).setMaxWidth(oldMaxWidth);
        }
    }

    private float dotsToTwip(float dots) {
        return dots * 72.0f / (float)UnitsOfMeasurement.DPI;
    }

    private void processInlineBox(InlineBox inlineBox) {
        if (inlineBox.getPseudoElementOrClass() != null) {
            log.debug("Ignoring Pseudo");
            return;
        }
        InlineBox s = inlineBox;
        if (log.isDebugEnabled()) {
            log.debug(inlineBox.toString());
            if (s.getElement() == null) {
                log.debug("Null element name");
            } else {
                log.debug(s.getElement().getNodeName());
            }
        }
        if (s.getStyle() == null) {
            log.error("getStyle returned null!");
        }
        if (s.getElement() != null && s.getElement().getNodeName().equals("a") && inlineBox.isStartsHere() && !inlineBox.getElement().hasChildNodes()) {
            String href;
            log.debug("anchor which starts and ends here");
            CTMarkupRange inlineMarkupRange = this.bookmarkHelper.anchorToBookmark(s.getElement(), this.bookmarkNamePrefix, this.getCurrentParagraph(false), this.contentContextStack.peek());
            if (inlineMarkupRange != null) {
                this.bookmarkHelper.attachBookmarkEnd(inlineMarkupRange, this.getCurrentParagraph(false), this.contentContextStack.peek());
                this.markuprange = null;
            }
            if ((href = s.getElement().getAttribute("href")) != null && !href.trim().equals("")) {
                log.warn("Ignoring @href on <a> without content.");
            }
            return;
        }
        Map<String, PropertyValue> cssMap = this.getCascadedProperties(s.getStyle());
        P p = this.getCurrentParagraph(true);
        if (p.getPPr() == null) {
            PPr pPr = Context.getWmlObjectFactory().createPPr();
            this.populatePPr(pPr, (Styleable)s, cssMap);
            p.setPPr(pPr);
        }
        String debug = "<UNKNOWN Styleable";
        if (s.getElement() != null) {
            debug = "<" + s.getElement().getNodeName();
            String cssClass = this.getClassAttribute(s.getElement());
            if (cssClass != null) {
                cssClass = cssClass.trim();
            }
            if (s.getElement().getNodeName().equals("a")) {
                if (inlineBox.isStartsHere()) {
                    log.debug("Processing <a>... with class " + cssClass);
                    String name = s.getElement().getAttribute("name");
                    String href = s.getElement().getAttribute("href");
                    if (name != null && !name.trim().equals("")) {
                        this.markuprange = this.bookmarkHelper.anchorToBookmark(s.getElement(), this.bookmarkNamePrefix, this.getCurrentParagraph(false), this.contentContextStack.peek());
                        if (this.markuprange != null) {
                            // empty if block
                        }
                        if (href == null || href.trim().equals("")) {
                            String theText = inlineBox.getElement().getTextContent();
                            this.addRuns(cssClass, cssMap, theText);
                            if (this.markuprange != null) {
                                this.bookmarkHelper.attachBookmarkEnd(this.markuprange, this.getCurrentParagraph(false), this.contentContextStack.peek());
                                this.markuprange = null;
                            }
                            return;
                        }
                    }
                    if (href != null && !href.trim().equals("")) {
                        P.Hyperlink h = null;
                        String linkText = inlineBox.getElement().getTextContent();
                        RPr rPr = Context.getWmlObjectFactory().createRPr();
                        this.formatRPr(rPr, cssClass, cssMap);
                        log.debug(XmlUtils.marshaltoString((Object)rPr));
                        if (linkText != null && !linkText.trim().equals("")) {
                            log.debug("getText:" + inlineBox.getText());
                            h = this.createHyperlink(href, rPr, inlineBox.getText(), this.rp);
                            this.getCurrentParagraph(false).getContent().add(h);
                            if (this.markuprange != null) {
                                this.bookmarkHelper.attachBookmarkEnd(this.markuprange, this.getCurrentParagraph(false), this.contentContextStack.peek());
                                this.markuprange = null;
                            }
                            if (inlineBox.isEndsHere()) {
                                log.debug("Processing ..</a> (ends here as well) ");
                                return;
                            }
                            log.debug("now attaching inside hyperlink ");
                            this.attachmentPointH = h;
                            return;
                        }
                        log.warn("Expected hyperlink content, since tag not self-closing");
                        h = this.createHyperlink(href, rPr, href, this.rp);
                        this.getCurrentParagraph(false).getContent().add(h);
                        if (this.markuprange != null) {
                            this.bookmarkHelper.attachBookmarkEnd(this.markuprange, this.getCurrentParagraph(false), this.contentContextStack.peek());
                            this.markuprange = null;
                        }
                        return;
                    }
                } else {
                    if (inlineBox.isEndsHere()) {
                        log.debug("Processing ..</a> ");
                        log.debug("getText:" + inlineBox.getText());
                        String endingText = inlineBox.getText();
                        if (endingText != null && endingText.length() > 0) {
                            this.addRuns(cssClass, cssMap, inlineBox.getText());
                        }
                        this.attachmentPointH = null;
                        return;
                    }
                    log.debug("Processing <a> content!");
                }
            }
        }
        if (s.getStyle() != null) {
            // empty if block
        }
        log.debug(debug);
        this.processInlineBoxContent(inlineBox, (Styleable)s, cssMap);
    }

    private void processInlineBoxContent(InlineBox inlineBox, Styleable s, Map<String, PropertyValue> cssMap) {
        CTMarkupRange markupRangeForID = this.bookmarkHelper.anchorToBookmark(inlineBox.getElement(), this.bookmarkNamePrefix, this.getCurrentParagraph(false), this.contentContextStack.peek());
        if (s != null && s.getElement() != null && s.getElement().getNodeName().equals("br")) {
            R run = Context.getWmlObjectFactory().createR();
            this.getListForRun().getContent().add(run);
            run.getContent().add(Context.getWmlObjectFactory().createBr());
        } else if (inlineBox.getText() == null || inlineBox.getText().length() == 0) {
            if (s == null) {
                log.debug("Null Styleable");
            } else if (s.getElement() == null) {
                log.debug("Null element ");
            } else if (s.getElement().getNodeName() == null) {
                log.debug("Null element nodename ");
            } else {
                log.debug("InlineBox has no TextNode, so skipping");
            }
        } else {
            log.warn("\n\n" + inlineBox.getText());
            String theText = inlineBox.getText();
            log.debug("Processing " + theText);
            String cssClass = this.getClassAttribute(s.getElement());
            if (cssClass != null) {
                cssClass = cssClass.trim();
            }
            this.addRuns(cssClass, cssMap, theText);
        }
        if (markupRangeForID != null) {
            this.bookmarkHelper.attachBookmarkEnd(markupRangeForID, this.getCurrentParagraph(false), this.contentContextStack.peek());
        }
    }

    private String getClassAttribute(Element e) {
        if (e == null) {
            return null;
        }
        if (e.getAttribute("class") != null && !e.getAttribute("class").trim().equals("")) {
            return e.getAttribute("class");
        }
        if (e.getParentNode() instanceof Element) {
            return this.getClassAttribute((Element)e.getParentNode());
        }
        return null;
    }

    private void addRuns(String cssClass, Map<String, PropertyValue> cssMap, String theText) {
        if (ImportXHTMLProperties.getProperty("docx4j-ImportXHTML.Bidi.Heuristic", false)) {
            Bidi bidi = null;
            ContentAccessor o = this.getListForRun();
            if (o instanceof P) {
                P p = (P)o;
                if (p.getPPr() != null && p.getPPr().getBidi() != null && p.getPPr().getBidi().isVal()) {
                    log.debug("using Bidi.DIRECTION_RIGHT_TO_LEFT");
                    bidi = new Bidi(theText, 1);
                } else {
                    bidi = new Bidi(theText, 0);
                }
            } else {
                log.warn("TODO: bidi handling for " + o.getClass().getName());
                bidi = new Bidi(theText, 0);
            }
            for (int i = 0; i < bidi.getRunCount(); ++i) {
                int start = bidi.getRunStart(i);
                int end = bidi.getRunLimit(i);
                this.addRun(cssClass, cssMap, theText.substring(start, end), !this.isEven(bidi.getRunLevel(i)));
            }
        } else {
            this.addRun(cssClass, cssMap, theText, false);
        }
    }

    private boolean isEven(int x) {
        return (x & 1) == 0;
    }

    private void addRun(String cssClass, Map<String, PropertyValue> cssMap, String theText, boolean isRTL) {
        R run = Context.getWmlObjectFactory().createR();
        Text text = Context.getWmlObjectFactory().createText();
        text.setValue(theText);
        if (theText.startsWith(" ") || theText.endsWith(" ")) {
            text.setSpace("preserve");
        }
        run.getContent().add(text);
        this.getListForRun().getContent().add(run);
        RPr rPr = Context.getWmlObjectFactory().createRPr();
        run.setRPr(rPr);
        this.formatRPr(rPr, cssClass, cssMap);
        if (isRTL) {
            rPr.setRtl(new BooleanDefaultTrue());
        }
    }

    private void formatRPr(RPr rPr, String cssClass, Map<String, PropertyValue> cssMap) {
        if (this.runFormatting.equals((Object)FormattingOption.IGNORE_CLASS)) {
            this.addRunProperties(rPr, cssMap);
        } else {
            if (cssClass != null && !cssClass.equals("")) {
                Style s;
                int pos = cssClass.indexOf(" ");
                if (pos > -1) {
                    cssClass = cssClass.substring(0, pos);
                }
                if ((s = this.stylesByID.get(cssClass)) == null) {
                    log.debug("No docx style for @class='" + cssClass + "'");
                } else if (s.getType() != null && s.getType().equals("character")) {
                    RStyle rStyle = Context.getWmlObjectFactory().createRStyle();
                    rPr.setRStyle(rStyle);
                    rStyle.setVal(cssClass);
                } else {
                    log.debug("For docx style for @class='" + cssClass + "', but its not a character style ");
                }
            }
            if (this.runFormatting.equals((Object)FormattingOption.CLASS_PLUS_OTHER)) {
                this.addRunProperties(rPr, cssMap);
            }
        }
        PropertyValue fontFamily = cssMap.get("font-family");
        FontHandler.setRFont(fontFamily, rPr);
    }

    private boolean isListItem(Element e) {
        return e.getNodeName().equals("li");
    }

    private void addParagraphProperties(PPr pPr, Styleable styleable, Map<String, PropertyValue> cssMap) {
        for (String o : cssMap.keySet()) {
            PropertyValue cssValue;
            String cssName = o;
            Property p = PropertyFactory.createPropertyFromCssName((String)cssName, (CSSValue)new DomCssValueAdaptor(cssValue = cssMap.get(cssName)));
            if (p == null) continue;
            if (p instanceof AbstractParagraphProperty) {
                ((AbstractParagraphProperty)p).set(pPr);
                continue;
            }
            p = PropertyFactory.createPropertyFromCssNameForPPr((String)cssName, (CSSValue)new DomCssValueAdaptor(cssValue));
            if (p == null || !(p instanceof AbstractParagraphProperty)) continue;
            ((AbstractParagraphProperty)p).set(pPr);
        }
        ParagraphBorderHelper pbh = new ParagraphBorderHelper(this);
        pbh.addBorderProperties(pPr, styleable, cssMap);
        log.debug("list depth:" + this.listHelper.getDepth());
        if (this.listHelper.getDepth() > 0) {
            int totalPadding = this.getListHelper().getAbsoluteIndent((Styleable)this.getListHelper().peekListStack());
            log.debug("totalPadding: " + totalPadding);
            int tableIndentContrib = this.tableHelper.tableIndentContrib(this.contentContextStack);
            if (tableIndentContrib > 0) {
                if (this.listHelper.peekListItemStateStack().isFirstChild) {
                    log.debug("List indent table case : pPr indent set for item itself");
                    pPr.setInd(this.listHelper.createIndent(totalPadding - tableIndentContrib, true));
                    this.listHelper.peekListItemStateStack().isFirstChild = false;
                } else {
                    pPr.setInd(this.listHelper.createIndent(totalPadding + 360 + this.getLocalIndentation(styleable) - tableIndentContrib, false));
                }
            } else if (this.listHelper.peekListItemStateStack().isFirstChild) {
                log.debug("List indent case 2: pPr indent set for item itself");
                pPr.setInd(null);
                this.listHelper.peekListItemStateStack().isFirstChild = false;
                log.debug("first child in this list item now set to false");
            } else {
                log.debug("List indent case 3: pPr indent set for follwing child");
                pPr.setInd(this.listHelper.createIndent(totalPadding + 360 + this.getLocalIndentation(styleable) - tableIndentContrib, false));
            }
        } else {
            log.debug("not in list; handle indent");
            PPrBase.Ind ind = Context.getWmlObjectFactory().createPPrBaseInd();
            ind.setLeft(BigInteger.valueOf(this.getAncestorIndentation(styleable)));
            pPr.setInd(ind);
        }
        PPr stylePPr = null;
        PropertyResolver propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
        if (this.getCurrentParagraph(false).getPPr() != null && this.getCurrentParagraph(false).getPPr().getPStyle() != null) {
            String styleId = this.getCurrentParagraph(false).getPPr().getPStyle().getVal();
            stylePPr = propertyResolver.getEffectivePPr(styleId);
            PPrCleanser.removeRedundantProperties(stylePPr, pPr);
        }
        log.debug(XmlUtils.marshaltoString((Object)pPr, (boolean)true, (boolean)true));
    }

    protected int getLocalIndentation(Styleable styleable) {
        int localPadding = 0;
        Styleable o = styleable;
        while (!(o == null || !(o instanceof BlockBox) || o instanceof TableCellBox || ((BlockBox)o).getElement() != null && ((BlockBox)o).getElement().getLocalName().equals("li"))) {
            BlockBox bb = (BlockBox)o;
            localPadding += this.getBBIndentContrib(bb);
            o = bb.getContainingBlock();
        }
        return localPadding;
    }

    protected int getAncestorIndentation(Styleable styleable) {
        int totalPadding = 0;
        Styleable o = styleable;
        while (o != null && o instanceof BlockBox) {
            BlockBox bb = (BlockBox)o;
            totalPadding += this.getBBIndentContrib(bb);
            o = bb.getContainingBlock();
        }
        return totalPadding;
    }

    private int getBBIndentContrib(BlockBox bb) {
        PropertyValue val;
        int paddingI = 0;
        if (bb.getElement() == null) {
            log.debug("null ... " + bb.getClass().getName());
        } else {
            log.debug(bb.getElement().getLocalName() + bb.getClass().getName());
        }
        if (bb.getStyle() != null && bb.getStyle().valueByName(CSSName.PADDING_LEFT) instanceof LengthValue) {
            LengthValue padding = (LengthValue)bb.getStyle().valueByName(CSSName.PADDING_LEFT);
            val = new PropertyValue(XHTMLImporterImpl.getLengthPrimitiveType((FSDerivedValue)padding), padding.asFloat(), padding.asString());
            paddingI += Indent.getTwip((CSSPrimitiveValue)new DomCssValueAdaptor(val));
        }
        if (bb.getStyle() != null && bb.getStyle().valueByName(CSSName.MARGIN_LEFT) instanceof LengthValue) {
            LengthValue margin = (LengthValue)bb.getStyle().valueByName(CSSName.MARGIN_LEFT);
            val = new PropertyValue(XHTMLImporterImpl.getLengthPrimitiveType((FSDerivedValue)margin), margin.asFloat(), margin.asString());
            paddingI += Indent.getTwip((CSSPrimitiveValue)new DomCssValueAdaptor(val));
        }
        log.debug("adding: " + paddingI);
        return paddingI;
    }

    private void addRunProperties(RPr rPr, Map cssMap) {
        log.debug("addRunProperties");
        String pStyleId = null;
        if (this.getCurrentParagraph(false).getPPr() != null && this.getCurrentParagraph(false).getPPr().getPStyle() != null && "Caption".equals(pStyleId = this.getCurrentParagraph(false).getPPr().getPStyle().getVal())) {
            return;
        }
        for (Object o : cssMap.keySet()) {
            PropertyValue cssValue;
            String cssName = (String)o;
            Property runProp = PropertyFactory.createPropertyFromCssName((String)cssName, (CSSValue)new DomCssValueAdaptor(cssValue = (PropertyValue)cssMap.get(cssName)));
            if (runProp == null || !(runProp instanceof AbstractRunProperty)) continue;
            ((AbstractRunProperty)runProp).set(rPr);
            log.debug("added " + runProp.getClass().getName());
        }
        RPr styleRPr = null;
        PropertyResolver propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
        if (pStyleId != null && (styleRPr = propertyResolver.getEffectiveRPr(pStyleId)) != null) {
            RPrCleanser.removeRedundantProperties(styleRPr, rPr);
        }
        propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
        if (rPr.getRStyle() != null) {
            String styleId = rPr.getRStyle().getVal();
            styleRPr = propertyResolver.getEffectiveRPr(styleId);
            RPrCleanser.removeRedundantProperties(styleRPr, rPr);
        }
    }

    public void setBookmarkNamePrefix(String bookmarkNamePrefix) {
        this.bookmarkNamePrefix = bookmarkNamePrefix;
    }

    private P.Hyperlink createHyperlink(String url, RPr rPr, String linkText, RelationshipsPart rp) {
        if (linkText.contains("&") && !linkText.contains("&amp;")) {
            linkText = linkText.replace("&", "&amp;");
        }
        if (linkText.contains("<")) {
            linkText = linkText.replace("<", "&lt;");
        }
        if (linkText.contains(">")) {
            linkText = linkText.replace(">", "&gt;");
        }
        try {
            String hpl = null;
            if (url.startsWith("#")) {
                hpl = "<w:hyperlink w:anchor=\"" + this.bookmarkHelper.anchorToBookmarkName(this.bookmarkNamePrefix, url) + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" ><w:r><w:t>" + linkText + "</w:t></w:r></w:hyperlink>";
            } else {
                ObjectFactory factory = new ObjectFactory();
                Relationship rel = factory.createRelationship();
                rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
                rel.setTarget(url);
                if (log.isDebugEnabled()) {
                    log.debug("target " + url);
                }
                rel.setTargetMode("External");
                rp.addRelationship(rel);
                hpl = "<w:hyperlink r:id=\"" + rel.getId() + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" ><w:r><w:t>" + linkText + "</w:t></w:r></w:hyperlink>";
            }
            P.Hyperlink hyperlink = (P.Hyperlink)XmlUtils.unmarshalString((String)hpl);
            R r = (R)hyperlink.getContent().get(0);
            r.setRPr(rPr);
            P currentP = this.getCurrentParagraph(false);
            if (rPr.getRStyle() == null && this.hyperlinkStyleId != null) {
                RStyle rStyle = Context.getWmlObjectFactory().createRStyle();
                rStyle.setVal(this.hyperlinkStyleId);
                rPr.setRStyle(rStyle);
            }
            return hyperlink;
        }
        catch (Exception e) {
            log.error("Dodgy link text: '" + linkText + "'", (Throwable)e);
            return null;
        }
    }

    private P getPforHR() {
        if (HR_P == null) {
            try {
                HR_P = (P)XmlUtils.unmarshalString((String)HR_XML);
            }
            catch (JAXBException jAXBException) {
                // empty catch block
            }
        }
        return HR_P;
    }

    public static final class TableProperties {
        private TableBox tableBox;
        private int[] colPos;
        boolean isFixedWidth;

        public TableBox getTableBox() {
            return this.tableBox;
        }

        public void setTableBox(TableBox tableBox) {
            this.tableBox = tableBox;
            this.colPos = tableBox.getColumnPos();
        }

        public int[] getColumnPos() {
            return this.colPos;
        }

        public int getColumnWidth(int col) {
            return this.colPos[col] - this.colPos[col - 1];
        }

        public boolean isFixedWidth() {
            return this.isFixedWidth;
        }

        public void setFixedWidth(boolean isFixedWidth) {
            this.isFixedWidth = isFixedWidth;
        }
    }
}

