/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.multilayer.gradientaccum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.nn.api.Updater;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.spark.impl.common.misc.ScoreReport;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;

public class GradientAccumFlatMap
implements FlatMapFunction<Iterator<org.nd4j.linalg.dataset.DataSet>, Tuple3<Gradient, Updater, ScoreReport>> {
    private String json;
    private Broadcast<INDArray> params;
    private Broadcast<Updater> updater;
    private static Logger log = LoggerFactory.getLogger(GradientAccumFlatMap.class);

    public GradientAccumFlatMap(String json, Broadcast<INDArray> params, Broadcast<Updater> updater) {
        this.json = json;
        this.params = params;
        this.updater = updater;
    }

    public Iterable<Tuple3<Gradient, Updater, ScoreReport>> call(Iterator<org.nd4j.linalg.dataset.DataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<org.nd4j.linalg.dataset.DataSet> collect = new ArrayList<org.nd4j.linalg.dataset.DataSet>();
        while (dataSetIterator.hasNext()) {
            collect.add(dataSetIterator.next());
        }
        org.nd4j.linalg.dataset.DataSet data = org.nd4j.linalg.dataset.DataSet.merge(collect, (boolean)false);
        if (log.isDebugEnabled()) {
            log.debug("Training on {} examples with data {}", (Object)data.numExamples(), (Object)data.labelCounts());
        }
        MultiLayerNetwork network = new MultiLayerNetwork(MultiLayerConfiguration.fromJson((String)this.json));
        network.init();
        INDArray val = ((INDArray)this.params.value()).dup();
        if (val.length() != network.numParams()) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcasted set parameters");
        }
        network.setParameters(val);
        network.setUpdater(((Updater)this.updater.getValue()).clone());
        network.fit((DataSet)data);
        ScoreReport report = new ScoreReport();
        report.setS(network.score());
        report.setM(Runtime.getRuntime().maxMemory());
        return Collections.singletonList(new Tuple3((Object)network.gradient(), (Object)network.getUpdater(), (Object)report));
    }
}

