/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.multilayer.evaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateFlatMapFunction
implements FlatMapFunction<Iterator<DataSet>, Evaluation> {
    protected static Logger log = LoggerFactory.getLogger(EvaluateFlatMapFunction.class);
    protected Broadcast<String> json;
    protected Broadcast<INDArray> params;
    protected Broadcast<List<String>> labels;
    protected int evalBatchSize;

    public EvaluateFlatMapFunction(Broadcast<String> json, Broadcast<INDArray> params, int evalBatchSize, Broadcast<List<String>> labels) {
        this.json = json;
        this.params = params;
        this.evalBatchSize = evalBatchSize;
        this.labels = labels;
    }

    public Iterable<Evaluation> call(Iterator<DataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.emptyList();
        }
        MultiLayerNetwork network = new MultiLayerNetwork(MultiLayerConfiguration.fromJson((String)((String)this.json.getValue())));
        network.init();
        INDArray val = (INDArray)this.params.value();
        if (val.length() != network.numParams(false)) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcasted set parameters");
        }
        network.setParameters(val);
        Evaluation evaluation = this.labels != null ? new Evaluation((List)this.labels.getValue()) : new Evaluation();
        ArrayList<DataSet> collect = new ArrayList<DataSet>();
        int totalCount = 0;
        while (dataSetIterator.hasNext()) {
            int nExamples;
            DataSet next;
            collect.clear();
            for (nExamples = 0; dataSetIterator.hasNext() && nExamples < this.evalBatchSize; nExamples += next.numExamples()) {
                next = dataSetIterator.next();
                collect.add(next);
            }
            totalCount += nExamples;
            DataSet data = DataSet.merge(collect, (boolean)false);
            INDArray out = data.hasMaskArrays() ? network.output(data.getFeatureMatrix(), false, data.getFeaturesMaskArray(), data.getLabelsMaskArray()) : network.output(data.getFeatureMatrix(), false);
            if (data.getLabels().rank() == 3) {
                if (data.getLabelsMaskArray() == null) {
                    evaluation.evalTimeSeries(data.getLabels(), out);
                    continue;
                }
                evaluation.evalTimeSeries(data.getLabels(), out, data.getLabelsMaskArray());
                continue;
            }
            evaluation.eval(data.getLabels(), out);
        }
        if (log.isDebugEnabled()) {
            log.debug("Evaluated {} examples ", (Object)totalCount);
        }
        return Collections.singletonList(evaluation);
    }
}

