/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.multilayer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.spark.impl.multilayer.IterativeReduceFlatMap;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreFlatMapFunction
implements FlatMapFunction<Iterator<DataSet>, Double> {
    private String json;
    private Broadcast<INDArray> params;
    private static Logger log = LoggerFactory.getLogger(IterativeReduceFlatMap.class);

    public ScoreFlatMapFunction(String json, Broadcast<INDArray> params) {
        this.json = json;
        this.params = params;
    }

    public Iterable<Double> call(Iterator<DataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.singletonList(0.0);
        }
        ArrayList<DataSet> collect = new ArrayList<DataSet>();
        while (dataSetIterator.hasNext()) {
            collect.add(dataSetIterator.next());
        }
        DataSet data = DataSet.merge(collect, (boolean)false);
        if (log.isDebugEnabled()) {
            log.debug("Scoring {} examples with data {}", (Object)data.numExamples(), (Object)data.labelCounts());
        }
        MultiLayerNetwork network = new MultiLayerNetwork(MultiLayerConfiguration.fromJson((String)this.json));
        network.init();
        INDArray val = (INDArray)this.params.value();
        if (val.length() != network.numParams(false)) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcasted set parameters");
        }
        network.setParameters(val);
        double score = network.score(data, false);
        if (network.conf().isMiniBatch()) {
            score *= (double)data.getFeatureMatrix().size(0);
        }
        return Collections.singletonList(score);
    }
}

