/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.multilayer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.Accumulator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.nn.api.Updater;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.listeners.ScoreIterationListener;
import org.deeplearning4j.spark.impl.common.BestScoreIterationListener;
import org.deeplearning4j.spark.impl.common.misc.ScoreReport;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;

public class IterativeReduceFlatMap
implements FlatMapFunction<Iterator<DataSet>, Tuple3<INDArray, Updater, ScoreReport>> {
    protected static Logger log = LoggerFactory.getLogger(IterativeReduceFlatMap.class);
    protected String json;
    protected Broadcast<INDArray> params;
    protected Broadcast<Updater> updater;
    protected final Accumulator<Double> best_score_acc;

    public IterativeReduceFlatMap(String json, Broadcast<INDArray> params, Broadcast<Updater> updater, Accumulator<Double> bestScoreAcc) {
        this.json = json;
        this.params = params;
        this.updater = updater;
        if (updater.getValue() == null) {
            throw new IllegalArgumentException("Updater shouldn't be null");
        }
        this.best_score_acc = bestScoreAcc;
    }

    public Iterable<Tuple3<INDArray, Updater, ScoreReport>> call(Iterator<DataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<DataSet> collect = new ArrayList<DataSet>();
        while (dataSetIterator.hasNext()) {
            collect.add(dataSetIterator.next());
        }
        DataSet data = DataSet.merge(collect, (boolean)false);
        if (log.isDebugEnabled()) {
            log.debug("Training on {} examples with data {}", (Object)data.numExamples(), (Object)data.labelCounts());
        }
        INDArray val = ((INDArray)this.params.getValue()).dup();
        Updater upd = ((Updater)this.updater.getValue()).clone();
        MultiLayerNetwork network = new MultiLayerNetwork(MultiLayerConfiguration.fromJson((String)this.json));
        network.setInitDone(true);
        network.init();
        network.setListeners(new IterationListener[]{new ScoreIterationListener(1), new BestScoreIterationListener(this.best_score_acc)});
        if (val.length() != network.numParams(false)) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcasted set parameters");
        }
        network.setParameters(val);
        network.setUpdater(upd);
        network.fit((org.nd4j.linalg.dataset.api.DataSet)data);
        ScoreReport report = new ScoreReport();
        report.setS(network.score());
        report.setM(Runtime.getRuntime().maxMemory());
        return Collections.singletonList(new Tuple3((Object)network.params(false), (Object)network.getUpdater(), (Object)report));
    }
}

