/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.computationgraph.gradientaccum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.updater.graph.ComputationGraphUpdater;
import org.deeplearning4j.spark.impl.common.misc.ScoreReport;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;

public class GradientAccumFlatMapCG
implements FlatMapFunction<Iterator<org.nd4j.linalg.dataset.api.MultiDataSet>, Tuple3<Gradient, ComputationGraphUpdater, ScoreReport>> {
    private String json;
    private Broadcast<INDArray> params;
    private Broadcast<ComputationGraphUpdater> updater;
    private static Logger log = LoggerFactory.getLogger(GradientAccumFlatMapCG.class);

    public GradientAccumFlatMapCG(String json, Broadcast<INDArray> params, Broadcast<ComputationGraphUpdater> updater) {
        this.json = json;
        this.params = params;
        this.updater = updater;
    }

    public Iterable<Tuple3<Gradient, ComputationGraphUpdater, ScoreReport>> call(Iterator<org.nd4j.linalg.dataset.api.MultiDataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            ScoreReport report = new ScoreReport();
            report.setS(0.0);
            report.setM(Runtime.getRuntime().maxMemory());
            return Collections.singletonList(new Tuple3((Object)new DefaultGradient(), null, (Object)report));
        }
        ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet> collect = new ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet>();
        while (dataSetIterator.hasNext()) {
            collect.add(dataSetIterator.next());
        }
        MultiDataSet data = MultiDataSet.merge(collect);
        ComputationGraph network = new ComputationGraph(ComputationGraphConfiguration.fromJson((String)this.json));
        network.init();
        INDArray val = ((INDArray)this.params.value()).dup();
        ComputationGraphUpdater upd = ((ComputationGraphUpdater)this.updater.getValue()).clone();
        if (val.length() != network.numParams()) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcasted set parameters");
        }
        network.setParams(val);
        network.setUpdater(upd);
        network.fit((org.nd4j.linalg.dataset.api.MultiDataSet)data);
        ScoreReport report = new ScoreReport();
        report.setS(network.score());
        report.setM(Runtime.getRuntime().maxMemory());
        return Collections.singletonList(new Tuple3((Object)network.gradient(), (Object)network.getUpdater(), (Object)report));
    }
}

