/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.computationgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.spark.impl.computationgraph.IterativeReduceFlatMapCG;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreFlatMapFunctionCGMultiDataSet
implements FlatMapFunction<Iterator<org.nd4j.linalg.dataset.api.MultiDataSet>, Double> {
    private String json;
    private Broadcast<INDArray> params;
    private static Logger log = LoggerFactory.getLogger(IterativeReduceFlatMapCG.class);

    public ScoreFlatMapFunctionCGMultiDataSet(String json, Broadcast<INDArray> params) {
        this.json = json;
        this.params = params;
    }

    public Iterable<Double> call(Iterator<org.nd4j.linalg.dataset.api.MultiDataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.singletonList(0.0);
        }
        ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet> collect = new ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet>();
        while (dataSetIterator.hasNext()) {
            collect.add(dataSetIterator.next());
        }
        MultiDataSet data = MultiDataSet.merge(collect);
        ComputationGraph network = new ComputationGraph(ComputationGraphConfiguration.fromJson((String)this.json));
        network.init();
        INDArray val = (INDArray)this.params.value();
        if (val.length() != network.numParams(false)) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcast set parameters");
        }
        network.setParams(val);
        double score = network.score((org.nd4j.linalg.dataset.api.MultiDataSet)data, false);
        if (network.conf().isMiniBatch()) {
            score *= (double)data.getFeatures(0).size(0);
        }
        return Collections.singletonList(score);
    }
}

