/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.computationgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.updater.graph.ComputationGraphUpdater;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.listeners.ScoreIterationListener;
import org.deeplearning4j.spark.impl.common.misc.ScoreReport;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;

public class IterativeReduceFlatMapCG
implements FlatMapFunction<Iterator<org.nd4j.linalg.dataset.api.MultiDataSet>, Tuple3<INDArray, ComputationGraphUpdater, ScoreReport>> {
    protected static Logger log = LoggerFactory.getLogger(IterativeReduceFlatMapCG.class);
    private String json;
    private Broadcast<INDArray> params;
    private Broadcast<ComputationGraphUpdater> updater;

    public IterativeReduceFlatMapCG(String json, Broadcast<INDArray> params, Broadcast<ComputationGraphUpdater> updater) {
        this.json = json;
        this.params = params;
        this.updater = updater;
        if (updater.getValue() == null) {
            throw new IllegalArgumentException("Updater shouldn't be null");
        }
    }

    public Iterable<Tuple3<INDArray, ComputationGraphUpdater, ScoreReport>> call(Iterator<org.nd4j.linalg.dataset.api.MultiDataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet> collect = new ArrayList<org.nd4j.linalg.dataset.api.MultiDataSet>();
        while (dataSetIterator.hasNext()) {
            collect.add(dataSetIterator.next());
        }
        MultiDataSet data = MultiDataSet.merge(collect);
        ComputationGraph network = new ComputationGraph(ComputationGraphConfiguration.fromJson((String)this.json));
        network.setInitDone(true);
        network.init();
        network.setListeners(new IterationListener[]{new ScoreIterationListener(1)});
        INDArray val = ((INDArray)this.params.getValue()).dup();
        ComputationGraphUpdater upd = ((ComputationGraphUpdater)this.updater.getValue()).clone();
        if (val.length() != network.numParams(false)) {
            throw new IllegalStateException("Network did not have same number of parameters as the broadcast parameters");
        }
        network.setParams(val);
        network.setUpdater(upd);
        network.fit((org.nd4j.linalg.dataset.api.MultiDataSet)data);
        ScoreReport report = new ScoreReport();
        report.setS(network.score());
        report.setM(Runtime.getRuntime().maxMemory());
        return Collections.singletonList(new Tuple3((Object)network.params(false), (Object)network.getUpdater(), (Object)report));
    }
}

