/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.common;

import org.apache.spark.Accumulator;
import org.apache.spark.api.java.function.VoidFunction;
import org.deeplearning4j.spark.impl.common.SumAccum;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Adder
implements VoidFunction<INDArray> {
    private SumAccum accumulator;
    private Accumulator<Integer> counter;
    private static Logger log = LoggerFactory.getLogger(Adder.class);

    public Adder(int length, Accumulator<Integer> counter) {
        this.accumulator = new SumAccum(length);
        this.counter = counter;
    }

    public void call(INDArray indArrayIterator) throws Exception {
        if (indArrayIterator != null) {
            this.accumulator.add(indArrayIterator);
            this.counter.add((Object)1);
        }
        log.info("Invoked add operation ");
    }

    public SumAccum getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(SumAccum accumulator) {
        this.accumulator = accumulator;
    }

    public Accumulator<Integer> getCounter() {
        return this.counter;
    }

    public void setCounter(Accumulator<Integer> counter) {
        this.counter = counter;
    }
}

