/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.earlystopping;

import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.earlystopping.listener.EarlyStoppingListener;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.spark.earlystopping.BaseSparkEarlyStoppingTrainer;
import org.deeplearning4j.spark.impl.multilayer.SparkDl4jMultiLayer;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.MultiDataSet;

public class SparkEarlyStoppingTrainer
extends BaseSparkEarlyStoppingTrainer<MultiLayerNetwork> {
    private SparkDl4jMultiLayer sparkNet;

    public SparkEarlyStoppingTrainer(SparkContext sc, EarlyStoppingConfiguration<MultiLayerNetwork> esConfig, MultiLayerNetwork net, JavaRDD<DataSet> train, int examplesPerFit, int totalExamples, int numPartitions) {
        this(sc, esConfig, net, train, examplesPerFit, totalExamples, numPartitions, null);
    }

    public SparkEarlyStoppingTrainer(SparkContext sc, EarlyStoppingConfiguration<MultiLayerNetwork> esConfig, MultiLayerNetwork net, JavaRDD<DataSet> train, int examplesPerFit, int totalExamples, int numPartitions, EarlyStoppingListener<MultiLayerNetwork> listener) {
        super(sc, esConfig, net, train, null, examplesPerFit, totalExamples, numPartitions, listener);
        this.sparkNet = new SparkDl4jMultiLayer(sc, net);
    }

    @Override
    protected void fit(JavaRDD<DataSet> data) {
        this.sparkNet.fitDataSet(data, Integer.MAX_VALUE, 0, this.numPartitions);
    }

    @Override
    protected void fitMulti(JavaRDD<MultiDataSet> data) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    protected double getScore() {
        return this.sparkNet.getScore();
    }
}

