/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.earlystopping;

import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.earlystopping.listener.EarlyStoppingListener;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.spark.earlystopping.BaseSparkEarlyStoppingTrainer;
import org.deeplearning4j.spark.impl.computationgraph.SparkComputationGraph;
import org.deeplearning4j.spark.impl.computationgraph.dataset.DataSetToMultiDataSetFn;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.MultiDataSet;

public class SparkEarlyStoppingGraphTrainer
extends BaseSparkEarlyStoppingTrainer<ComputationGraph> {
    private SparkComputationGraph sparkNet;

    public SparkEarlyStoppingGraphTrainer(SparkContext sc, EarlyStoppingConfiguration<ComputationGraph> esConfig, ComputationGraph net, JavaRDD<MultiDataSet> train, int examplesPerFit, int totalExamples, int numPartitions) {
        this(sc, esConfig, net, train, examplesPerFit, totalExamples, numPartitions, null);
    }

    public SparkEarlyStoppingGraphTrainer(SparkContext sc, EarlyStoppingConfiguration<ComputationGraph> esConfig, ComputationGraph net, JavaRDD<MultiDataSet> train, int examplesPerFit, int totalExamples, int numPartitions, EarlyStoppingListener<ComputationGraph> listener) {
        super(sc, esConfig, net, null, train, examplesPerFit, totalExamples, numPartitions, listener);
        this.sparkNet = new SparkComputationGraph(sc, net);
    }

    @Override
    protected void fit(JavaRDD<DataSet> data) {
        this.fitMulti((JavaRDD<MultiDataSet>)data.map((Function)new DataSetToMultiDataSetFn()));
    }

    @Override
    protected void fitMulti(JavaRDD<MultiDataSet> data) {
        this.sparkNet.fitMultiDataSet(data, Integer.MAX_VALUE, 0, this.numPartitions);
    }

    @Override
    protected double getScore() {
        return this.sparkNet.getScore();
    }
}

