/*
 * Decompiled with CFR 0.152.
 */
package org.arbiter.optimize.executor.spark;

import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.spark.api.java.JavaFutureAction;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.arbiter.optimize.api.Candidate;
import org.arbiter.optimize.api.OptimizationResult;
import org.arbiter.optimize.api.TaskCreator;
import org.arbiter.optimize.api.data.DataProvider;
import org.arbiter.optimize.api.score.ScoreFunction;
import org.arbiter.optimize.executor.CandidateExecutor;
import org.arbiter.optimize.executor.spark.CandidateDataScoreTuple;

public class SparkCandidateExecutor<C, M, D, A>
implements CandidateExecutor<C, M, D, A> {
    private JavaSparkContext sparkContext;
    private TaskCreator<C, M, D, A> taskCreator;

    public ListenableFuture<OptimizationResult<C, M, A>> execute(Candidate<C> candidate, DataProvider<D> dataProvider, ScoreFunction<M, D> scoreFunction) {
        return this.execute(Collections.singletonList(candidate), dataProvider, scoreFunction).get(0);
    }

    public List<ListenableFuture<OptimizationResult<C, M, A>>> execute(List<Candidate<C>> candidates, DataProvider<D> dataProvider, ScoreFunction<M, D> scoreFunction) {
        ArrayList<ListenableFuture<OptimizationResult<C, M, A>>> list = new ArrayList<ListenableFuture<OptimizationResult<C, M, A>>>(candidates.size());
        for (Candidate<C> candidate : candidates) {
            CandidateDataScoreTuple<C, D, M> tuple = new CandidateDataScoreTuple<C, D, M>();
            tuple.setCandidate(candidate);
            tuple.setDataProvider(dataProvider);
            tuple.setScoreFunction(scoreFunction);
            ArrayList<CandidateDataScoreTuple<C, D, M>> singleList = new ArrayList<CandidateDataScoreTuple<C, D, M>>();
            singleList.add(tuple);
            JavaRDD rdd = this.sparkContext.parallelize(singleList);
            JavaRDD results = rdd.map(new Function<CandidateDataScoreTuple<C, D, M>, OptimizationResult<C, M, A>>(){

                public OptimizationResult<C, M, A> call(CandidateDataScoreTuple<C, D, M> cdmCandidateDataScoreTuple) throws Exception {
                    return null;
                }
            });
            JavaFutureAction out = results.collectAsync();
            FutureListAdapter f = new FutureListAdapter(out);
            list.add(JdkFutureAdapters.listenInPoolThread(f));
        }
        return list;
    }

    public int maxConcurrentTasks() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void shutdown() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @ConstructorProperties(value={"sparkContext", "taskCreator"})
    public SparkCandidateExecutor(JavaSparkContext sparkContext, TaskCreator<C, M, D, A> taskCreator) {
        this.sparkContext = sparkContext;
        this.taskCreator = taskCreator;
    }

    private class FutureListAdapter<C, M, A>
    implements Future<OptimizationResult<C, M, A>> {
        private JavaFutureAction<List<OptimizationResult<C, M, A>>> futureAction;

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.futureAction.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.futureAction.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.futureAction.isDone();
        }

        @Override
        public OptimizationResult<C, M, A> get() throws InterruptedException, ExecutionException {
            return (OptimizationResult)((List)this.futureAction.get()).get(0);
        }

        @Override
        public OptimizationResult<C, M, A> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (OptimizationResult)((List)this.futureAction.get(timeout, unit)).get(0);
        }

        @ConstructorProperties(value={"futureAction"})
        public FutureListAdapter(JavaFutureAction<List<OptimizationResult<C, M, A>>> futureAction) {
            this.futureAction = futureAction;
        }
    }

    private class Job {
        private Candidate<C> candidate;
        private DataProvider<D> dataProvider;

        @ConstructorProperties(value={"candidate", "dataProvider"})
        public Job(Candidate<C> candidate, DataProvider<D> dataProvider) {
            this.candidate = candidate;
            this.dataProvider = dataProvider;
        }
    }
}

