/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.linker.Ranlib;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.manager.RanlibManager;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;

@Mojo(name="ranlib", defaultPhase=LifecyclePhase.PACKAGE)
public class NativeRanlibMojo
extends AbstractNativeMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File ranlibOutputDirectory;
    @Parameter(defaultValue="default", required=true)
    private String provider;
    @Component
    private RanlibManager manager;

    public void execute() throws MojoExecutionException {
        try {
            String finalName = this.project.getBuild().getFinalName();
            String fileExt = this.project.getArtifact().getArtifactHandler().getExtension();
            File outputFile = new File(this.ranlibOutputDirectory.getAbsolutePath() + "/" + finalName + "." + fileExt);
            Ranlib ranlib = this.getRanlib();
            ranlib.run(outputFile);
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException("Error executing ranlib.", (Exception)((Object)e));
        }
    }

    private Ranlib getRanlib() throws MojoExecutionException {
        Ranlib ranlib;
        try {
            ranlib = this.manager.getRanlib(this.provider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return ranlib;
    }
}

