/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Serializable;
import java.io.Writer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class StringBuilderWriter
extends Writer
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -146927496096066153L;
    private final @UnknownKeyFor @NonNull @Initialized StringBuilder builder;

    public StringBuilderWriter() {
        this.builder = new StringBuilder();
    }

    public StringBuilderWriter(@UnknownKeyFor @NonNull @Initialized int capacity) {
        this.builder = new StringBuilder(capacity);
    }

    public StringBuilderWriter(@Nullable @UnknownKeyFor @Initialized StringBuilder builder) {
        this.builder = builder != null ? builder : new StringBuilder();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@UnknownKeyFor @NonNull @Initialized char value) {
        this.builder.append(value);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@Nullable @UnknownKeyFor @Initialized CharSequence value) {
        this.builder.append(value);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@Nullable @UnknownKeyFor @Initialized CharSequence value, @UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end) {
        this.builder.append(value, start, end);
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String value) {
        if (value != null) {
            this.builder.append(value);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] value, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) {
        if (value != null) {
            this.builder.append(value, offset, length);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized StringBuilder getBuilder() {
        return this.builder;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.builder.toString();
    }
}

