/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FileWriterWithEncoding
extends Writer {
    private final @UnknownKeyFor @NonNull @Initialized Writer out;

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String fileName, @NonNull @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(fileName), charsetName, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String fileName, @NonNull @UnknownKeyFor @Initialized String charsetName, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(fileName), charsetName, append);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String fileName, @NonNull @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(fileName), charset, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String fileName, @NonNull @UnknownKeyFor @Initialized Charset charset, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(fileName), charset, append);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized CharsetEncoder encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(fileName), encoding, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized CharsetEncoder charsetEncoder, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(fileName), charsetEncoder, append);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @NonNull @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, charsetName, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @NonNull @UnknownKeyFor @Initialized String charsetName, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out = FileWriterWithEncoding.initWriter(file, charsetName, append);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @NonNull @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, charset, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @NonNull @UnknownKeyFor @Initialized Charset encoding, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out = FileWriterWithEncoding.initWriter(file, encoding, append);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized CharsetEncoder charsetEncoder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, charsetEncoder, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized CharsetEncoder charsetEncoder, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out = FileWriterWithEncoding.initWriter(file, charsetEncoder, append);
    }

    private static @UnknownKeyFor @NonNull @Initialized Writer initWriter(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized Object encoding, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(encoding, "encoding");
        FileOutputStream stream = null;
        boolean fileExistedAlready = file.exists();
        try {
            stream = new FileOutputStream(file, append);
            if (encoding instanceof Charset) {
                return new OutputStreamWriter((OutputStream)stream, (Charset)encoding);
            }
            if (encoding instanceof CharsetEncoder) {
                return new OutputStreamWriter((OutputStream)stream, (CharsetEncoder)encoding);
            }
            return new OutputStreamWriter((OutputStream)stream, (String)encoding);
        }
        catch (IOException | RuntimeException ex) {
            try {
                IOUtils.close(stream);
            }
            catch (IOException e) {
                ex.addSuppressed(e);
            }
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file);
            }
            throw ex;
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int idx) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(idx);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chr) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(chr);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chr, @UnknownKeyFor @NonNull @Initialized int st, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(chr, st, end);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(str);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized int st, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(str, st, end);
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.flush();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.close();
    }
}

