/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.input.buffer.CircularByteBuffer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CircularBufferInputStream
extends InputStream {
    protected final @UnknownKeyFor @NonNull @Initialized InputStream in;
    protected final @UnknownKeyFor @NonNull @Initialized CircularByteBuffer buffer;
    protected final @UnknownKeyFor @NonNull @Initialized int bufferSize;
    private @UnknownKeyFor @NonNull @Initialized boolean eofSeen;

    public CircularBufferInputStream(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Invalid bufferSize: " + bufferSize);
        }
        this.in = Objects.requireNonNull(inputStream, "inputStream");
        this.buffer = new CircularByteBuffer(bufferSize);
        this.bufferSize = bufferSize;
        this.eofSeen = false;
    }

    public CircularBufferInputStream(@UnknownKeyFor @NonNull @Initialized InputStream inputStream) {
        this(inputStream, 8192);
    }

    protected void fillBuffer() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.eofSeen) {
            return;
        }
        int space = this.buffer.getSpace();
        byte[] buf = new byte[space];
        while (space > 0) {
            int res = this.in.read(buf, 0, space);
            if (res == -1) {
                this.eofSeen = true;
                return;
            }
            if (res <= 0) continue;
            this.buffer.add(buf, 0, res);
            space -= res;
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean haveBytes(@UnknownKeyFor @NonNull @Initialized int count) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.buffer.getCurrentNumberOfBytes() < count) {
            this.fillBuffer();
        }
        return this.buffer.hasBytes();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.haveBytes(1)) {
            return -1;
        }
        return this.buffer.read();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] targetBuffer, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(targetBuffer, "Buffer");
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must not be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        if (!this.haveBytes(length)) {
            return -1;
        }
        int result = Math.min(length, this.buffer.getCurrentNumberOfBytes());
        for (int i = 0; i < result; ++i) {
            targetBuffer[offset + i] = this.buffer.read();
        }
        return result;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.in.close();
        this.eofSeen = true;
        this.buffer.clear();
    }
}

