/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class NullReader
extends Reader {
    private final @UnknownKeyFor @NonNull @Initialized long size;
    private @UnknownKeyFor @NonNull @Initialized long position;
    private @UnknownKeyFor @NonNull @Initialized long mark = -1L;
    private @UnknownKeyFor @NonNull @Initialized long readlimit;
    private @UnknownKeyFor @NonNull @Initialized boolean eof;
    private final @UnknownKeyFor @NonNull @Initialized boolean throwEofException;
    private final @UnknownKeyFor @NonNull @Initialized boolean markSupported;

    public NullReader() {
        this(0L, true, false);
    }

    public NullReader(@UnknownKeyFor @NonNull @Initialized long size) {
        this(size, true, false);
    }

    public NullReader(@UnknownKeyFor @NonNull @Initialized long size, @UnknownKeyFor @NonNull @Initialized boolean markSupported, @UnknownKeyFor @NonNull @Initialized boolean throwEofException) {
        this.size = size;
        this.markSupported = markSupported;
        this.throwEofException = throwEofException;
    }

    public @UnknownKeyFor @NonNull @Initialized long getPosition() {
        return this.position;
    }

    public @UnknownKeyFor @NonNull @Initialized long getSize() {
        return this.size;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.eof = false;
        this.position = 0L;
        this.mark = -1L;
    }

    @Override
    public synchronized void mark(@UnknownKeyFor @NonNull @Initialized int readlimit) {
        if (!this.markSupported) {
            throw new UnsupportedOperationException("Mark not supported");
        }
        this.mark = this.position;
        this.readlimit = readlimit;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean markSupported() {
        return this.markSupported;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.eof) {
            throw new IOException("Read after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        ++this.position;
        return this.processChar();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chars) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.read(chars, 0, chars.length);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chars, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.eof) {
            throw new IOException("Read after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        this.position += (long)length;
        int returnLength = length;
        if (this.position > this.size) {
            returnLength = length - (int)(this.position - this.size);
            this.position = this.size;
        }
        this.processChars(chars, offset, returnLength);
        return returnLength;
    }

    @Override
    public synchronized void reset() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.markSupported) {
            throw new UnsupportedOperationException("Mark not supported");
        }
        if (this.mark < 0L) {
            throw new IOException("No position has been marked");
        }
        if (this.position > this.mark + this.readlimit) {
            throw new IOException("Marked position [" + this.mark + "] is no longer valid - passed the read limit [" + this.readlimit + "]");
        }
        this.position = this.mark;
        this.eof = false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized long numberOfChars) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.eof) {
            throw new IOException("Skip after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        this.position += numberOfChars;
        long returnLength = numberOfChars;
        if (this.position > this.size) {
            returnLength = numberOfChars - (this.position - this.size);
            this.position = this.size;
        }
        return returnLength;
    }

    protected @UnknownKeyFor @NonNull @Initialized int processChar() {
        return 0;
    }

    protected void processChars(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chars, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) {
    }

    private @UnknownKeyFor @NonNull @Initialized int doEndOfFile() throws @UnknownKeyFor @NonNull @Initialized EOFException {
        this.eof = true;
        if (this.throwEofException) {
            throw new EOFException();
        }
        return -1;
    }
}

