/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AutoCloseInputStream
extends ProxyInputStream {
    public AutoCloseInputStream(@UnknownKeyFor @NonNull @Initialized InputStream in) {
        super(in);
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.in.close();
        this.in = ClosedInputStream.CLOSED_INPUT_STREAM;
    }

    @Override
    protected void afterRead(@UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (n == -1) {
            this.close();
        }
    }

    protected void finalize() throws @UnknownKeyFor @NonNull @Initialized Throwable {
        this.close();
        super.finalize();
    }
}

