/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CopyDirectoryVisitor
extends CountingPathVisitor {
    private static final @UnknownKeyFor @NonNull @Initialized CopyOption @UnknownKeyFor @NonNull @Initialized [] EMPTY_COPY_OPTIONS = new CopyOption[0];
    private final @UnknownKeyFor @NonNull @Initialized CopyOption @UnknownKeyFor @NonNull @Initialized [] copyOptions;
    private final @UnknownKeyFor @NonNull @Initialized Path sourceDirectory;
    private final @UnknownKeyFor @NonNull @Initialized Path targetDirectory;

    public CopyDirectoryVisitor(@UnknownKeyFor @NonNull @Initialized Counters.PathCounters pathCounter, @UnknownKeyFor @NonNull @Initialized Path sourceDirectory, @UnknownKeyFor @NonNull @Initialized Path targetDirectory, CopyOption ... copyOptions) {
        super(pathCounter);
        this.sourceDirectory = sourceDirectory;
        this.targetDirectory = targetDirectory;
        this.copyOptions = copyOptions == null ? EMPTY_COPY_OPTIONS : (CopyOption[])copyOptions.clone();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileVisitResult preVisitDirectory(@UnknownKeyFor @NonNull @Initialized Path directory, @UnknownKeyFor @NonNull @Initialized BasicFileAttributes attributes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Path newTargetDir = this.targetDirectory.resolve(this.sourceDirectory.relativize(directory));
        if (Files.notExists(newTargetDir, new LinkOption[0])) {
            Files.createDirectory(newTargetDir, new FileAttribute[0]);
        }
        return super.preVisitDirectory(directory, attributes);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileVisitResult visitFile(@UnknownKeyFor @NonNull @Initialized Path sourceFile, @UnknownKeyFor @NonNull @Initialized BasicFileAttributes attributes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Path targetFile = this.targetDirectory.resolve(this.sourceDirectory.relativize(sourceFile));
        Files.copy(sourceFile, targetFile, this.copyOptions);
        return super.visitFile(targetFile, attributes);
    }
}

