/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.FileUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FileWriterWithEncoding
extends Writer {
    private final @UnknownKeyFor @NonNull @Initialized Writer out;

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String filename, @UnknownKeyFor @NonNull @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(filename), encoding, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String filename, @UnknownKeyFor @NonNull @Initialized String encoding, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(filename), encoding, append);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String filename, @UnknownKeyFor @NonNull @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(filename), encoding, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String filename, @UnknownKeyFor @NonNull @Initialized Charset encoding, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(filename), encoding, append);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String filename, @UnknownKeyFor @NonNull @Initialized CharsetEncoder encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(filename), encoding, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized String filename, @UnknownKeyFor @NonNull @Initialized CharsetEncoder encoding, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new File(filename), encoding, append);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, encoding, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized String encoding, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out = FileWriterWithEncoding.initWriter(file, encoding, append);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, encoding, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized Charset encoding, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out = FileWriterWithEncoding.initWriter(file, encoding, append);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized CharsetEncoder encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(file, encoding, false);
    }

    public FileWriterWithEncoding(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized CharsetEncoder encoding, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out = FileWriterWithEncoding.initWriter(file, encoding, append);
    }

    private static @UnknownKeyFor @NonNull @Initialized Writer initWriter(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized Object encoding, @UnknownKeyFor @NonNull @Initialized boolean append) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (file == null) {
            throw new NullPointerException("File is missing");
        }
        if (encoding == null) {
            throw new NullPointerException("Encoding is missing");
        }
        FileOutputStream stream = null;
        boolean fileExistedAlready = file.exists();
        try {
            stream = new FileOutputStream(file, append);
            if (encoding instanceof Charset) {
                return new OutputStreamWriter((OutputStream)stream, (Charset)encoding);
            }
            if (encoding instanceof CharsetEncoder) {
                return new OutputStreamWriter((OutputStream)stream, (CharsetEncoder)encoding);
            }
            return new OutputStreamWriter((OutputStream)stream, (String)encoding);
        }
        catch (IOException | RuntimeException ex) {
            try {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
            catch (IOException e) {
                ex.addSuppressed(e);
            }
            if (!fileExistedAlready) {
                FileUtils.deleteQuietly(file);
            }
            throw ex;
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int idx) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(idx);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chr) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(chr);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chr, @UnknownKeyFor @NonNull @Initialized int st, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(chr, st, end);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(str);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized int st, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.write(str, st, end);
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.flush();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.out.close();
    }
}

