/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SwappedDataInputStream
extends ProxyInputStream
implements DataInput {
    public SwappedDataInputStream(@UnknownKeyFor @NonNull @Initialized InputStream input) {
        super(input);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean readBoolean() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return 0 != this.readByte();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized byte readByte() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return (byte)this.in.read();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized char readChar() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return (char)this.readShort();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized double readDouble() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return EndianUtils.readSwappedDouble(this.in);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized float readFloat() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return EndianUtils.readSwappedFloat(this.in);
    }

    @Override
    public void readFully(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        this.readFully(data, 0, data.length);
    }

    @Override
    public void readFully(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        int count;
        for (int remaining = length; remaining > 0; remaining -= count) {
            int location = offset + length - remaining;
            count = this.read(data, location, remaining);
            if (-1 != count) continue;
            throw new EOFException();
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int readInt() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return EndianUtils.readSwappedInteger(this.in);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String readLine() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        throw new UnsupportedOperationException("Operation not supported: readLine()");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long readLong() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return EndianUtils.readSwappedLong(this.in);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized short readShort() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return EndianUtils.readSwappedShort(this.in);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int readUnsignedByte() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return this.in.read();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int readUnsignedShort() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return EndianUtils.readSwappedUnsignedShort(this.in);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String readUTF() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        throw new UnsupportedOperationException("Operation not supported: readUTF()");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int skipBytes(@UnknownKeyFor @NonNull @Initialized int count) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized EOFException {
        return (int)this.in.skip(count);
    }
}

