/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.StringBuilderWriter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IOUtils {
    public static final @UnknownKeyFor @NonNull @Initialized int EOF = -1;
    public static final @UnknownKeyFor @NonNull @Initialized char DIR_SEPARATOR_UNIX = '/';
    public static final @UnknownKeyFor @NonNull @Initialized char DIR_SEPARATOR_WINDOWS = '\\';
    public static final @UnknownKeyFor @NonNull @Initialized char DIR_SEPARATOR = File.separatorChar;
    public static final @UnknownKeyFor @NonNull @Initialized String LINE_SEPARATOR_UNIX = "\n";
    public static final @UnknownKeyFor @NonNull @Initialized String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final @UnknownKeyFor @NonNull @Initialized String LINE_SEPARATOR;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BUFFER_SIZE = 4096;
    private static final @UnknownKeyFor @NonNull @Initialized int SKIP_BUFFER_SIZE = 2048;
    private static @UnknownKeyFor @NonNull @Initialized char @Nullable @UnknownKeyFor @Initialized [] SKIP_CHAR_BUFFER;
    private static @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] SKIP_BYTE_BUFFER;

    public static void close(@UnknownKeyFor @NonNull @Initialized URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Reader input) {
        IOUtils.closeQuietly((Closeable)input);
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Writer output) {
        IOUtils.closeQuietly((Closeable)output);
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized InputStream input) {
        IOUtils.closeQuietly((Closeable)input);
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized OutputStream output) {
        IOUtils.closeQuietly((Closeable)output);
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            IOUtils.closeQuietly(closeable);
        }
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Socket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Selector selector) {
        if (selector != null) {
            try {
                selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized ServerSocket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toBufferedInputStream(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ByteArrayOutputStream.toBufferedInputStream(input);
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toBufferedInputStream(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized int size) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ByteArrayOutputStream.toBufferedInputStream(input, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedReader toBufferedReader(@UnknownKeyFor @NonNull @Initialized Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedReader toBufferedReader(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized int size) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedReader buffer(@UnknownKeyFor @NonNull @Initialized Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedReader buffer(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized int size) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedWriter buffer(@UnknownKeyFor @NonNull @Initialized Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedWriter buffer(@UnknownKeyFor @NonNull @Initialized Writer writer, @UnknownKeyFor @NonNull @Initialized int size) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedOutputStream buffer(@UnknownKeyFor @NonNull @Initialized OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedOutputStream buffer(@UnknownKeyFor @NonNull @Initialized OutputStream outputStream, @UnknownKeyFor @NonNull @Initialized int size) {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedInputStream buffer(@UnknownKeyFor @NonNull @Initialized InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedInputStream buffer(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @UnknownKeyFor @NonNull @Initialized int size) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            IOUtils.copy(input, (OutputStream)output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized long size) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + size);
        }
        return IOUtils.toByteArray(input, (int)size);
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized int size) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int offset;
        int read;
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] data = new byte[size];
        for (offset = 0; offset < size && (read = input.read(data, offset, size - offset)) != -1; offset += read) {
        }
        if (offset != size) {
            throw new IOException("Unexpected read size. current: " + offset + ", expected: " + size);
        }
        return data;
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized Reader input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toByteArray(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized Reader input, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            IOUtils.copy(input, (OutputStream)output, encoding);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized Reader input, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toByteArray(input, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized String input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return input.getBytes(Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized URI uri) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toByteArray(uri.toURL());
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized URL url) throws @UnknownKeyFor @NonNull @Initialized IOException {
        URLConnection conn = url.openConnection();
        try {
            byte[] byArray = IOUtils.toByteArray(conn);
            return byArray;
        }
        finally {
            IOUtils.close(conn);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized URLConnection urlConn) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (InputStream inputStream = urlConn.getInputStream();){
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return byArray;
        }
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] toCharArray(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toCharArray(is, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] toCharArray(@UnknownKeyFor @NonNull @Initialized InputStream is, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.copy(is, (Writer)output, encoding);
        return output.toCharArray();
    }

    public static @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] toCharArray(@UnknownKeyFor @NonNull @Initialized InputStream is, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toCharArray(is, Charsets.toCharset(encoding));
    }

    public static @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] toCharArray(@UnknownKeyFor @NonNull @Initialized Reader input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IOUtils.copy(input, (Writer)sw);
        return sw.toCharArray();
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (StringBuilderWriter sw = new StringBuilderWriter();){
            IOUtils.copy(input, (Writer)sw, encoding);
            String string = sw.toString();
            return string;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(input, Charsets.toCharset(encoding));
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized Reader input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (StringBuilderWriter sw = new StringBuilderWriter();){
            IOUtils.copy(input, (Writer)sw);
            String string = sw.toString();
            return string;
        }
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URI uri) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(uri, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URI uri, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(uri.toURL(), Charsets.toCharset(encoding));
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URI uri, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(uri, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URL url) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(url, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URL url, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (InputStream inputStream = url.openStream();){
            String string = IOUtils.toString(inputStream, encoding);
            return string;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URL url, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(url, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new String(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new String(input, Charsets.toCharset(encoding));
    }

    public static @UnknownKeyFor @NonNull @Initialized String resourceToString(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.resourceToString(name, encoding, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized String resourceToString(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Charset encoding, @Nullable @UnknownKeyFor @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(IOUtils.resourceToURL(name, classLoader), encoding);
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] resourceToByteArray(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.resourceToByteArray(name, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] resourceToByteArray(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toByteArray(IOUtils.resourceToURL(name, classLoader));
    }

    public static @UnknownKeyFor @NonNull @Initialized URL resourceToURL(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.resourceToURL(name, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized URL resourceToURL(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        URL resource;
        URL uRL = resource = classLoader == null ? IOUtils.class.getResource(name) : classLoader.getResource(name);
        if (resource == null) {
            throw new IOException("Resource not found: " + name);
        }
        return resource;
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readLines(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.readLines(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readLines(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        InputStreamReader reader = new InputStreamReader(input, Charsets.toCharset(encoding));
        return IOUtils.readLines(reader);
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readLines(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.readLines(input, Charsets.toCharset(encoding));
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readLines(@UnknownKeyFor @NonNull @Initialized Reader input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BufferedReader reader = IOUtils.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static @UnknownKeyFor @NonNull @Initialized LineIterator lineIterator(@UnknownKeyFor @NonNull @Initialized Reader reader) {
        return new LineIterator(reader);
    }

    public static @UnknownKeyFor @NonNull @Initialized LineIterator lineIterator(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new LineIterator(new InputStreamReader(input, Charsets.toCharset(encoding)));
    }

    public static @UnknownKeyFor @NonNull @Initialized LineIterator lineIterator(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.lineIterator(input, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized CharSequence input) {
        return IOUtils.toInputStream(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized CharSequence input, @Nullable @UnknownKeyFor @Initialized Charset encoding) {
        return IOUtils.toInputStream(input.toString(), encoding);
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized CharSequence input, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toInputStream(input, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized String input) {
        return IOUtils.toInputStream(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized String input, @Nullable @UnknownKeyFor @Initialized Charset encoding) {
        return new ByteArrayInputStream(input.getBytes(Charsets.toCharset(encoding)));
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized String input, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] bytes = input.getBytes(Charsets.toCharset(encoding));
        return new ByteArrayInputStream(bytes);
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void writeChunked(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            int bytes = data.length;
            int offset = 0;
            while (bytes > 0) {
                int chunk = Math.min(bytes, 4096);
                output.write(data, offset, chunk);
                bytes -= chunk;
                offset += chunk;
            }
        }
    }

    @Deprecated
    public static void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charset.defaultCharset());
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized Writer output, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(new String(data, Charsets.toCharset(encoding)));
        }
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized Writer output, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charsets.toCharset(encoding));
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void writeChunked(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            int bytes = data.length;
            int offset = 0;
            while (bytes > 0) {
                int chunk = Math.min(bytes, 4096);
                output.write(data, offset, chunk);
                bytes -= chunk;
                offset += chunk;
            }
        }
    }

    @Deprecated
    public static void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charset.defaultCharset());
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(new String(data).getBytes(Charsets.toCharset(encoding)));
        }
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charsets.toCharset(encoding));
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized CharSequence data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            IOUtils.write(data.toString(), output);
        }
    }

    @Deprecated
    public static void write(@Nullable @UnknownKeyFor @Initialized CharSequence data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charset.defaultCharset());
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized CharSequence data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            IOUtils.write(data.toString(), output, encoding);
        }
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized CharSequence data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charsets.toCharset(encoding));
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized String data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data);
        }
    }

    @Deprecated
    public static void write(@Nullable @UnknownKeyFor @Initialized String data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charset.defaultCharset());
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized String data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data.getBytes(Charsets.toCharset(encoding)));
        }
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized String data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static void write(@Nullable @UnknownKeyFor @Initialized StringBuffer data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data.toString());
        }
    }

    @Deprecated
    public static void write(@Nullable @UnknownKeyFor @Initialized StringBuffer data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, (String)null);
    }

    @Deprecated
    public static void write(@Nullable @UnknownKeyFor @Initialized StringBuffer data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data.toString().getBytes(Charsets.toCharset(encoding)));
        }
    }

    @Deprecated
    public static void writeLines(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> lines, @Nullable @UnknownKeyFor @Initialized String lineEnding, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.writeLines(lines, lineEnding, output, Charset.defaultCharset());
    }

    public static void writeLines(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> lines, @Nullable @UnknownKeyFor @Initialized String lineEnding, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_SEPARATOR;
        }
        Charset cs = Charsets.toCharset(encoding);
        for (Object line : lines) {
            if (line != null) {
                output.write(line.toString().getBytes(cs));
            }
            output.write(lineEnding.getBytes(cs));
        }
    }

    public static void writeLines(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> lines, @Nullable @UnknownKeyFor @Initialized String lineEnding, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.writeLines(lines, lineEnding, output, Charsets.toCharset(encoding));
    }

    public static void writeLines(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> lines, @Nullable @UnknownKeyFor @Initialized String lineEnding, @UnknownKeyFor @NonNull @Initialized Writer writer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_SEPARATOR;
        }
        for (Object line : lines) {
            if (line != null) {
                writer.write(line.toString());
            }
            writer.write(lineEnding);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized int copy(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static @UnknownKeyFor @NonNull @Initialized long copy(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized int bufferSize) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copyLarge(input, output, new byte[bufferSize]);
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copy(input, output, 4096);
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized long inputOffset, @UnknownKeyFor @NonNull @Initialized long length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copyLarge(input, output, inputOffset, length, new byte[4096]);
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized long inputOffset, @UnknownKeyFor @NonNull @Initialized long length, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int read;
        int bufferLength;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = bufferLength = buffer.length;
        if (length > 0L && length < (long)bufferLength) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read = input.read(buffer, 0, bytesToRead))) {
            output.write(buffer, 0, read);
            totalRead += (long)read;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)bufferLength);
        }
        return totalRead;
    }

    @Deprecated
    public static void copy(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.copy(input, output, Charset.defaultCharset());
    }

    public static void copy(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized Writer output, @Nullable @UnknownKeyFor @Initialized Charset inputEncoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        InputStreamReader in = new InputStreamReader(input, Charsets.toCharset(inputEncoding));
        IOUtils.copy((Reader)in, output);
    }

    public static void copy(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized Writer output, @Nullable @UnknownKeyFor @Initialized String inputEncoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.copy(input, output, Charsets.toCharset(inputEncoding));
    }

    public static @UnknownKeyFor @NonNull @Initialized int copy(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copyLarge(input, output, new char[4096]);
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer output, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer output, @UnknownKeyFor @NonNull @Initialized long inputOffset, @UnknownKeyFor @NonNull @Initialized long length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copyLarge(input, output, inputOffset, length, new char[4096]);
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer output, @UnknownKeyFor @NonNull @Initialized long inputOffset, @UnknownKeyFor @NonNull @Initialized long length, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int read;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = buffer.length;
        if (length > 0L && length < (long)buffer.length) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read = input.read(buffer, 0, bytesToRead))) {
            output.write(buffer, 0, read);
            totalRead += (long)read;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)buffer.length);
        }
        return totalRead;
    }

    @Deprecated
    public static void copy(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.copy(input, output, Charset.defaultCharset());
    }

    public static void copy(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized Charset outputEncoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        OutputStreamWriter out = new OutputStreamWriter(output, Charsets.toCharset(outputEncoding));
        IOUtils.copy(input, (Writer)out);
        out.flush();
    }

    public static void copy(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String outputEncoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.copy(input, output, Charsets.toCharset(outputEncoding));
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean contentEquals(@UnknownKeyFor @NonNull @Initialized InputStream input1, @UnknownKeyFor @NonNull @Initialized InputStream input2) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int ch2;
        if (input1 == input2) {
            return true;
        }
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean contentEquals(@UnknownKeyFor @NonNull @Initialized Reader input1, @UnknownKeyFor @NonNull @Initialized Reader input2) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int ch2;
        if (input1 == input2) {
            return true;
        }
        input1 = IOUtils.toBufferedReader(input1);
        input2 = IOUtils.toBufferedReader(input2);
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean contentEqualsIgnoreEOL(@UnknownKeyFor @NonNull @Initialized Reader input1, @UnknownKeyFor @NonNull @Initialized Reader input2) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (input1 == input2) {
            return true;
        }
        BufferedReader br1 = IOUtils.toBufferedReader(input1);
        BufferedReader br2 = IOUtils.toBufferedReader(input2);
        String line1 = br1.readLine();
        String line2 = br2.readLine();
        while (line1 != null && line2 != null && line1.equals(line2)) {
            line1 = br1.readLine();
            line2 = br2.readLine();
        }
        return line1 == null ? line2 == null : line1.equals(line2);
    }

    @EnsuresNonNull(value={"SKIP_BYTE_BUFFER"})
    public static @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (SKIP_BYTE_BUFFER == null) {
            SKIP_BYTE_BUFFER = new byte[2048];
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(SKIP_BYTE_BUFFER, 0, (int)Math.min(remain, 2048L))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long remain;
        int n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        ByteBuffer skipByteBuffer = ByteBuffer.allocate((int)Math.min(toSkip, 2048L));
        for (remain = toSkip; remain > 0L; remain -= (long)n) {
            skipByteBuffer.position(0);
            skipByteBuffer.limit((int)Math.min(remain, 2048L));
            n = input.read(skipByteBuffer);
            if (n == -1) break;
        }
        return toSkip - remain;
    }

    @EnsuresNonNull(value={"SKIP_CHAR_BUFFER"})
    public static @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (SKIP_CHAR_BUFFER == null) {
            SKIP_CHAR_BUFFER = new char[2048];
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(SKIP_CHAR_BUFFER, 0, (int)Math.min(remain, 2048L))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static void skipFully(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtils.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static void skipFully(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtils.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static void skipFully(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long skipped = IOUtils.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Chars to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int location;
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    public static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.read(input, buffer, 0, buffer.length);
    }

    public static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int location;
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    public static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.read(input, buffer, 0, buffer.length);
    }

    public static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel input, @UnknownKeyFor @NonNull @Initialized ByteBuffer buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int count;
        int length = buffer.remaining();
        while (buffer.remaining() > 0 && -1 != (count = input.read(buffer))) {
        }
        return length - buffer.remaining();
    }

    public static void readFully(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int actual = IOUtils.read(input, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    public static void readFully(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.readFully(input, buffer, 0, buffer.length);
    }

    public static void readFully(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int actual = IOUtils.read(input, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    public static void readFully(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.readFully(input, buffer, 0, buffer.length);
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] readFully(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] buffer = new byte[length];
        IOUtils.readFully(input, buffer, 0, buffer.length);
        return buffer;
    }

    public static void readFully(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel input, @UnknownKeyFor @NonNull @Initialized ByteBuffer buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int expected = buffer.remaining();
        int actual = IOUtils.read(input, buffer);
        if (actual != expected) {
            throw new EOFException("Length to read: " + expected + " actual: " + actual);
        }
    }

    static {
        try (StringBuilderWriter buf = new StringBuilderWriter(4);
             PrintWriter out = new PrintWriter(buf);){
            out.println();
            LINE_SEPARATOR = buf.toString();
        }
    }
}

