/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming.polish;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;

public final class PolishStemmer
implements IStemmer,
Iterable<WordData> {
    private static Dictionary dictionary;
    private final DictionaryLookup lookup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolishStemmer() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (dictionary == null) {
                try {
                    URL dictResource = this.getClass().getResource("pl.dict");
                    if (dictResource == null) {
                        throw new IOException("Polish dictionary resource not found.");
                    }
                    dictionary = Dictionary.read((URL)dictResource);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read dictionary data.", e);
                }
            }
        }
        this.lookup = new DictionaryLookup(dictionary);
    }

    public Dictionary getDictionary() {
        return dictionary;
    }

    public List<WordData> lookup(CharSequence word) {
        return this.lookup.lookup(word);
    }

    @Override
    public Iterator<WordData> iterator() {
        return this.lookup.iterator();
    }
}

