// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.tesseract;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.leptonica.*;
import static org.bytedeco.leptonica.global.lept.*;

import static org.bytedeco.tesseract.global.tesseract.*;


/** Base class for all tesseract image thresholding classes.
 *  Specific classes can add new thresholding methods by
 *  overriding ThresholdToPix.
 *  Each instance deals with a single image, but the design is intended to
 *  be useful for multiple calls to SetRectangle and ThresholdTo* if
 *  desired. */
@Namespace("tesseract") @NoOffset @Properties(inherit = org.bytedeco.tesseract.presets.tesseract.class)
public class ImageThresholder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ImageThresholder(Pointer p) { super(p); }


  /** Destroy the Pix if there is one, freeing memory. */
  public native void Clear();

  /** Return true if no image has been set. */
  

  /** SetImage makes a copy of all the image data, so it may be deleted
   *  immediately after this call.
   *  Greyscale of 8 and color of 24 or 32 bits per pixel may be given.
   *  Palette color images will not work properly and must be converted to
   *  24 bit.
   *  Binary images of 1 bit per pixel may also be given but they must be
   *  byte packed with the MSB of the first byte being the first pixel, and a
   *  one pixel is WHITE. For binary images set bytes_per_pixel=0. */
  

  /** Store the coordinates of the rectangle to process for later use.
   *  Doesn't actually do any thresholding. */
  

  /** Get enough parameters to be able to rebuild bounding boxes in the
   *  original image (not just within the rectangle).
   *  Left and top are enough with top-down coordinates, but
   *  the height of the rectangle and the image are needed for bottom-up. */
  public native void GetImageSizes(IntPointer left, IntPointer top, IntPointer width, IntPointer height,
                               IntPointer imagewidth, IntPointer imageheight);
  public native void GetImageSizes(IntBuffer left, IntBuffer top, IntBuffer width, IntBuffer height,
                               IntBuffer imagewidth, IntBuffer imageheight);
  public native void GetImageSizes(int[] left, int[] top, int[] width, int[] height,
                               int[] imagewidth, int[] imageheight);

  /** Return true if the source image is color. */
  public native @Cast("bool") boolean IsColor();

  /** Returns true if the source image is binary. */
  public native @Cast("bool") boolean IsBinary();

  public native int GetScaleFactor();

  // Set the resolution of the source image in pixels per inch.
  // This should be called right after SetImage(), and will let us return
  // appropriate font sizes for the text.
  public native void SetSourceYResolution(int ppi);
  public native int GetSourceYResolution();
  public native int GetScaledYResolution();
  // Set the resolution of the source image in pixels per inch, as estimated
  // by the thresholder from the text size found during thresholding.
  // This value will be used to set internal size thresholds during recognition
  // and will not influence the output "point size." The default value is
  // the same as the source resolution. (yres_)
  public native void SetEstimatedResolution(int ppi);
  // Returns the estimated resolution, including any active scaling.
  // This value will be used to set internal size thresholds during recognition.
  public native int GetScaledEstimatedResolution();

  /** Pix vs raw, which to use? Pix is the preferred input for efficiency,
   *  since raw buffers are copied.
   *  SetImage for Pix clones its input, so the source pix may be pixDestroyed
   *  immediately after, but may not go away until after the Thresholder has
   *  finished with it. */
  

  /** Threshold the source image as efficiently as possible to the output Pix.
   *  Creates a Pix and sets pix to point to the resulting pointer.
   *  Caller must use pixDestroy to free the created Pix.
   *  Returns false on error. */
  public native @Cast("bool") boolean ThresholdToPix(@Cast("tesseract::PageSegMode") int pageseg_mode, @Cast("Pix**") PointerPointer pix);
  public native @Cast("bool") boolean ThresholdToPix(@Cast("tesseract::PageSegMode") int pageseg_mode, @ByPtrPtr PIX pix);

  // Gets a pix that contains an 8 bit threshold value at each pixel. The
  // returned pix may be an integer reduction of the binary image such that
  // the scale factor may be inferred from the ratio of the sizes, even down
  // to the extreme of a 1x1 pixel thresholds image.
  // Ideally the 8 bit threshold should be the exact threshold used to generate
  // the binary image in ThresholdToPix, but this is not a hard constraint.
  // Returns nullptr if the input is binary. PixDestroy after use.
  public native PIX GetPixRectThresholds();

  /** Get a clone/copy of the source image rectangle.
   *  The returned Pix must be pixDestroyed.
   *  This function will be used in the future by the page layout analysis, and
   *  the layout analysis that uses it will only be available with Leptonica,
   *  so there is no raw equivalent. */
  

  // Get a clone/copy of the source image rectangle, reduced to greyscale,
  // and at the same resolution as the output binary.
  // The returned Pix must be pixDestroyed.
  // Provided to the classifier to extract features from the greyscale image.
  
}
