/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.base.Optional;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.Table;
import com.google.common.io.ByteSource;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.guava.api.Assertions;
import org.assertj.guava.api.ByteSourceAssert;
import org.assertj.guava.api.MultimapAssert;
import org.assertj.guava.api.MultisetAssert;
import org.assertj.guava.api.OptionalAssert;
import org.assertj.guava.api.RangeAssert;
import org.assertj.guava.api.RangeMapAssert;
import org.assertj.guava.api.TableAssert;

public interface InstanceOfAssertFactories {
    public static final InstanceOfAssertFactory<ByteSource, ByteSourceAssert> BYTE_SOURCE = new InstanceOfAssertFactory(ByteSource.class, Assertions::assertThat);
    public static final InstanceOfAssertFactory<Multimap, MultimapAssert<Object, Object>> MULTIMAP = InstanceOfAssertFactories.multimap(Object.class, Object.class);
    public static final InstanceOfAssertFactory<Optional, OptionalAssert<Object>> OPTIONAL = InstanceOfAssertFactories.optional(Object.class);
    public static final InstanceOfAssertFactory<Table, TableAssert<Object, Object, Object>> TABLE = InstanceOfAssertFactories.table(Object.class, Object.class, Object.class);
    public static final InstanceOfAssertFactory<Multiset, MultisetAssert<Object>> MULTISET = InstanceOfAssertFactories.multiset(Object.class);

    public static <K, V> InstanceOfAssertFactory<Multimap, MultimapAssert<K, V>> multimap(Class<K> keyType, Class<V> valueType) {
        return new InstanceOfAssertFactory(Multimap.class, Assertions::assertThat);
    }

    public static <VALUE> InstanceOfAssertFactory<Optional, OptionalAssert<VALUE>> optional(Class<VALUE> resultType) {
        return new InstanceOfAssertFactory(Optional.class, Assertions::assertThat);
    }

    public static <C extends Comparable<C>> InstanceOfAssertFactory<Range, RangeAssert<C>> range(Class<C> comparableType) {
        return new InstanceOfAssertFactory(Range.class, Assertions::assertThat);
    }

    public static <K extends Comparable<K>, V> InstanceOfAssertFactory<RangeMap, RangeMapAssert<K, V>> rangeMap(Class<K> keyType, Class<V> valueType) {
        return new InstanceOfAssertFactory(RangeMap.class, Assertions::assertThat);
    }

    public static <R, C, V> InstanceOfAssertFactory<Table, TableAssert<R, C, V>> table(Class<R> rowKeyType, Class<C> columnKeyType, Class<V> valueType) {
        return new InstanceOfAssertFactory(Table.class, Assertions::assertThat);
    }

    public static <ELEMENT> InstanceOfAssertFactory<Multiset, MultisetAssert<ELEMENT>> multiset(Class<ELEMENT> elementType) {
        return new InstanceOfAssertFactory(Multiset.class, Assertions::assertThat);
    }
}

