/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java;

import java.util.List;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldByte;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdBinding;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdTypeBound;
import org.aspectj.org.eclipse.jdt.internal.core.util.CharArrayBuffer;

public class NdTypeParameter
extends NdNode {
    public static final FieldManyToOne<NdBinding> PARENT;
    public static final FieldString IDENTIFIER;
    public static final FieldOneToMany<NdTypeBound> BOUNDS;
    public static final FieldByte TYPE_PARAMETER_FLAGS;
    public static final byte FLG_FIRST_BOUND_IS_A_CLASS = 1;
    public static final StructDef<NdTypeParameter> type;

    static {
        type = StructDef.create(NdTypeParameter.class, NdNode.type);
        PARENT = FieldManyToOne.createOwner(type, NdBinding.TYPE_PARAMETERS);
        IDENTIFIER = type.addString();
        BOUNDS = FieldOneToMany.create(type, NdTypeBound.PARENT);
        TYPE_PARAMETER_FLAGS = type.addByte();
        type.done();
    }

    public NdTypeParameter(Nd nd, long address) {
        super(nd, address);
    }

    public NdTypeParameter(NdBinding parent, char[] identifier) {
        super(parent.getNd());
        PARENT.put(this.getNd(), this.address, parent);
        IDENTIFIER.put(this.getNd(), this.address, identifier);
    }

    public char[] getIdentifier() {
        return IDENTIFIER.get(this.getNd(), this.address).getChars();
    }

    public void setFirstBoundIsClass(boolean isClass) {
        this.setFlag((byte)1, isClass);
    }

    public boolean isFirstBoundAClass() {
        return (TYPE_PARAMETER_FLAGS.get(this.getNd(), this.address) & 1) != 0;
    }

    private void setFlag(byte flag, boolean value) {
        byte oldValue = TYPE_PARAMETER_FLAGS.get(this.getNd(), this.address);
        byte newValue = value ? (byte)(oldValue | flag) : (byte)(oldValue & ~flag);
        TYPE_PARAMETER_FLAGS.put(this.getNd(), this.address, newValue);
    }

    public List<NdTypeBound> getBounds() {
        return BOUNDS.asList(this.getNd(), this.address);
    }

    public void getSignature(CharArrayBuffer result) {
        result.append(this.getIdentifier());
        List<NdTypeBound> bounds = this.getBounds();
        if (!bounds.isEmpty() && !this.isFirstBoundAClass()) {
            result.append(':');
        }
        for (NdTypeBound next : bounds) {
            next.getSignature(result);
        }
    }

    public static void getSignature(CharArrayBuffer buffer, List<NdTypeParameter> params) {
        if (!params.isEmpty()) {
            buffer.append('<');
            for (NdTypeParameter next : params) {
                next.getSignature(buffer);
            }
            buffer.append('>');
        }
    }
}

