/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest.resources;

import java.util.Collection;
import java.util.List;
import javax.security.auth.login.FailedLoginException;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.rest.BadRestRequestException;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.UserAuthenticationResourceEntityResponseFactory;
import org.apereo.cas.support.rest.resources.RestResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="userAuthenticationResource")
public class UserAuthenticationResource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAuthenticationResource.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final RestHttpRequestCredentialFactory credentialFactory;
    private final ServiceFactory serviceFactory;
    private final UserAuthenticationResourceEntityResponseFactory userAuthenticationResourceEntityResponseFactory;

    @PostMapping(value={"/v1/users"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createTicketGrantingTicket(@RequestBody MultiValueMap<String, String> requestBody, HttpServletRequest request) {
        try {
            List credential = this.credentialFactory.fromRequest(request, requestBody);
            if (credential == null || credential.isEmpty()) {
                throw new BadRestRequestException("No credentials are provided or extracted to authenticate the REST request");
            }
            Service service = this.serviceFactory.createService(request);
            AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(service, (Collection)credential);
            if (authenticationResult == null) {
                throw new FailedLoginException("Authentication failed");
            }
            return this.userAuthenticationResourceEntityResponseFactory.build(authenticationResult, request);
        }
        catch (AuthenticationException e) {
            return RestResourceUtils.createResponseEntityForAuthnFailure(e);
        }
        catch (BadRestRequestException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Generated
    public UserAuthenticationResource(AuthenticationSystemSupport authenticationSystemSupport, RestHttpRequestCredentialFactory credentialFactory, ServiceFactory serviceFactory, UserAuthenticationResourceEntityResponseFactory userAuthenticationResourceEntityResponseFactory) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.credentialFactory = credentialFactory;
        this.serviceFactory = serviceFactory;
        this.userAuthenticationResourceEntityResponseFactory = userAuthenticationResourceEntityResponseFactory;
    }
}

