/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.support.rest.BadRequestException;
import org.apereo.cas.support.rest.CredentialFactory;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="ticketResourceRestController")
public class TicketsResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketsResource.class);
    private static final String DOCTYPE_AND_TITLE = "<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>";
    private static final String CLOSE_TITLE_AND_OPEN_FORM = "</title></head><body><h1>TGT Created</h1><form action=\"";
    private static final String TGT_CREATED_TITLE_CONTENT = HttpStatus.CREATED.toString() + ' ' + HttpStatus.CREATED.getReasonPhrase();
    private static final String DOCTYPE_AND_OPENING_FORM = "<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>" + TGT_CREATED_TITLE_CONTENT + "</title></head><body><h1>TGT Created</h1><form action=\"";
    private static final String REST_OF_THE_FORM_AND_CLOSING_TAGS = "\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>";
    private static final int SUCCESSFUL_TGT_CREATED_INITIAL_LENGTH = DOCTYPE_AND_OPENING_FORM.length() + "\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>".length();
    private final CentralAuthenticationService centralAuthenticationService;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final CredentialFactory credentialFactory;
    private final ServiceFactory webApplicationServiceFactory;
    private final TicketRegistrySupport ticketRegistrySupport;
    private final ObjectWriter jacksonPrettyWriter = new ObjectMapper().findAndRegisterModules().writer().withDefaultPrettyPrinter();

    public TicketsResource(AuthenticationSystemSupport authenticationSystemSupport, CredentialFactory credentialFactory, TicketRegistrySupport ticketRegistrySupport, ServiceFactory webApplicationServiceFactory, CentralAuthenticationService centralAuthenticationService) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.credentialFactory = credentialFactory;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.centralAuthenticationService = centralAuthenticationService;
    }

    @PostMapping(value={"/v1/tickets"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createTicketGrantingTicket(@RequestBody MultiValueMap<String, String> requestBody, HttpServletRequest request) throws JsonProcessingException {
        try {
            String response;
            String accept;
            Credential credential = this.credentialFactory.fromRequestBody(requestBody);
            AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(null, new Credential[]{credential});
            TicketGrantingTicket tgtId = this.centralAuthenticationService.createTicketGrantingTicket(authenticationResult);
            URI ticketReference = new URI(request.getRequestURL().toString() + '/' + tgtId.getId());
            HttpHeaders headers = new HttpHeaders();
            headers.setLocation(ticketReference);
            String string = accept = request.getHeader("Accept") == null ? null : request.getHeader("Accept").trim();
            if (accept == null || accept.startsWith("*/*") || accept.startsWith("text/html")) {
                headers.setContentType(MediaType.TEXT_HTML);
                String tgtUrl = ticketReference.toString();
                response = new StringBuilder(SUCCESSFUL_TGT_CREATED_INITIAL_LENGTH + tgtUrl.length()).append(DOCTYPE_AND_OPENING_FORM).append(tgtUrl).append(REST_OF_THE_FORM_AND_CLOSING_TAGS).toString();
            } else {
                response = tgtId.getId();
            }
            return new ResponseEntity((Object)response, (MultiValueMap)headers, HttpStatus.CREATED);
        }
        catch (AuthenticationException e) {
            List authnExceptions = e.getHandlerErrors().values().stream().map(Class::getSimpleName).collect(Collectors.toList());
            HashMap errorsMap = new HashMap();
            errorsMap.put("authentication_exceptions", authnExceptions);
            LOGGER.error("[{}] Caused by: [{}]", new Object[]{e.getMessage(), authnExceptions, e});
            try {
                return new ResponseEntity((Object)this.jacksonPrettyWriter.writeValueAsString(errorsMap), HttpStatus.UNAUTHORIZED);
            }
            catch (JsonProcessingException exception) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (BadRequestException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/v1/tickets/{id:.+}"})
    public ResponseEntity<String> getTicketStatus(@PathVariable(value="id") String id) {
        try {
            this.centralAuthenticationService.getTicket(id);
            return new ResponseEntity((Object)id, HttpStatus.OK);
        }
        catch (InvalidTicketException e) {
            return new ResponseEntity((Object)"Ticket could not be found", HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/v1/tickets/{tgtId:.+}"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createServiceTicket(@RequestBody MultiValueMap<String, String> requestBody, @PathVariable(value="tgtId") String tgtId) {
        try {
            TicketGrantingTicket tgt = (TicketGrantingTicket)this.centralAuthenticationService.getTicket(tgtId);
            String serviceId = (String)requestBody.getFirst((Object)"service");
            DefaultAuthenticationResultBuilder builder = new DefaultAuthenticationResultBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
            Service service = this.webApplicationServiceFactory.createService(serviceId);
            AuthenticationResult authenticationResult = builder.collect(tgt.getAuthentication()).build(service);
            ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(tgtId, service, authenticationResult);
            return new ResponseEntity((Object)serviceTicketId.getId(), HttpStatus.OK);
        }
        catch (InvalidTicketException e) {
            return new ResponseEntity((Object)"TicketGrantingTicket could not be found", HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/v1/tickets/{tgtId:.+}"})
    public ResponseEntity<String> deleteTicketGrantingTicket(@PathVariable(value="tgtId") String tgtId) {
        this.centralAuthenticationService.destroyTicketGrantingTicket(tgtId);
        return new ResponseEntity((Object)tgtId, HttpStatus.OK);
    }
}

