/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.config.support.authentication;

import java.util.ArrayList;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.DelegatedAuthenticationAuditResourceResolver;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.pac4j.authentication.ClientAuthenticationMetaDataPopulator;
import org.apereo.cas.support.pac4j.authentication.DelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.handler.support.ClientAuthenticationHandler;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.pac4j.core.client.Clients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="pac4jAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class Pac4jAuthenticationEventExecutionPlanConfiguration
implements AuditTrailRecordResolutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    @Qualifier(value="authenticationActionResolver")
    private AuditActionResolver authenticationActionResolver;

    @Bean
    @ConditionalOnMissingBean(name={"pac4jDelegatedClientFactory"})
    @RefreshScope
    public DelegatedClientFactory pac4jDelegatedClientFactory() {
        return new DelegatedClientFactory(this.casProperties.getAuthn().getPac4j());
    }

    @RefreshScope
    @Bean
    public Clients builtClients() {
        Set clients = this.pac4jDelegatedClientFactory().build();
        LOGGER.debug("The following clients are built: [{}]", (Object)clients);
        if (clients.isEmpty()) {
            LOGGER.warn("No delegated authentication clients are defined and/or configured");
        } else {
            LOGGER.info("Located and prepared [{}] delegated authentication client(s)", (Object)clients.size());
        }
        return new Clients(this.casProperties.getServer().getLoginUrl(), new ArrayList(clients));
    }

    @ConditionalOnMissingBean(name={"clientPrincipalFactory"})
    @Bean
    public PrincipalFactory clientPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"clientAuthenticationMetaDataPopulator"})
    @Bean
    public AuthenticationMetaDataPopulator clientAuthenticationMetaDataPopulator() {
        return new ClientAuthenticationMetaDataPopulator();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"clientAuthenticationHandler"})
    public AuthenticationHandler clientAuthenticationHandler() {
        Pac4jDelegatedAuthenticationProperties pac4j = this.casProperties.getAuthn().getPac4j();
        ClientAuthenticationHandler h = new ClientAuthenticationHandler(pac4j.getName(), this.servicesManager, this.clientPrincipalFactory(), this.builtClients());
        h.setTypedIdUsed(pac4j.isTypedIdUsed());
        h.setPrincipalAttributeId(pac4j.getPrincipalAttributeId());
        return h;
    }

    @ConditionalOnMissingBean(name={"pac4jAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer pac4jAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            if (!this.builtClients().findAllClients().isEmpty()) {
                LOGGER.info("Registering delegated authentication clients...");
                plan.registerAuthenticationHandlerWithPrincipalResolver(this.clientAuthenticationHandler(), this.personDirectoryPrincipalResolver);
                plan.registerMetadataPopulator(this.clientAuthenticationMetaDataPopulator());
            }
        };
    }

    @ConditionalOnMissingBean(name={"delegatedAuthenticationAuditResourceResolver"})
    @Bean
    public AuditResourceResolver delegatedAuthenticationAuditResourceResolver() {
        return new DelegatedAuthenticationAuditResourceResolver();
    }

    public void configureAuditTrailRecordResolutionPlan(AuditTrailRecordResolutionPlan plan) {
        plan.registerAuditActionResolver("DELEGATED_CLIENT_ACTION_RESOLVER", this.authenticationActionResolver);
        plan.registerAuditResourceResolver("DELEGATED_CLIENT_RESOURCE_RESOLVER", this.delegatedAuthenticationAuditResourceResolver());
    }
}

