/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPac4jAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPac4jAuthenticationHandler.class);
    private String principalAttributeId;
    private boolean isTypedIdUsed;

    public AbstractPac4jAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    protected AuthenticationHandlerExecutionResult createResult(ClientCredential credentials, UserProfile profile, BaseClient client) throws GeneralSecurityException {
        if (profile == null) {
            throw new FailedLoginException("Authentication did not produce a user profile for: " + credentials);
        }
        String id = this.determinePrincipalIdFrom(profile, client);
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new FailedLoginException("No identifier found for this user profile: " + profile);
        }
        credentials.setUserProfile(profile);
        credentials.setTypedIdUsed(this.isTypedIdUsed);
        Principal principal = this.principalFactory.createPrincipal(id, new LinkedHashMap(profile.getAttributes()));
        LOGGER.debug("Constructed authenticated principal [{}] based on user profile [{}]", (Object)principal, (Object)profile);
        return this.createHandlerResult((Credential)credentials, principal, new ArrayList(0));
    }

    protected String determinePrincipalIdFrom(UserProfile profile, BaseClient client) {
        Map properties;
        String id = profile.getId();
        Map map = properties = client != null ? client.getCustomProperties() : new HashMap();
        if (properties.containsKey("principalAttributeId")) {
            Object attrObject = properties.get("principalAttributeId");
            if (attrObject != null) {
                String principalAttribute = attrObject.toString();
                if (profile.containsAttribute(principalAttribute)) {
                    Optional firstAttribute = CollectionUtils.firstElement((Object)profile.getAttribute(principalAttribute));
                    if (firstAttribute.isPresent()) {
                        id = firstAttribute.get().toString();
                        id = this.typePrincipalId(id, profile);
                    }
                    LOGGER.debug("Delegated authentication indicates usage of client principal attribute [{}] for the identifier [{}]", (Object)principalAttribute, (Object)id);
                } else {
                    LOGGER.warn("Delegated authentication cannot find attribute [{}] to use as principal id", (Object)principalAttribute);
                }
            } else {
                LOGGER.warn("No custom principal attribute was provided by the client [{}]. Using the default id [{}]", (Object)client, (Object)id);
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.principalAttributeId)) {
            if (profile.containsAttribute(this.principalAttributeId)) {
                Optional firstAttribute = CollectionUtils.firstElement((Object)profile.getAttribute(this.principalAttributeId));
                if (firstAttribute.isPresent()) {
                    id = firstAttribute.get().toString();
                    id = this.typePrincipalId(id, profile);
                }
            } else {
                LOGGER.warn("CAS cannot use [{}] as the principal attribute id, since the profile attributes do not contain the attribute. Either adjust the CAS configuration to use a different attribute, or contact the delegated authentication provider noted by [{}] to release the expected attribute to CAS", (Object)this.principalAttributeId, (Object)profile.getAttributes());
            }
            LOGGER.debug("Delegated authentication indicates usage of attribute [{}] for the identifier [{}]", (Object)this.principalAttributeId, (Object)id);
        } else if (this.isTypedIdUsed) {
            id = profile.getTypedId();
            LOGGER.debug("Delegated authentication indicates usage of typed profile id [{}]", (Object)id);
        }
        LOGGER.debug("Final principal id determined based on client [{}] and user profile [{}] is [{}]", new Object[]{profile, client, id});
        return id;
    }

    private String typePrincipalId(String id, UserProfile profile) {
        if (this.isTypedIdUsed) {
            return profile.getClass().getName() + "#" + id;
        }
        return id;
    }

    @Generated
    public void setPrincipalAttributeId(String principalAttributeId) {
        this.principalAttributeId = principalAttributeId;
    }

    @Generated
    public void setTypedIdUsed(boolean isTypedIdUsed) {
        this.isTypedIdUsed = isTypedIdUsed;
    }
}

