/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.impl.AbstractTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleTranslator
extends AbstractTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleTranslator.class);
    private static final String GOOGLE_TRANSLATE_URL_BASE = "https://www.googleapis.com/language/translate/v2";
    private static final String DEFAULT_KEY = "dummy-secret";
    private WebClient client = WebClient.create((String)"https://www.googleapis.com/language/translate/v2");
    private String apiKey;
    private boolean isAvailable = true;

    public GoogleTranslator() {
        Properties config = new Properties();
        try {
            config.load(GoogleTranslator.class.getResourceAsStream("translator.google.properties"));
            this.apiKey = config.getProperty("translator.client-secret");
            if (this.apiKey.equals(DEFAULT_KEY)) {
                this.isAvailable = false;
            }
        }
        catch (Exception e) {
            LOG.warn("Exception reading config file", (Throwable)e);
            this.isAvailable = false;
        }
    }

    public String translate(String text, String sourceLanguage, String targetLanguage) throws TikaException, IOException {
        if (!this.isAvailable) {
            return text;
        }
        Response response = this.client.accept(new String[]{"application/json"}).query("key", new Object[]{this.apiKey}).query("source", new Object[]{sourceLanguage}).query("target", new Object[]{targetLanguage}).query("q", new Object[]{text}).get();
        StringBuilder responseText = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                responseText.append(line);
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonResp = mapper.readTree(responseText.toString());
        return (String)jsonResp.findValuesAsText("translatedText").get(0);
    }

    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        if (!this.isAvailable) {
            return text;
        }
        String sourceLanguage = this.detectLanguage(text).getLanguage();
        return this.translate(text, sourceLanguage, targetLanguage);
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }
}

