/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.apache.commons.logging.Log;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public final class JCLLoggerAdapter
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 4141593417490482209L;
    final Log log;

    JCLLoggerAdapter(Log log, String name) {
        this.log = log;
        this.name = name;
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public void trace(String msg) {
        this.log.trace(msg);
    }

    public void trace(String format, Object arg) {
        if (this.log.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.log.trace(ft.getMessage(), ft.getThrowable());
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.log.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.log.trace(ft.getMessage(), ft.getThrowable());
        }
    }

    public void trace(String format, Object[] argArray) {
        if (this.log.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.log.trace(ft.getMessage(), ft.getThrowable());
        }
    }

    public void trace(String msg, Throwable t) {
        this.log.trace(msg, t);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(String msg) {
        this.log.debug(msg);
    }

    public void debug(String format, Object arg) {
        if (this.log.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.log.debug(ft.getMessage(), ft.getThrowable());
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.log.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.log.debug(ft.getMessage(), ft.getThrowable());
        }
    }

    public void debug(String format, Object[] argArray) {
        if (this.log.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.log.debug(ft.getMessage(), ft.getThrowable());
        }
    }

    public void debug(String msg, Throwable t) {
        this.log.debug(msg, t);
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(String msg) {
        this.log.info(msg);
    }

    public void info(String format, Object arg) {
        if (this.log.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.log.info(ft.getMessage(), ft.getThrowable());
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.log.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.log.info(ft.getMessage(), ft.getThrowable());
        }
    }

    public void info(String format, Object[] argArray) {
        if (this.log.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.log.info(ft.getMessage(), ft.getThrowable());
        }
    }

    public void info(String msg, Throwable t) {
        this.log.info(msg, t);
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void warn(String msg) {
        this.log.warn(msg);
    }

    public void warn(String format, Object arg) {
        if (this.log.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.log.warn(ft.getMessage(), ft.getThrowable());
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.log.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.log.warn(ft.getMessage(), ft.getThrowable());
        }
    }

    public void warn(String format, Object[] argArray) {
        if (this.log.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.log.warn(ft.getMessage(), ft.getThrowable());
        }
    }

    public void warn(String msg, Throwable t) {
        this.log.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public void error(String msg) {
        this.log.error(msg);
    }

    public void error(String format, Object arg) {
        if (this.log.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            this.log.error(ft.getMessage(), ft.getThrowable());
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.log.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            this.log.error(ft.getMessage(), ft.getThrowable());
        }
    }

    public void error(String format, Object[] argArray) {
        if (this.log.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this.log.error(ft.getMessage(), ft.getThrowable());
        }
    }

    public void error(String msg, Throwable t) {
        this.log.error(msg, t);
    }
}

