/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

@Provider
@Produces(value={"application/zip"})
public class ZipWriter
implements MessageBodyWriter<Map<String, byte[]>> {
    private static void zipStoreBuffer(ZipArchiveOutputStream zip, String name, byte[] dataBuffer) throws IOException {
        block2: {
            ZipEntry zipEntry = new ZipEntry(name != null ? name : UUID.randomUUID().toString());
            zipEntry.setMethod(0);
            zipEntry.setSize(dataBuffer.length);
            CRC32 crc32 = new CRC32();
            crc32.update(dataBuffer);
            zipEntry.setCrc(crc32.getValue());
            try {
                zip.putArchiveEntry(new ZipArchiveEntry(zipEntry));
            }
            catch (ZipException ex) {
                if (name == null) break block2;
                ZipWriter.zipStoreBuffer(zip, "x-" + name, dataBuffer);
                return;
            }
        }
        zip.write(dataBuffer);
        zip.closeArchiveEntry();
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Map.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(Map<String, byte[]> stringMap, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Map<String, byte[]> parts, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ZipArchiveOutputStream zip = new ZipArchiveOutputStream(entityStream);
        zip.setMethod(0);
        for (Map.Entry<String, byte[]> entry : parts.entrySet()) {
            ZipWriter.zipStoreBuffer(zip, entry.getKey(), entry.getValue());
        }
        zip.close();
    }
}

