/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.server.CSVMessageBodyWriter;
import org.apache.tika.server.DetectorResource;
import org.apache.tika.server.JSONMessageBodyWriter;
import org.apache.tika.server.MetadataListMessageBodyWriter;
import org.apache.tika.server.MetadataResource;
import org.apache.tika.server.RecursiveMetadataResource;
import org.apache.tika.server.TarWriter;
import org.apache.tika.server.TextMessageBodyWriter;
import org.apache.tika.server.TikaDetectors;
import org.apache.tika.server.TikaExceptionMapper;
import org.apache.tika.server.TikaLoggingFilter;
import org.apache.tika.server.TikaMimeTypes;
import org.apache.tika.server.TikaParsers;
import org.apache.tika.server.TikaResource;
import org.apache.tika.server.TikaVersion;
import org.apache.tika.server.TikaWelcome;
import org.apache.tika.server.UnpackerResource;
import org.apache.tika.server.XMPMessageBodyWriter;
import org.apache.tika.server.ZipWriter;

public class TikaServerCli {
    private static final Log logger = LogFactory.getLog(TikaServerCli.class);
    public static final int DEFAULT_PORT = 9998;
    public static final String DEFAULT_HOST = "localhost";
    public static final Set<String> LOG_LEVELS = new HashSet<String>(Arrays.asList("debug", "info"));

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("h", "host", true, "host name (default = localhost)");
        options.addOption("p", "port", true, "listen port (default = 9998)");
        options.addOption("l", "log", true, "request URI log level ('debug' or 'info')");
        options.addOption("?", "help", false, "this help message");
        return options;
    }

    public static void main(String[] args) {
        logger.info("Starting " + new Tika().toString() + " server");
        try {
            Options options = TikaServerCli.getOptions();
            GnuParser cliParser = new GnuParser();
            CommandLine line = cliParser.parse(options, args);
            if (line.hasOption("help")) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("tikaserver", options);
                System.exit(-1);
            }
            String host = DEFAULT_HOST;
            if (line.hasOption("host")) {
                host = line.getOptionValue("host");
            }
            int port = 9998;
            if (line.hasOption("port")) {
                port = Integer.valueOf(line.getOptionValue("port"));
            }
            TikaLoggingFilter logFilter = null;
            if (line.hasOption("log")) {
                String logLevel = line.getOptionValue("log");
                if (LOG_LEVELS.contains(logLevel)) {
                    boolean isInfoLevel = "info".equals(logLevel);
                    logFilter = new TikaLoggingFilter(isInfoLevel);
                } else {
                    logger.info("Unsupported request URI log level: " + logLevel);
                }
            }
            TikaConfig tika = TikaConfig.getDefaultConfig();
            JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
            ArrayList<ResourceProvider> rCoreProviders = new ArrayList<ResourceProvider>();
            rCoreProviders.add(new SingletonResourceProvider(new MetadataResource(tika)));
            rCoreProviders.add(new SingletonResourceProvider(new RecursiveMetadataResource(tika)));
            rCoreProviders.add(new SingletonResourceProvider(new DetectorResource(tika)));
            rCoreProviders.add(new SingletonResourceProvider(new TikaResource(tika)));
            rCoreProviders.add(new SingletonResourceProvider(new UnpackerResource(tika)));
            rCoreProviders.add(new SingletonResourceProvider(new TikaMimeTypes(tika)));
            rCoreProviders.add(new SingletonResourceProvider(new TikaDetectors(tika)));
            rCoreProviders.add(new SingletonResourceProvider(new TikaParsers(tika)));
            rCoreProviders.add(new SingletonResourceProvider(new TikaVersion(tika)));
            ArrayList<ResourceProvider> rAllProviders = new ArrayList<ResourceProvider>(rCoreProviders);
            rAllProviders.add(new SingletonResourceProvider(new TikaWelcome(tika, rCoreProviders)));
            sf.setResourceProviders(rAllProviders);
            ArrayList<Object> providers = new ArrayList<Object>();
            providers.add(new TarWriter());
            providers.add(new ZipWriter());
            providers.add(new CSVMessageBodyWriter());
            providers.add(new MetadataListMessageBodyWriter());
            providers.add(new JSONMessageBodyWriter());
            providers.add(new XMPMessageBodyWriter());
            providers.add(new TextMessageBodyWriter());
            providers.add(new TikaExceptionMapper());
            if (logFilter != null) {
                providers.add(logFilter);
            }
            sf.setProviders(providers);
            sf.setAddress("http://" + host + ":" + port + "/");
            BindingFactoryManager manager = sf.getBus().getExtension(BindingFactoryManager.class);
            JAXRSBindingFactory factory = new JAXRSBindingFactory();
            factory.setBus(sf.getBus());
            manager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", factory);
            sf.create();
            logger.info("Started");
        }
        catch (Exception ex) {
            logger.fatal("Can't start", ex);
            System.exit(-1);
        }
    }
}

