/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pkg.CompressorParserOptions;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CompressorParser
extends AbstractParser {
    private static final long serialVersionUID = 2793565792967222459L;
    private static final MediaType BZIP = MediaType.application("x-bzip");
    private static final MediaType BZIP2 = MediaType.application("x-bzip2");
    private static final MediaType GZIP = MediaType.application("gzip");
    private static final MediaType GZIP_ALT = MediaType.application("x-gzip");
    private static final MediaType XZ = MediaType.application("x-xz");
    private static final MediaType PACK = MediaType.application("application/x-java-pack200");
    private static final Set<MediaType> SUPPORTED_TYPES = MediaType.set(BZIP, BZIP2, GZIP, GZIP_ALT, XZ, PACK);

    static MediaType getMediaType(CompressorInputStream stream) {
        if (stream instanceof BZip2CompressorInputStream) {
            return BZIP2;
        }
        if (stream instanceof GzipCompressorInputStream) {
            return GZIP;
        }
        if (stream instanceof XZCompressorInputStream) {
            return XZ;
        }
        if (stream instanceof Pack200CompressorInputStream) {
            return PACK;
        }
        return MediaType.OCTET_STREAM;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        CompressorInputStream cis;
        stream = new CloseShieldInputStream(stream);
        stream = new BufferedInputStream(stream);
        try {
            CompressorStreamFactory factory = new CompressorStreamFactory();
            CompressorParserOptions options = context.get(CompressorParserOptions.class, new CompressorParserOptions(){

                @Override
                public boolean decompressConcatenated(Metadata metadata) {
                    return false;
                }
            });
            factory.setDecompressConcatenated(options.decompressConcatenated(metadata));
            cis = factory.createCompressorInputStream(stream);
        }
        catch (CompressorException e) {
            throw new TikaException("Unable to uncompress document stream", e);
        }
        MediaType type = CompressorParser.getMediaType(cis);
        if (!type.equals(MediaType.OCTET_STREAM)) {
            metadata.set("Content-Type", type.toString());
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            EmbeddedDocumentExtractor extractor;
            Metadata entrydata = new Metadata();
            String name = metadata.get("resourceName");
            if (name != null) {
                if (name.endsWith(".tbz")) {
                    name = name.substring(0, name.length() - 4) + ".tar";
                } else if (name.endsWith(".tbz2")) {
                    name = name.substring(0, name.length() - 5) + ".tar";
                } else if (name.endsWith(".bz")) {
                    name = name.substring(0, name.length() - 3);
                } else if (name.endsWith(".bz2")) {
                    name = name.substring(0, name.length() - 4);
                } else if (name.endsWith(".xz")) {
                    name = name.substring(0, name.length() - 3);
                } else if (name.endsWith(".pack")) {
                    name = name.substring(0, name.length() - 5);
                } else if (name.length() > 0) {
                    name = GzipUtils.getUncompressedFilename(name);
                }
                entrydata.set("resourceName", name);
            }
            if ((extractor = (EmbeddedDocumentExtractor)context.get(EmbeddedDocumentExtractor.class, new ParsingEmbeddedDocumentExtractor(context))).shouldParseEmbedded(entrydata)) {
                extractor.parseEmbedded(cis, xhtml, entrydata, true);
            }
        }
        finally {
            cis.close();
        }
        xhtml.endDocument();
    }
}

