/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class TextBytesAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 4008L;
    private byte[] _text;

    public String getText() {
        return StringUtil.getFromCompressedUnicode(this._text, 0, this._text.length);
    }

    public void setText(byte[] b) {
        this._text = b;
        LittleEndian.putInt(this._header, 4, this._text.length);
    }

    protected TextBytesAtom(byte[] source, int start, int len) {
        if (len < 8) {
            len = 8;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._text = new byte[len - 8];
        System.arraycopy(source, start + 8, this._text, 0, len - 8);
    }

    public TextBytesAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort(this._header, 0, 0);
        LittleEndian.putUShort(this._header, 2, (int)_type);
        LittleEndian.putInt(this._header, 4, 0);
        this._text = new byte[0];
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._text);
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("TextBytesAtom:\n");
        out.append(HexDump.dump(this._text, 0L, 0));
        return out.toString();
    }
}

