/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.poi.POIDocument;
import org.apache.poi.hslf.EncryptedSlideShow;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.EncryptedPowerPointFileException;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.record.CurrentUserAtom;
import org.apache.poi.hslf.record.ExOleObjStg;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PersistRecord;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.PositionDependentRecordAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.UserEditAtom;
import org.apache.poi.hslf.usermodel.ObjectData;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.EntryUtils;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class HSLFSlideShow
extends POIDocument {
    public static final int UNSET_OFFSET = -1;
    private POILogger logger = POILogFactory.getLogger(this.getClass());
    private CurrentUserAtom currentUser;
    private byte[] _docstream;
    private Record[] _records;
    private List<PictureData> _pictures;
    private ObjectData[] _objects;

    protected POIFSFileSystem getPOIFSFileSystem() {
        return this.directory.getFileSystem();
    }

    protected DirectoryNode getPOIFSDirectory() {
        return this.directory;
    }

    public HSLFSlideShow(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public HSLFSlideShow(InputStream inputStream) throws IOException {
        this(new POIFSFileSystem(inputStream));
    }

    public HSLFSlideShow(POIFSFileSystem filesystem) throws IOException {
        this(filesystem.getRoot());
    }

    public HSLFSlideShow(NPOIFSFileSystem filesystem) throws IOException {
        this(filesystem.getRoot());
    }

    @Deprecated
    public HSLFSlideShow(DirectoryNode dir, POIFSFileSystem filesystem) throws IOException {
        this(dir);
    }

    public HSLFSlideShow(DirectoryNode dir) throws IOException {
        super(dir);
        this.readCurrentUserStream();
        this.readPowerPointStream();
        boolean encrypted = EncryptedSlideShow.checkIfEncrypted(this);
        if (encrypted) {
            throw new EncryptedPowerPointFileException("Encrypted PowerPoint files are not supported");
        }
        this.buildRecords();
        this.readOtherStreams();
    }

    public static final HSLFSlideShow create() {
        InputStream is = HSLFSlideShow.class.getResourceAsStream("data/empty.ppt");
        if (is == null) {
            throw new RuntimeException("Missing resource 'empty.ppt'");
        }
        try {
            return new HSLFSlideShow(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void readPowerPointStream() throws IOException {
        DocumentEntry docProps = (DocumentEntry)this.directory.getEntry("PowerPoint Document");
        this._docstream = new byte[docProps.getSize()];
        this.directory.createDocumentInputStream("PowerPoint Document").read(this._docstream);
    }

    private void buildRecords() {
        this._records = this.read(this._docstream, (int)this.currentUser.getCurrentEditOffset());
    }

    private Record[] read(byte[] docstream, int usrOffset) {
        TreeMap<Integer, Record> records = new TreeMap<Integer, Record>();
        HashMap<Integer, Integer> persistIds = new HashMap<Integer, Integer>();
        this.initRecordOffsets(docstream, usrOffset, records, persistIds);
        for (Map.Entry entry : records.entrySet()) {
            Integer offset = (Integer)entry.getKey();
            Record record = (Record)entry.getValue();
            Integer persistId = (Integer)persistIds.get(offset);
            if (record == null) {
                record = Record.buildRecordAtOffset(docstream, offset);
                entry.setValue(record);
            }
            if (!(record instanceof PersistRecord)) continue;
            ((PersistRecord)((Object)record)).setPersistId(persistId);
        }
        return records.values().toArray(new Record[records.size()]);
    }

    private void initRecordOffsets(byte[] docstream, int usrOffset, NavigableMap<Integer, Record> recordMap, Map<Integer, Integer> offset2id) {
        while (usrOffset != 0) {
            UserEditAtom usr = (UserEditAtom)Record.buildRecordAtOffset(docstream, usrOffset);
            recordMap.put(usrOffset, usr);
            int psrOffset = usr.getPersistPointersOffset();
            PersistPtrHolder ptr = (PersistPtrHolder)Record.buildRecordAtOffset(docstream, psrOffset);
            recordMap.put(psrOffset, ptr);
            for (Map.Entry<Integer, Integer> entry : ptr.getSlideLocationsLookup().entrySet()) {
                Integer offset = entry.getValue();
                Integer id = entry.getKey();
                recordMap.put(offset, null);
                offset2id.put(offset, id);
            }
            usrOffset = usr.getLastUserEditAtomOffset();
            if (usrOffset <= 0 || !recordMap.containsKey(usrOffset)) continue;
            usrOffset = (Integer)recordMap.firstKey() - 36;
            int ver_inst = LittleEndian.getUShort(docstream, usrOffset);
            int type = LittleEndian.getUShort(docstream, usrOffset + 2);
            int len = LittleEndian.getInt(docstream, usrOffset + 4);
            if (ver_inst == 0 && type == 4085 && (len == 28 || len == 32)) {
                this.logger.log(5, "Repairing invalid user edit atom");
                usr.setLastUserEditAtomOffset(usrOffset);
                continue;
            }
            throw new CorruptPowerPointFileException("Powerpoint document contains invalid user edit atom");
        }
    }

    private void readCurrentUserStream() {
        try {
            this.currentUser = new CurrentUserAtom(this.directory);
        }
        catch (IOException ie) {
            this.logger.log(7, "Error finding Current User Atom:\n" + ie);
            this.currentUser = new CurrentUserAtom();
        }
    }

    private void readOtherStreams() {
    }

    private void readPictures() throws IOException {
        int imgsize;
        this._pictures = new ArrayList<PictureData>();
        if (!this.directory.hasEntry("Pictures")) {
            return;
        }
        DocumentEntry entry = (DocumentEntry)this.directory.getEntry("Pictures");
        byte[] pictstream = new byte[entry.getSize()];
        DocumentInputStream is = this.directory.createDocumentInputStream(entry);
        is.read(pictstream);
        is.close();
        for (int pos = 0; pos <= pictstream.length - 8; pos += imgsize) {
            int offset = pos;
            int signature = LittleEndian.getUShort(pictstream, pos);
            int type = LittleEndian.getUShort(pictstream, pos += 2);
            imgsize = LittleEndian.getInt(pictstream, pos += 2);
            pos += 4;
            if (type != 61447 && (type < 61464 || type > 61719)) break;
            if (imgsize < 0) {
                throw new CorruptPowerPointFileException("The file contains a picture, at position " + this._pictures.size() + ", which has a negatively sized data length, so we can't trust any of the picture data");
            }
            if (type == 0) {
                this.logger.log(7, "Problem reading picture: Invalid image type 0, on picture with length " + imgsize + ".\nYou document will probably become corrupted if you save it!");
                this.logger.log(7, "" + pos);
                continue;
            }
            try {
                PictureData pict = PictureData.create(type - 61464);
                byte[] imgdata = new byte[imgsize];
                System.arraycopy(pictstream, pos, imgdata, 0, imgdata.length);
                pict.setRawData(imgdata);
                pict.setOffset(offset);
                this._pictures.add(pict);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.logger.log(7, "Problem reading picture: " + e + "\nYou document will probably become corrupted if you save it!");
            }
        }
    }

    public void updateAndWriteDependantRecords(OutputStream os, Map<RecordTypes.Type, PositionDependentRecord> interestingRecords) throws IOException {
        Hashtable<Integer, Integer> oldToNewPositions = new Hashtable<Integer, Integer>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Record record : this._records) {
            if (record instanceof PositionDependentRecord) {
                PositionDependentRecord pdr = (PositionDependentRecord)((Object)record);
                int oldPos = pdr.getLastOnDiskOffset();
                int newPos = baos.size();
                pdr.setLastOnDiskOffset(newPos);
                if (oldPos != -1) {
                    oldToNewPositions.put(oldPos, newPos);
                }
            }
            record.writeOut(baos);
        }
        baos = null;
        PositionDependentRecordAtom usr = null;
        for (Record record : this._records) {
            if (record instanceof PositionDependentRecord) {
                PositionDependentRecord pdr = (PositionDependentRecord)((Object)record);
                pdr.updateOtherRecordReferences(oldToNewPositions);
                RecordTypes.Type saveme = null;
                int recordType = (int)record.getRecordType();
                if (recordType == RecordTypes.PersistPtrIncrementalBlock.typeID) {
                    saveme = RecordTypes.PersistPtrIncrementalBlock;
                } else if (recordType == RecordTypes.UserEditAtom.typeID) {
                    saveme = RecordTypes.UserEditAtom;
                    usr = (UserEditAtom)pdr;
                }
                if (interestingRecords != null && saveme != null) {
                    interestingRecords.put(saveme, pdr);
                }
            }
            if (os == null) continue;
            record.writeOut(os);
        }
        int oldLastUserEditAtomPos = (int)this.currentUser.getCurrentEditOffset();
        Integer newLastUserEditAtomPos = (Integer)oldToNewPositions.get(oldLastUserEditAtomPos);
        if (usr == null || newLastUserEditAtomPos == null || usr.getLastOnDiskOffset() != newLastUserEditAtomPos.intValue()) {
            throw new HSLFException("Couldn't find the new location of the last UserEditAtom that used to be at " + oldLastUserEditAtomPos);
        }
        this.currentUser.setCurrentEditOffset(usr.getLastOnDiskOffset());
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.write(out, false);
    }

    public void write(OutputStream out, boolean preserveNodes) throws IOException {
        POIFSFileSystem outFS = new POIFSFileSystem();
        ArrayList<String> writtenEntries = new ArrayList<String>(1);
        this.writeProperties(outFS, writtenEntries);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.updateAndWriteDependantRecords(baos, null);
        this._docstream = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        outFS.createDocument(bais, "PowerPoint Document");
        writtenEntries.add("PowerPoint Document");
        this.currentUser.writeToFS(outFS);
        writtenEntries.add("Current User");
        if (this._pictures == null) {
            this.readPictures();
        }
        if (this._pictures.size() > 0) {
            ByteArrayOutputStream pict = new ByteArrayOutputStream();
            for (PictureData p : this._pictures) {
                p.write(pict);
            }
            outFS.createDocument(new ByteArrayInputStream(pict.toByteArray()), "Pictures");
            writtenEntries.add("Pictures");
        }
        if (preserveNodes) {
            EntryUtils.copyNodes(this.directory.getFileSystem(), outFS, writtenEntries);
        }
        outFS.writeFilesystem(out);
    }

    public synchronized int appendRootLevelRecord(Record newRecord) {
        int addedAt = -1;
        Record[] r = new Record[this._records.length + 1];
        boolean added = false;
        for (int i = this._records.length - 1; i >= 0; --i) {
            if (added) {
                r[i] = this._records[i];
                continue;
            }
            r[i + 1] = this._records[i];
            if (!(this._records[i] instanceof PersistPtrHolder)) continue;
            r[i] = newRecord;
            added = true;
            addedAt = i;
        }
        this._records = r;
        return addedAt;
    }

    public int addPicture(PictureData img) {
        if (this._pictures == null) {
            try {
                this.readPictures();
            }
            catch (IOException e) {
                throw new CorruptPowerPointFileException(e.getMessage());
            }
        }
        int offset = 0;
        if (this._pictures.size() > 0) {
            PictureData prev = this._pictures.get(this._pictures.size() - 1);
            offset = prev.getOffset() + prev.getRawData().length + 8;
        }
        img.setOffset(offset);
        this._pictures.add(img);
        return offset;
    }

    public Record[] getRecords() {
        return this._records;
    }

    public byte[] getUnderlyingBytes() {
        return this._docstream;
    }

    public CurrentUserAtom getCurrentUserAtom() {
        return this.currentUser;
    }

    public PictureData[] getPictures() {
        if (this._pictures == null) {
            try {
                this.readPictures();
            }
            catch (IOException e) {
                throw new CorruptPowerPointFileException(e.getMessage());
            }
        }
        return this._pictures.toArray(new PictureData[this._pictures.size()]);
    }

    public ObjectData[] getEmbeddedObjects() {
        if (this._objects == null) {
            ArrayList<ObjectData> objects = new ArrayList<ObjectData>();
            for (Record r : this._records) {
                if (!(r instanceof ExOleObjStg)) continue;
                objects.add(new ObjectData((ExOleObjStg)r));
            }
            this._objects = objects.toArray(new ObjectData[objects.size()]);
        }
        return this._objects;
    }
}

